/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.component.publicscreen.chat.viewholder;

import android.graphics.Color;
import androidx.annotation.ColorInt;
import com.yy.appbase.common.Callback;
import com.yy.appbase.span.ChainSpan;
import com.yy.appbase.span.IChainSpan;
import com.yy.appbase.span.TextSpan;
import com.yy.base.logger.MLog;
import com.yy.base.utils.LanguageUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.hiyo.component.publicscreen.R;
import com.yy.hiyo.component.publicscreen.chat.bean.GiftChatMsgItem;
import com.yy.hiyo.component.publicscreen.chat.viewholder.TextHolder;

public class GiftTextBuilder
implements TextHolder.TextBuilder<GiftChatMsgItem> {
    private static final String TAG = "GiftTextBuilder";
    private static final String IMAGE_THUMBNAIL = YYImageUtils.getThumbnailPostfix((int)75);
    private static final int GIFT_ICON_SIZE = ResolutionUtils.dip2Px((float)25.0f);
    private static final int AVATAR_ICON_SIZE = ResolutionUtils.dip2Px((float)20.0f);
    private static final int AVATAR_ICON_MARGIN = ResolutionUtils.dip2Px((float)5.0f);
    @ColorInt
    private static final int COLOR_NAME = Color.parseColor((String)"#80ffffff");
    @ColorInt
    private static final int COLOR_SEND = Color.parseColor((String)"#fed77a");

    private String seatNum(int num) {
        switch (num) {
            case 0: {
                return "\u2460";
            }
            case 1: {
                return "\u2461";
            }
            case 2: {
                return "\u2462";
            }
            case 3: {
                return "\u2463";
            }
            case 4: {
                return "\u2464";
            }
            case 5: {
                return "\u2465";
            }
            case 6: {
                return "\u2466";
            }
            case 7: {
                return "\u2467";
            }
        }
        return "";
    }

    @Override
    public void buildText(TextHolder<GiftChatMsgItem> holder, GiftChatMsgItem data, Callback<CharSequence> callback) {
        if (LanguageUtils.isLtr()) {
            this.buildLtrText(holder, data, callback);
        } else {
            this.buildRtlText(holder, data, callback);
        }
    }

    private void buildLtrText(TextHolder<GiftChatMsgItem> holder, GiftChatMsgItem data, Callback<CharSequence> callback) {
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"buildLtrText", (Object[])new Object[0]);
        }
        IChainSpan span = ChainSpan.of().beginBlock().append((CharSequence)data.getSenderName(), new Object[]{TextSpan.of().size(13).color(COLOR_NAME).build()}).space().onBlockClick(() -> {
            MLog.info((Object)TAG, (String)"click sender", (Object[])new Object[0]);
            holder.onClickUser(data.getUid());
        }).endBlock().append(R.string.short_tips_gift_send, (Object)TextSpan.of().size(13).color(COLOR_SEND).build()).beginBlock().space().append((CharSequence)this.seatNum(data.getReceiverSeatNum()), new Object[]{TextSpan.of().size(13).color(COLOR_NAME).build()}).space().append((CharSequence)data.getReceiverName(), new Object[]{TextSpan.of().size(13).color(COLOR_NAME).build()}).onBlockClick(() -> holder.onClickUser(data.getReceiverUid())).endBlock().space().image(data.getGiftUrl() + IMAGE_THUMBNAIL, GIFT_ICON_SIZE, GIFT_ICON_SIZE, R.drawable.public_screen_gift).append((CharSequence)ResourceUtils.getString((int)R.string.short_tips_gift_combo, (Object[])new Object[]{String.valueOf(data.getGiftCount())}), new Object[]{TextSpan.of().size(13).color(-1).build()});
        this.setCharm(holder, data, span);
        span.onUpdate(arg_0 -> callback.onResponse(arg_0)).build();
    }

    private void buildRtlText(TextHolder<GiftChatMsgItem> holder, GiftChatMsgItem data, Callback<CharSequence> callback) {
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"buildRtlText", (Object[])new Object[0]);
        }
        IChainSpan span = ChainSpan.of().beginBlock().append((CharSequence)data.getSenderName(), new Object[]{TextSpan.of().size(13).color(COLOR_NAME).build()}).space().onBlockClick(() -> {
            MLog.info((Object)TAG, (String)"click sender", (Object[])new Object[0]);
            holder.onClickUser(data.getUid());
        }).endBlock().append(R.string.short_tips_gift_send, (Object)TextSpan.of().size(13).color(COLOR_SEND).build()).beginBlock().space().append((CharSequence)this.seatNum(data.getReceiverSeatNum()), new Object[]{TextSpan.of().size(13).color(COLOR_NAME).build()}).space().append((CharSequence)data.getReceiverName(), new Object[]{TextSpan.of().size(13).color(COLOR_NAME).build()}).onBlockClick(() -> holder.onClickUser(data.getReceiverUid())).endBlock().space().image(data.getGiftUrl() + IMAGE_THUMBNAIL, GIFT_ICON_SIZE, GIFT_ICON_SIZE, R.drawable.public_screen_gift).append((CharSequence)(data.getGiftCount() + "x"), new Object[]{TextSpan.of().size(13).color(-1).build()});
        this.setCharm(holder, data, span);
        span.onUpdate(arg_0 -> callback.onResponse(arg_0)).build();
    }

    private void setCharm(TextHolder<GiftChatMsgItem> holder, GiftChatMsgItem data, IChainSpan span) {
        int charm = data.getCharmValue();
        if (charm != 0) {
            span.append((CharSequence)",", new Object[]{TextSpan.of().size(13).color(-1).build()}).beginBlock().append((CharSequence)data.getReceiverName(), new Object[]{TextSpan.of().size(13).color(COLOR_NAME).build()}).onBlockClick(() -> holder.onClickUser(data.getReceiverUid())).endBlock().append((CharSequence)ResourceUtils.getString((int)R.string.short_summary_gift_charm, (Object[])new Object[]{charm}), new Object[]{TextSpan.of().size(13).color(-1).build()});
        }
    }
}

