/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.component.publicscreen.transform;

import biz.IMMsgItem;
import com.yy.base.logger.MLog;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.hiyo.channel.base.bean.MsgSection;
import com.yy.hiyo.channel.component.textgroup.GroupUtils;
import com.yy.hiyo.channel.publicscreen.BaseImMsg;
import com.yy.hiyo.channel.publicscreen.HideMsg;
import com.yy.hiyo.channel.publicscreen.HideMsgConfig;
import com.yy.hiyo.component.publicscreen.transform.BaseMsgTransform;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class HideMsgTransform
extends BaseMsgTransform {
    private static final String TAG = "HideMsgTransform";

    @Override
    public BaseImMsg transform(String msgId, IMMsgItem msgItem) {
        HideMsg hideMsg = new HideMsg(super.transform(msgId, msgItem));
        this.transformContent(msgId, hideMsg);
        return hideMsg;
    }

    private void transformContent(String msgId, HideMsg hideMsg) {
        List sections;
        if (GroupUtils.containFlag((long)hideMsg.getFlags(), (int)2) && (sections = hideMsg.getSections()) != null && !sections.isEmpty()) {
            for (MsgSection section : sections) {
                if (section.getType() != 2003) {
                    MLog.info((Object)TAG, (String)"type is not withdraw!!!", (Object[])new Object[0]);
                    return;
                }
                String content = section.getContent();
                MLog.info((Object)TAG, (String)"hide sys msg content:%s", (Object[])new Object[]{content});
                try {
                    JSONObject jsonObject = JsonParser.obtainJSONObject((String)content);
                    String sid = jsonObject.optString("sid");
                    String mid = jsonObject.optString("msgid");
                    int type = jsonObject.optInt("wtype", 0);
                    if (!StringUtils.isNotEmpty((String)sid) || !StringUtils.isNotEmpty((String)mid)) continue;
                    hideMsg.getHideMsgConfigs().add(new HideMsgConfig(sid, mid, type));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    MLog.error((Object)TAG, (String)"parse hide msg exception!!!content:%s", (Object[])new Object[]{content});
                }
            }
        }
    }

    public HideMsg transform(String msgId, BaseImMsg msgItem) {
        HideMsg hideMsg = new HideMsg(msgItem);
        this.transformContent(msgId, hideMsg);
        return hideMsg;
    }
}

