/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.component.publicscreen.transform;

import biz.IMMsgItem;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.service.IServiceManager;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.logger.MLog;
import com.yy.base.utils.json.JsonParser;
import com.yy.hiyo.channel.base.bean.MsgSection;
import com.yy.hiyo.channel.cbase.publicscreen.msg.ChallengeLv;
import com.yy.hiyo.channel.cbase.publicscreen.msg.GameChallengeMsg;
import com.yy.hiyo.channel.publicscreen.BaseImMsg;
import com.yy.hiyo.component.publicscreen.transform.BaseMsgTransform;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.service.IGameInfoService;
import com.yy.hiyo.game.service.IGameService;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001c\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u001c\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\bH\u0016J\u001a\u0010\r\u001a\u00020\u000e2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a8\u0006\u0017"}, d2={"Lcom/yy/hiyo/component/publicscreen/transform/ChallengeGameTransform;", "Lcom/yy/hiyo/component/publicscreen/transform/BaseMsgTransform;", "()V", "getChallengeLv", "Lcom/yy/hiyo/channel/cbase/publicscreen/msg/ChallengeLv;", "index", "", "transform", "Lcom/yy/hiyo/channel/publicscreen/BaseImMsg;", "msgId", "", "msgItem", "Lbiz/IMMsgItem;", "transformContent", "", "hideMsg", "Lcom/yy/hiyo/channel/cbase/publicscreen/msg/GameChallengeMsg;", "updateGameState", "sponsorUid", "", "gameValid", "", "Companion", "publicscreen_release"})
public final class ChallengeGameTransform
extends BaseMsgTransform {
    @NotNull
    public static final String TAG = "ChallengeGameTransform";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public BaseImMsg transform(@Nullable String msgId, @Nullable BaseImMsg msgItem) {
        GameChallengeMsg msg = new GameChallengeMsg(msgItem);
        this.transformContent(msgId, msg);
        return (BaseImMsg)msg;
    }

    @Override
    @NotNull
    public BaseImMsg transform(@Nullable String msgId, @Nullable IMMsgItem msgItem) {
        GameChallengeMsg msg = new GameChallengeMsg(super.transform(msgId, msgItem));
        this.transformContent(msgId, msg);
        return (BaseImMsg)msg;
    }

    private final void transformContent(String msgId, GameChallengeMsg hideMsg) {
        List sections = hideMsg.getSections();
        if (sections != null) {
            Collection collection = sections;
            boolean bl = false;
            if (!collection.isEmpty()) {
                Iterator iterator = sections.iterator();
                while (iterator.hasNext()) {
                    MsgSection section;
                    MsgSection msgSection = section = (MsgSection)iterator.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)msgSection, (String)"section");
                    if (msgSection.getType() != 3100) {
                        MLog.info((Object)TAG, (String)"type is not withdraw!!!", (Object[])new Object[0]);
                        return;
                    }
                    String content = section.getContent();
                    MLog.info((Object)TAG, (String)"hide sys msg content:%s", (Object[])new Object[]{content});
                    try {
                        GameInfo gameInfo;
                        JSONObject jsonObject = JsonParser.obtainJSONObject((String)content);
                        int winStreakAll = jsonObject.optInt("winStreakAll");
                        int winStreak = jsonObject.optInt("winStreak");
                        String gameId = jsonObject.optString("game_id");
                        int index = jsonObject.optInt("level", ChallengeLv.LOW.getIndex());
                        long sponsorUid = jsonObject.optLong("sponsorUid");
                        String teamId = jsonObject.optString("team_id");
                        String cardId = jsonObject.optString("card_id");
                        String string2 = teamId;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"teamId");
                        hideMsg.setTeamId(string2);
                        String string3 = cardId;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"cardId");
                        hideMsg.setCardId(string3);
                        hideMsg.setWinStreak(winStreak);
                        hideMsg.setWinStreakAll(winStreakAll);
                        hideMsg.setChallengeLv(this.getChallengeLv(index));
                        hideMsg.setSponsorUid(sponsorUid);
                        IServiceManager iServiceManager = ServiceManagerProxy.getServiceManager();
                        GameInfo gameInfo2 = iServiceManager != null && (iServiceManager = (IGameInfoService)iServiceManager.getService(IGameInfoService.class)) != null ? iServiceManager.getGameInfoByGid(gameId) : (gameInfo = null);
                        if (gameInfo == null) {
                            MLog.error((Object)TAG, (String)("game  " + gameId + '!'), (Object[])new Object[0]);
                            hideMsg.setGameValid(false);
                            hideMsg.setChallengeState(1);
                        } else {
                            IServiceManager iServiceManager2 = ServiceManagerProxy.getServiceManager();
                            boolean gameValid = iServiceManager2 != null && (iServiceManager2 = (IGameService)iServiceManager2.getService(IGameService.class)) != null ? iServiceManager2.isGameValid(gameInfo) : false;
                            hideMsg.setGameValid(gameValid);
                            hideMsg.setGameInfo(gameInfo);
                            this.updateGameState(hideMsg, sponsorUid, hideMsg.getGameValid());
                        }
                        MLog.info((Object)TAG, (String)("challengeState : " + hideMsg.getChallengeState()), (Object[])new Object[0]);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                        MLog.error((Object)TAG, (String)"parse hide msg exception!!!content:%s", (Object[])new Object[]{content});
                    }
                }
            }
        }
    }

    private final void updateGameState(GameChallengeMsg hideMsg, long sponsorUid, boolean gameValid) {
        if (hideMsg.getChallengeState() != 3 || hideMsg.getChallengeState() != 4) {
            if (sponsorUid == AccountUtil.getUid()) {
                if (gameValid) {
                    hideMsg.setChallengeState(2);
                } else {
                    hideMsg.setChallengeState(0);
                }
            } else {
                hideMsg.setChallengeState(5);
            }
        }
    }

    private final ChallengeLv getChallengeLv(int index) {
        return index == 1 ? ChallengeLv.LOW : (index == 2 ? ChallengeLv.MIDDLE : ChallengeLv.HIGH);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/yy/hiyo/component/publicscreen/transform/ChallengeGameTransform$Companion;", "", "()V", "TAG", "", "publicscreen_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

