/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.component.publicscreen.holder;

import android.content.Context;
import android.graphics.Paint;
import android.os.Message;
import android.text.SpannableStringBuilder;
import android.text.method.MovementMethod;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.TextView;
import com.scwang.smartrefresh.layout.util.DensityUtil;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.ui.utils.CrashCatchLinkMovementMethod;
import com.yy.appbase.ui.widget.FlowLayout;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.appbase.unifyconfig.config.HyperLinkConfig;
import com.yy.appbase.unifyconfig.config.HyperLinkConfigData;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.hiyo.channel.base.IChannelCenterService;
import com.yy.hiyo.channel.base.bean.ActionDefine;
import com.yy.hiyo.channel.base.bean.FamilyInfoBean;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.base.service.familypartyactivity.FamilyPartyModuleData;
import com.yy.hiyo.channel.base.service.familypartyactivity.IFamilyPartyActivityService;
import com.yy.hiyo.channel.cbase.publicscreen.msg.PureTextMsg;
import com.yy.hiyo.channel.component.base.util.HyperLinkUtil;
import com.yy.hiyo.channel.component.publicscreen.holder.MsgLeadingMarginSpan;
import com.yy.hiyo.channel.publicscreen.BaseImMsg;
import com.yy.hiyo.component.publicscreen.R;
import com.yy.hiyo.component.publicscreen.helper.FirstChargeReportHelper;
import com.yy.hiyo.component.publicscreen.holder.AbsMsgTitleBarHolder;
import com.yy.hiyo.component.publicscreen.msg.BubbleMessage;
import com.yy.hiyo.component.publicscreen.msg.GiftMsg;
import com.yy.hiyo.component.publicscreen.theme.IThemeRes;
import com.yy.hiyo.component.publicscreen.widge.BaseUserTitleView;
import net.ihago.money.api.familyparty.ActStatus;
import org.jetbrains.annotations.NotNull;

public class PureTextHolder
extends AbsMsgTitleBarHolder<PureTextMsg> {
    private static final String TAG = "PureTextHolder";
    private static final int DP_5_IN_DIMEN = ResourceUtils.getDimen((int)R.dimen.dp_5);
    private static final int DP_2_IN_DIMEN = ResourceUtils.getDimen((int)R.dimen.dp_2);
    private int recyclerViewWidth = 0;
    private YYTextView tvText;
    private YYTextView tvTag;
    private RecycleImageView mIvFamilyParty;
    private YYLinearLayout mLlContainer;
    private RecycleImageView ivChargeLabel;
    private View[] mViews = new View[2];
    private BaseUserTitleView titleView;

    public PureTextHolder(@NotNull View v, boolean self, int viewType) {
        super(v, self, viewType);
        this.tvText = (YYTextView)this.itemView.findViewById(R.id.tv_c_text);
        this.titleView = (BaseUserTitleView)this.itemView.findViewById(R.id.butv_c);
        this.tvTag = (YYTextView)this.itemView.findViewById(R.id.tvTag);
        this.mIvFamilyParty = (RecycleImageView)this.itemView.findViewById(R.id.iv_family_party);
        this.mLlContainer = (YYLinearLayout)this.itemView.findViewById(R.id.ll_container);
        this.ivChargeLabel = (RecycleImageView)this.itemView.findViewById(R.id.iv_charge_label);
        this.tvText.setMovementMethod((MovementMethod)CrashCatchLinkMovementMethod.getInstance());
        this.mViews[0] = this.itemView;
        this.mViews[1] = this.tvText;
        this.tvText.setOnClickListener(v1 -> {
            if (this.tvText.getSelectionStart() == -1 && this.tvText.getSelectionEnd() == -1 && this.mActionHandler != null) {
                Message msg = Message.obtain();
                msg.obj = this.getItemMsg();
                msg.what = ActionDefine.CLICK_PURE_TEXT_MSG;
                this.mActionHandler.onAction(msg);
            }
        });
        this.itemView.setOnClickListener(v12 -> {
            if (this.mActionHandler != null) {
                Message msg = Message.obtain();
                msg.obj = this.getItemMsg();
                msg.what = ActionDefine.CLICK_PURE_TEXT_ITEM;
                this.mActionHandler.onAction(msg);
            }
        });
        this.titleView.setOnMeasuredListener((width, height) -> this.updateText());
    }

    @KvoMethodAnnotation(name="isFirstCharge", sourceClass=BaseImMsg.class, thread=1)
    public void updateFirstCharge(KvoEventIntent event) {
        this.updateTag();
    }

    private void updateTag() {
        Object extendInfo;
        if (this.tvTag == null) {
            return;
        }
        boolean isNewUser = false;
        if (this.mActionHandler != null && (extendInfo = this.mActionHandler.getExtendInfo("isNewComer", new Object())) instanceof Boolean) {
            isNewUser = (Boolean)extendInfo;
        }
        if (((PureTextMsg)this.getItemMsg()).isFirstCharge()) {
            if (this.ivChargeLabel.getVisibility() == 8) {
                this.reportChargeShow();
            }
            this.ivChargeLabel.setVisibility(0);
            this.tvTag.setVisibility(8);
        } else if (((PureTextMsg)this.getItemMsg()).isNewComer() && !isNewUser) {
            this.ivChargeLabel.setVisibility(8);
            this.tvTag.setVisibility(0);
        } else {
            this.ivChargeLabel.setVisibility(8);
            this.tvTag.setVisibility(8);
        }
        int padding = DensityUtil.dp2px((float)2.0f);
        if (this.tvTag.getVisibility() != 0 && this.ivChargeLabel.getVisibility() != 0) {
            if (((PureTextMsg)this.getItemMsg()).hasPartyLabel()) {
                this.mIvFamilyParty.setVisibility(0);
                this.mLlContainer.setPadding(padding, padding, padding, padding);
            } else if (this.self && this.isInFamilyParty()) {
                this.mIvFamilyParty.setVisibility(0);
                this.mLlContainer.setPadding(padding, padding, padding, padding);
            } else {
                this.mIvFamilyParty.setVisibility(8);
                this.mLlContainer.setPadding(0, 0, 0, 0);
            }
        } else {
            this.mIvFamilyParty.setVisibility(8);
            this.mLlContainer.setPadding(0, 0, 0, 0);
        }
        this.tvTag.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ToastUtils.showToast((Context)PureTextHolder.this.tvTag.getContext(), (int)R.string.tip_new_user_tag_click);
            }
        });
        this.ivChargeLabel.setOnClickListener(v -> {
            ToastUtils.showToast((Context)this.tvTag.getContext(), (int)R.string.tips_click_first_charge_label);
            this.reportChargeClick();
        });
    }

    @Override
    public void bindView(PureTextMsg newData, int position) {
        super.bindView(newData, position);
        this.updateTag();
    }

    private boolean isInFamilyParty() {
        FamilyPartyModuleData activityInfo = ((IFamilyPartyActivityService)ServiceManagerProxy.getService(IFamilyPartyActivityService.class)).getFamilyPartyActivity();
        IChannel channel = ((IChannelCenterService)ServiceManagerProxy.getService(IChannelCenterService.class)).getCurrentChannel();
        FamilyInfoBean familyInfo = channel.getFamilyService().getCachedMyFamilyInfo();
        return activityInfo != null && activityInfo.getActivity() != null && familyInfo != null && activityInfo.getActivityState() == ActStatus.Beginning.getValue() && channel != null && StringUtils.equal((String)activityInfo.getActivity().cid, (String)channel.getChannelId()) && StringUtils.equal((String)activityInfo.getActivity().family.fid, (String)familyInfo.getFid());
    }

    @KvoMethodAnnotation(name="refreshForce", sourceClass=PureTextMsg.class, thread=1)
    final void onForceChange(@NotNull KvoEventIntent event) {
        this.onTextChanged();
    }

    @KvoMethodAnnotation(name="msgText", sourceClass=PureTextMsg.class, thread=1)
    final void onMsgTextChange(@NotNull KvoEventIntent event) {
        this.onTextChanged();
    }

    private void onTextChanged() {
        if (this.tvText == null) {
            return;
        }
        this.tvText.setAutoLinkMask(0);
        if (this.mThemeRes != null && this.mThemeRes.getCurrentMode() == 1) {
            AConfigData configData = UnifyConfig.INSTANCE.getConfigData(BssCode.HYPER_LINK_INTERCEPT_CONFIG);
            if (configData instanceof HyperLinkConfig) {
                HyperLinkConfigData data = ((HyperLinkConfig)configData).getData();
                if (data == null || data.getEnableHyperLink()) {
                    this.tvText.setAutoLinkMask(1);
                }
            } else {
                this.tvText.setAutoLinkMask(1);
            }
        }
        if (this.mThemeRes != null && this.mThemeRes.getThemePackage("msg_text") != null && this.mThemeRes.getThemePackage("msg_text").getTextLinkColor() != 0) {
            this.tvText.setLinkTextColor(this.mThemeRes.getThemePackage("msg_text").getTextLinkColor());
        }
        if (this.mThemeRes != null && this.mThemeRes.getCurrentMode() == 1) {
            HyperLinkUtil.INSTANCE.interceptHyperLink((TextView)this.tvText, null);
        }
        this.updateText();
    }

    private void updateText() {
        boolean isBaseMode;
        CharSequence msgText;
        CharSequence charSequence = msgText = this.getItemMsg() == null ? null : ((PureTextMsg)this.getItemMsg()).getMsgText();
        if (msgText == null || msgText.length() == 0) {
            return;
        }
        MLog.debug((Object)TAG, (String)"hash: %d, updateText %s", (Object[])new Object[]{((Object)((Object)this)).hashCode(), msgText});
        boolean bl = isBaseMode = this.mThemeRes != null && this.mThemeRes.getCurrentMode() == 1;
        if (isBaseMode) {
            this.tvText.setText(msgText);
        } else {
            int offset = this.calculateTextIndentOffset((ViewGroup.MarginLayoutParams)this.tvText.getLayoutParams());
            this.setTextIndent(msgText, offset);
        }
    }

    private int calculateTextIndentOffset(ViewGroup.MarginLayoutParams params) {
        FlowLayout flowLayout = this.titleView.getFlowLayout();
        int topOffset = 0;
        if (flowLayout.getRowsCount() > 0) {
            int maxHeight = flowLayout.getHeightForRow(flowLayout.getRowsCount() - 1);
            Paint.FontMetrics metrics = this.tvText.getPaint().getFontMetrics();
            int textHeight = (int)(metrics.descent - metrics.ascent);
            topOffset = textHeight + (maxHeight - textHeight) / 2;
            MLog.debug((Object)TAG, (String)"rowSize %d, maxHeight %d, textHeight %d, topOffset %d", (Object[])new Object[]{flowLayout.getRowsCount(), maxHeight, textHeight, topOffset});
        }
        int lastRowWidth = flowLayout.getLastRowWidth();
        this.makeSureRecyclerViewWidth();
        MLog.debug((Object)TAG, (String)("recyclerViewWidth = " + this.recyclerViewWidth + ", lastRowWidth = " + lastRowWidth), (Object[])new Object[0]);
        if (this.recyclerViewWidth > 0 && (double)((float)lastRowWidth / (float)this.recyclerViewWidth) <= 0.9) {
            params.topMargin = -topOffset;
            this.tvText.setLayoutParams((ViewGroup.LayoutParams)params);
            return lastRowWidth + DP_2_IN_DIMEN;
        }
        params.topMargin = DP_5_IN_DIMEN;
        this.tvText.setLayoutParams((ViewGroup.LayoutParams)params);
        return 0;
    }

    @Override
    protected View[] getLongClickView() {
        return this.mViews;
    }

    @Override
    protected void updateThemeLayout(@NotNull IThemeRes themeRes, boolean isSimplify) {
        super.updateThemeLayout(themeRes, isSimplify);
        this.setTitleSingleLine(true);
        this.updateText();
        if (this.getItemMsg() instanceof GiftMsg) {
            ((GiftMsg)this.getItemMsg()).buildContent(isSimplify);
        } else if (this.getItemMsg() instanceof BubbleMessage) {
            ((BubbleMessage)this.getItemMsg()).build();
        }
    }

    private void setTextIndent(CharSequence text, int indentDistance) {
        MLog.debug((Object)TAG, (String)("setTextIndent: " + text + ", indentDistance: " + indentDistance), (Object[])new Object[0]);
        SpannableStringBuilder builder = new SpannableStringBuilder(text);
        MsgLeadingMarginSpan standard = new MsgLeadingMarginSpan(1, indentDistance);
        int end = text.toString().indexOf("\n");
        if (end == -1) {
            end = builder.length();
        }
        builder.setSpan((Object)standard, 0, end, 17);
        this.tvText.setText((CharSequence)builder);
    }

    private void makeSureRecyclerViewWidth() {
        if (this.recyclerViewWidth != 0) {
            return;
        }
        ViewParent parent = this.itemView.getParent();
        if (parent == null) {
            return;
        }
        this.recyclerViewWidth = ((View)parent).getWidth();
    }

    private void reportChargeShow() {
        if (this.mActionHandler != null) {
            Object pluginId = this.mActionHandler.getExtendInfo("pluginId", new Object());
            Object pluginMode = this.mActionHandler.getExtendInfo("pluginMode", new Object());
            if (pluginId instanceof String && pluginMode instanceof Integer) {
                FirstChargeReportHelper.reportLabelShow((Integer)pluginMode, (String)pluginId);
            }
        }
    }

    private void reportChargeClick() {
        if (this.mActionHandler != null) {
            Object pluginId = this.mActionHandler.getExtendInfo("pluginId", new Object());
            Object pluginMode = this.mActionHandler.getExtendInfo("pluginMode", new Object());
            if (pluginId instanceof String && pluginMode instanceof Integer) {
                FirstChargeReportHelper.reportLabelClick((Integer)pluginMode, (String)pluginId);
            }
        }
    }
}

