/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.component.publicscreen.holder;

import android.view.View;
import android.widget.ImageView;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.appbase.data.UserInfoBean;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.callback.OnProfileListCallback;
import com.yy.appbase.ui.widget.image.RoundImageView;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.event.kvo.helper.KvoBinder;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.logger.MLog;
import com.yy.base.utils.YYImageUtils;
import com.yy.hiyo.component.publicscreen.R;
import com.yy.hiyo.relation.base.IRelationService;
import com.yy.hiyo.relation.base.data.RelationInfo;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.List;
import net.ihago.room.srv.follow.EPath;
import okhttp3.Call;

public class LatentFriendViewHolder
extends RecyclerView.ViewHolder {
    private static String TAG = "LatentFriendViewHolder";
    private RoundImageView avatar;
    private RoundImageView followBt;
    private KvoBinder kvoBinder = new KvoBinder((Object)this);
    private long userUid = 0L;

    public LatentFriendViewHolder(View itemView) {
        super(itemView);
        this.avatar = (RoundImageView)itemView.findViewById(R.id.iv_user);
        this.followBt = (RoundImageView)itemView.findViewById(R.id.bt_follow);
        itemView.setOnClickListener(v -> {
            if (this.userUid != 0L) {
                RelationInfo info = ((IRelationService)ServiceManagerProxy.getService(IRelationService.class)).getRelationLocal(this.userUid);
                ((IRelationService)ServiceManagerProxy.getService(IRelationService.class)).requestFollow(info, EPath.PATH_VOICE.getValue());
                this.reportPushShow(this.userUid);
            }
        });
    }

    private void reportPushShow(long uid) {
        String followUid = String.valueOf(uid);
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("60129334").put("function_id", "g_follow_click").put("click_to_follow", "1").put("follow_uid", followUid));
    }

    public void bindView(long uid) {
        RelationInfo info;
        if (ServiceManagerProxy.getService(IRelationService.class) != null && (info = ((IRelationService)ServiceManagerProxy.getService(IRelationService.class)).getRelationLocal(uid)) != null) {
            this.kvoBinder.singleBindSourceTo((KvoSource)info);
        }
        this.userUid = uid;
        ((IUserInfoService)ServiceManagerProxy.getService(IUserInfoService.class)).getUserInfo(uid, new OnProfileListCallback(){

            public void onUISuccess(List<UserInfoBean> userInfo) {
                MLog.info((Object)TAG, (String)"onUISuccess", (Object[])new Object[0]);
                if (userInfo != null && !userInfo.isEmpty()) {
                    ImageLoader.loadImage((ImageView)LatentFriendViewHolder.this.avatar, (String)(userInfo.get(0).getAvatar() + YYImageUtils.getThumbnailPostfix((int)75)));
                }
            }

            public void onError(@Nullable Call call, @Nullable Exception e, int id2) {
                MLog.error((Object)TAG, (String)("onError id:" + id2), (Object[])new Object[0]);
            }

            public void onResponseError(int id2, @Nullable String message, @Nullable String response) {
                MLog.error((Object)TAG, (String)("onResponseError message:$message id:" + id2), (Object[])new Object[0]);
            }
        });
    }

    @KvoMethodAnnotation(name="relation", sourceClass=RelationInfo.class, thread=1)
    private void onFollowStatusChanged(KvoEventIntent event) {
        RelationInfo info = (RelationInfo)event.source();
        if (info != null) {
            if (info.isFollow()) {
                ImageLoader.loadImage((ImageView)this.followBt, (int)R.drawable.icon_latent_friend_follow);
            } else {
                ImageLoader.loadImage((ImageView)this.followBt, (int)R.drawable.icon_latent_friend_un_follow);
            }
        }
    }
}

