/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.component.publicscreen.holder;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.os.Message;
import android.view.View;
import android.view.animation.LinearInterpolator;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import com.yy.appbase.callback.SimpleAnimatorListener;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.ui.widget.image.CircleImageView;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.hiyo.channel.base.bean.ActionDefine;
import com.yy.hiyo.component.publicscreen.R;
import com.yy.hiyo.component.publicscreen.holder.AbsMsgItemHolder;
import com.yy.hiyo.component.publicscreen.msg.FollowGuideMsg;
import com.yy.hiyo.relation.base.IRelationService;
import com.yy.hiyo.relation.base.data.RelationInfo;

public class FollowGuideHolder
extends AbsMsgItemHolder<FollowGuideMsg>
implements View.OnClickListener {
    private static final String TAG = "FollowUserHolder";
    protected RecycleImageView ivFollowed;
    private CircleImageView ivHead;
    protected YYTextView tvContent;
    private YYTextView tvName;
    protected boolean isFollowed = false;
    protected ObjectAnimator followAnimator = null;
    private RelationInfo relationInfo;
    protected boolean isFollowing = false;
    private Runnable timeOut = () -> {
        if (this.followAnimator != null && this.followAnimator.isRunning()) {
            this.followAnimator.cancel();
        }
    };

    public FollowGuideHolder(@NonNull View itemView) {
        super(itemView, false);
        this.ivFollowed = (RecycleImageView)itemView.findViewById(R.id.iv_follow);
        this.ivHead = (CircleImageView)itemView.findViewById(R.id.iv_c_head);
        this.tvContent = (YYTextView)itemView.findViewById(R.id.tv_content);
        this.tvName = (YYTextView)itemView.findViewById(R.id.tv_name);
        this.ivFollowed.setOnClickListener((View.OnClickListener)this);
        this.ivHead.setOnClickListener((View.OnClickListener)this);
    }

    public void onClick(View v) {
        if (v.getId() == R.id.iv_follow) {
            this.onClickFollow();
        } else if (v.getId() == R.id.iv_c_head) {
            this.onClickHead();
        }
    }

    private void onClickHead() {
        if (this.mActionHandler != null) {
            Message msg = Message.obtain();
            msg.what = ActionDefine.SHOW_USER_PROFILE;
            msg.obj = ((FollowGuideMsg)((Object)this.getItemMsg())).getFollowUid();
            this.mActionHandler.onAction(msg);
        }
    }

    private void onClickFollow() {
        MLog.info((Object)TAG, (String)"follow user clicked", (Object[])new Object[0]);
        if (this.isFollowing) {
            return;
        }
        if (this.mActionHandler != null) {
            Message msg = Message.obtain();
            msg.what = ActionDefine.CLICK_GUIGE_FOLLOW_BTN;
            msg.obj = this.getItemMsg();
            this.mActionHandler.onAction(msg);
            this.isFollowing = true;
            this.startRotationAnim();
        }
    }

    @Override
    public void bindView(FollowGuideMsg item, int position) {
        super.bindView(item, position);
        this.showItemView(item);
        this.mBinder.clearKvoConnection("relation");
        Long followUid = item.getFollowUid();
        this.relationInfo = ((IRelationService)ServiceManagerProxy.getInstance().getService(IRelationService.class)).getRelationLocal(followUid.longValue());
        this.mBinder.singleBindSourceTo("relation", (KvoSource)this.relationInfo);
    }

    private void showItemView(FollowGuideMsg item) {
        this.itemView.setAlpha(1.0f);
        int defaultAvatar = R.drawable.icon_avatar_default_female;
        if (item.getFollowSex() == 1) {
            defaultAvatar = R.drawable.icon_avatar_default_male;
        }
        ImageLoader.loadImage((ImageView)this.ivHead, (String)(item.getFollowAvater() + YYImageUtils.getThumbnailPostfix((int)75, (boolean)true)), (int)defaultAvatar);
        this.tvName.setText((CharSequence)item.getFollowName());
        String content = ((FollowGuideMsg)((Object)this.getItemMsg())).getContentType() == 1L ? ResourceUtils.getString((int)R.string.tip_at_guide_follow_msg, (Object[])new Object[]{((FollowGuideMsg)((Object)this.getItemMsg())).getFollowName()}) : (((FollowGuideMsg)((Object)this.getItemMsg())).getContentType() == 2L ? ResourceUtils.getString((int)R.string.tip_sendgift_guide_follow_msg, (Object[])new Object[]{((FollowGuideMsg)((Object)this.getItemMsg())).getFollowName()}) : " ");
        this.tvContent.setText((CharSequence)content);
    }

    @KvoMethodAnnotation(name="relation", sourceClass=RelationInfo.class, thread=1)
    public void updateFollowStatus(KvoEventIntent event) {
        RelationInfo mRelation = (RelationInfo)event.source();
        this.updateFollowState(mRelation);
    }

    protected void updateFollowState(RelationInfo mRelation) {
        this.isFollowing = false;
        this.stopRotationAnim();
        if (this.getItemMsg() == null || mRelation == null) {
            return;
        }
        if (mRelation.isFollow()) {
            this.showFollowedStateView();
        } else {
            this.showUnFollowedStateView();
        }
    }

    private void showFollowedStateView() {
        YYTaskExecutor.removeTask((Runnable)this.timeOut);
        this.isFollowed = true;
        this.ivFollowed.setRotation(0.0f);
        this.ivFollowed.setVisibility(8);
    }

    private void showUnFollowedStateView() {
        this.isFollowed = false;
        this.ivFollowed.setImageResource(R.drawable.icon_top_video_follow);
        this.ivFollowed.setBackgroundResource(R.drawable.bg_white_10_corner);
        this.ivFollowed.setRotation(0.0f);
        this.ivFollowed.setVisibility(0);
        this.stopRotationAnim();
    }

    private void stopRotationAnim() {
        if (this.followAnimator != null) {
            this.followAnimator.end();
            this.followAnimator = null;
        }
    }

    protected void startRotationAnim() {
        YYTaskExecutor.removeTask((Runnable)this.timeOut);
        YYTaskExecutor.postToMainThread((Runnable)this.timeOut, (long)5000L);
        this.ivFollowed.setImageResource(R.drawable.icon_radio_following);
        this.ivFollowed.setBackgroundResource(R.color.transparent);
        this.ivFollowed.setVisibility(0);
        this.followAnimator = ObjectAnimator.ofFloat((Object)this.ivFollowed, (String)"rotation", (float[])new float[]{0.0f, 360.0f});
        this.followAnimator.setDuration(1000L);
        this.followAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        this.followAnimator.setRepeatCount(-1);
        this.followAnimator.addListener((Animator.AnimatorListener)new SimpleAnimatorListener(){

            public void onAnimationCancel(Animator animation) {
                FollowGuideHolder.this.onAnimationCancel();
            }
        });
        this.followAnimator.start();
    }

    protected void onAnimationCancel() {
        this.updateFollowState(this.relationInfo);
    }
}

