/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.proto.preventduplicater;

import android.os.SystemClock;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import com.squareup.wire.AndroidMessage;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.DefaultCacheEffectiveTimeUtil;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.hiyo.proto.preventduplicater.IProtoRequestRealSender;
import com.yy.hiyo.proto.rpc.RpcMethod;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseProtoPreventDuplicater<REQ extends AndroidMessage<REQ, ?>, RES extends AndroidMessage<RES, ?>> {
    protected String tag = "";
    private long startTime;
    private String roomId = "";
    protected REQ request;
    private final ArrayList<IProtoCallback<RES>> callBacks = new ArrayList(3);
    private long lastResStartTime;
    protected REQ lastResRequest;
    private RES lastResMessage;
    private long lastResCode;
    private String lastResMsgTip;
    private String lastResRoomId = "";
    private long lastObtainCacheEffectiveTime;
    private IProtoPreventDuplicaterCallback mCallback;
    private int preventNumInCacheTime = 0;
    private long lastCacheStartTime = 0L;
    private Runnable recycleResponse = null;

    public BaseProtoPreventDuplicater(IProtoPreventDuplicaterCallback callback) {
        this.mCallback = callback;
    }

    public void send(REQ proto, @Nullable IProtoCallback<RES> callback, IRequestCompare<REQ> compare) {
        this.send("", proto, callback, compare);
    }

    public void send(String roomId, REQ proto, @Nullable IProtoCallback<RES> callback, IRequestCompare<REQ> compare) {
        this.send(roomId, proto, null, callback, compare, null);
    }

    private int canUseCacheData(String roomId, REQ proto, RpcMethod<REQ, RES> rpcMethod, IRequestCompare<REQ> compare, long cacheEffectiveTime, long curTime) {
        if (this.lastResMessage != null && StringUtils.equal((String)roomId, (String)this.lastResRoomId)) {
            if (curTime <= 0L) {
                curTime = SystemClock.uptimeMillis();
            }
            if (curTime > 0L && curTime - this.lastResStartTime < cacheEffectiveTime) {
                if (compare != null && proto != null && this.lastResRequest != null && compare.equal(this.lastResRequest, proto)) {
                    if (this.preventNumInCacheTime == 0) {
                        this.lastCacheStartTime = curTime;
                    } else if (curTime - this.lastCacheStartTime > 60000L) {
                        this.lastCacheStartTime = curTime;
                        this.preventNumInCacheTime = 0;
                    }
                    ++this.preventNumInCacheTime;
                    MLog.info((Object)this.tag, (String)"hit cache:1, happen prevent duplicate num:%d, allRequestNum:%d!", (Object[])new Object[]{++DefaultCacheEffectiveTimeUtil.sProtoPreventNum, DefaultCacheEffectiveTimeUtil.sHttpAllRequestNum});
                    return 1;
                }
                if (SystemUtils.isShowEnvSetting()) {
                    MLog.info((Object)this.tag, (String)"hit cache:0, by request params not equal!", (Object[])new Object[0]);
                    return 3;
                }
            } else {
                this.preventNumInCacheTime = 0;
                return 2;
            }
        }
        return 3;
    }

    private int hasRequestSending(String roomId, REQ proto, RpcMethod<REQ, RES> rpcMethod, IRequestCompare<REQ> compare, long cacheEffectiveTime, long curTime) {
        if (this.isStarted()) {
            if (!StringUtils.equal((String)roomId, (String)this.roomId)) {
                if (RuntimeContext.isInGray()) {
                    MLog.info((Object)this.tag, (String)"hit cache:0, by roomid not equal:%s,%s,class:%s!", (Object[])new Object[]{roomId, this.roomId, proto.getClass()});
                }
                return 3;
            }
            if (this.request != null) {
                if (curTime == -1L) {
                    curTime = SystemClock.uptimeMillis();
                }
                if (curTime == 0L || curTime - this.startTime > cacheEffectiveTime) {
                    this.preventNumInCacheTime = 0;
                    if (RuntimeContext.isInGray()) {
                        MLog.info((Object)this.tag, (String)"hit cache:0, has a request is sending, but time out!", (Object[])new Object[0]);
                    }
                    return 2;
                }
                if (compare != null && proto != null && this.request != null && compare.equal(this.request, proto)) {
                    if (this.preventNumInCacheTime == 0) {
                        this.lastCacheStartTime = curTime;
                    } else if (curTime - this.lastCacheStartTime > 60000L) {
                        this.lastCacheStartTime = curTime;
                        this.preventNumInCacheTime = 0;
                    }
                    ++DefaultCacheEffectiveTimeUtil.sProtoPreventNum;
                    ++this.preventNumInCacheTime;
                    return 1;
                }
                if (RuntimeContext.isInGray()) {
                    MLog.info((Object)this.tag, (String)"hit cache:0, has a request is sending, but params not equal!", (Object[])new Object[0]);
                }
                return 3;
            }
            return 4;
        }
        return 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(String roomId, REQ proto, RpcMethod<REQ, RES> rpcMethod, final @Nullable IProtoCallback<RES> callback, IRequestCompare<REQ> compare, IProtoRequestRealSender sender) {
        int hasRequestSending;
        if (roomId == null) {
            roomId = "";
        }
        long cacheEffectiveTime = -1L;
        if (this.mCallback != null) {
            cacheEffectiveTime = this.mCallback.getDefaultProtoCacheEffectiveTime(callback, compare);
        } else {
            long l = cacheEffectiveTime = callback != null ? callback.getCacheEffectiveTime() : DefaultCacheEffectiveTimeUtil.getDefaultProtoCacheEffectiveTime();
        }
        if (cacheEffectiveTime <= 0L) {
            if (sender != null) {
                sender.sendProtoRequest(roomId, proto, rpcMethod, callback, this.isWsRequest());
            } else {
                if (SystemUtils.isShowEnvSetting()) {
                    throw new RuntimeException("");
                }
                this.sendInner(roomId, proto, this.getMyProtoCallback(roomId, proto, SystemClock.uptimeMillis(), callback));
            }
            return;
        }
        if (StringUtils.isEmpty((String)this.tag) && compare != null) {
            this.tag = "RequestPreventer_Proto_" + compare.serviceName() + "_" + compare.methodName();
        }
        ++DefaultCacheEffectiveTimeUtil.sProtoAllRequestNum;
        long curTime = -1L;
        if (this.lastResMessage != null) {
            curTime = SystemClock.uptimeMillis();
        }
        this.lastObtainCacheEffectiveTime = cacheEffectiveTime;
        AndroidMessage fLastResMessage = null;
        long fLastResCode = -1L;
        String fLastResMsgTip = null;
        long fLastResStartTime = -1L;
        Object fLastResRequest = null;
        int cacheDataType = 3;
        BaseProtoPreventDuplicater baseProtoPreventDuplicater = this;
        synchronized (baseProtoPreventDuplicater) {
            cacheDataType = this.canUseCacheData(roomId, proto, rpcMethod, compare, cacheEffectiveTime, curTime);
            if (cacheDataType == 1 || cacheDataType == 2) {
                fLastResMessage = (AndroidMessage)this.lastResMessage;
                fLastResCode = this.lastResCode;
                fLastResMsgTip = this.lastResMsgTip;
                fLastResStartTime = this.lastResStartTime;
                fLastResRequest = this.lastResRequest;
            }
        }
        if (cacheDataType == 1 && fLastResMessage != null) {
            if (this.mCallback != null) {
                this.mCallback.onDuplicateRequest(false, compare, DefaultCacheEffectiveTimeUtil.sProtoPreventNum, DefaultCacheEffectiveTimeUtil.sHttpAllRequestNum, this.preventNumInCacheTime);
            }
            final AndroidMessage fFLastResMessage = fLastResMessage;
            final long fFLastResCode = fLastResCode;
            final String fFLastResMsgTip = fLastResMsgTip;
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (callback != null) {
                        callback.onResponse(fFLastResMessage, fFLastResCode, fFLastResMsgTip);
                    }
                }
            });
            return;
        }
        if (cacheDataType == 2) {
            this.preventNumInCacheTime = 0;
            if (this.mCallback != null) {
                this.mCallback.maybeDuplicateRequest(this, fLastResStartTime, compare, fLastResRequest, proto);
            }
        } else {
            MLog.info((Object)this.tag, (String)"hit cache:0, by request params not equal!", (Object[])new Object[0]);
        }
        BaseProtoPreventDuplicater fFLastResCode = this;
        synchronized (fFLastResCode) {
            hasRequestSending = this.hasRequestSending(roomId, proto, rpcMethod, compare, cacheEffectiveTime, curTime);
            if (hasRequestSending == 1) {
                this.addCallBack(callback);
            } else if (hasRequestSending == 4) {
                this.roomId = roomId;
                this.onStart(proto, callback);
            }
        }
        if (hasRequestSending == 1) {
            if (this.mCallback != null) {
                this.mCallback.onDuplicateRequest(true, compare, DefaultCacheEffectiveTimeUtil.sProtoPreventNum, DefaultCacheEffectiveTimeUtil.sHttpAllRequestNum, this.preventNumInCacheTime);
            }
            MLog.info((Object)this.tag, (String)"hit cache:1, has a request is sending, happen prevent duplicate num:%d, allRequestNum:%d!", (Object[])new Object[]{DefaultCacheEffectiveTimeUtil.sProtoPreventNum, DefaultCacheEffectiveTimeUtil.sHttpAllRequestNum});
        } else if (hasRequestSending == 2 || hasRequestSending == 3) {
            if (curTime == -1L) {
                curTime = SystemClock.uptimeMillis();
            }
            if (sender != null) {
                sender.sendProtoRequest(roomId, proto, rpcMethod, this.getMyProtoCallback(roomId, proto, curTime, callback), this.isWsRequest());
            } else {
                if (SystemUtils.isShowEnvSetting()) {
                    throw new RuntimeException("");
                }
                this.sendInner(roomId, proto, this.getMyProtoCallback(roomId, proto, curTime, callback));
            }
        } else {
            IProtoCallback theCallback = new IProtoCallback<RES>(){

                @Override
                public boolean retryWhenTimeout(boolean canRetry) {
                    return BaseProtoPreventDuplicater.this.retryWhenTimeoutInner(canRetry);
                }

                @Override
                public boolean retryWhenError(boolean canRetry, String reason, int code) {
                    return BaseProtoPreventDuplicater.this.retryWhenErrorInner(canRetry, reason, code);
                }

                @Override
                @Deprecated
                @UiThread
                public void onResponse(@Nullable RES message) {
                    BaseProtoPreventDuplicater.this.onResponseInner(message);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                @UiThread
                public void onResponse(@NonNull RES message, long code, String msg) {
                    List callBacks;
                    BaseProtoPreventDuplicater baseProtoPreventDuplicater = BaseProtoPreventDuplicater.this;
                    synchronized (baseProtoPreventDuplicater) {
                        if (ProtoManager.isSuccessCode(code) && (BaseProtoPreventDuplicater.this.lastResMessage == null || BaseProtoPreventDuplicater.this.lastResStartTime < BaseProtoPreventDuplicater.this.startTime)) {
                            BaseProtoPreventDuplicater.this.lastResMessage = message;
                            BaseProtoPreventDuplicater.this.lastResRequest = BaseProtoPreventDuplicater.this.request;
                            BaseProtoPreventDuplicater.this.lastResStartTime = BaseProtoPreventDuplicater.this.startTime;
                            BaseProtoPreventDuplicater.this.lastResCode = code;
                            BaseProtoPreventDuplicater.this.lastResMsgTip = msg;
                            BaseProtoPreventDuplicater.this.lastResRoomId = BaseProtoPreventDuplicater.this.roomId;
                        }
                        callBacks = BaseProtoPreventDuplicater.this.getCallBacks();
                        BaseProtoPreventDuplicater.this.onFinish();
                    }
                    BaseProtoPreventDuplicater.this.recycleResponse();
                    BaseProtoPreventDuplicater.this.onResponseInner(callBacks, message, code, msg);
                }

                @Override
                public boolean needToken() {
                    if (callback != null) {
                        return callback.needToken();
                    }
                    return true;
                }

                @Override
                public long getCacheEffectiveTime() {
                    return 0L;
                }
            };
            if (sender != null) {
                sender.sendProtoRequest(roomId, proto, rpcMethod, theCallback, this.isWsRequest());
            } else {
                if (SystemUtils.isShowEnvSetting()) {
                    throw new RuntimeException("");
                }
                this.sendInner(roomId, proto, theCallback);
            }
        }
    }

    private IProtoCallback<RES> getMyProtoCallback(String roomId, REQ proto, long curTime, final IProtoCallback<RES> callback) {
        if (callback == null) {
            return null;
        }
        return new IProtoCallback<RES>((AndroidMessage)proto, curTime, roomId){
            final /* synthetic */ AndroidMessage val$proto;
            final /* synthetic */ long val$curTime;
            final /* synthetic */ String val$roomId;
            {
                this.val$proto = androidMessage;
                this.val$curTime = l;
                this.val$roomId = string;
            }

            @Override
            public boolean retryWhenTimeout(boolean canRetry) {
                return callback.retryWhenTimeout(canRetry);
            }

            @Override
            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                return callback.retryWhenError(canRetry, reason, code);
            }

            @Override
            @Deprecated
            @UiThread
            public void onResponse(@Nullable RES message) {
                callback.onResponse(message);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @UiThread
            public void onResponse(@NonNull RES message, long code, String msg) {
                if (ProtoManager.isSuccessCode(code)) {
                    BaseProtoPreventDuplicater baseProtoPreventDuplicater = BaseProtoPreventDuplicater.this;
                    synchronized (baseProtoPreventDuplicater) {
                        if (BaseProtoPreventDuplicater.this.lastResMessage == null || BaseProtoPreventDuplicater.this.lastResStartTime < BaseProtoPreventDuplicater.this.startTime) {
                            BaseProtoPreventDuplicater.this.lastResMessage = message;
                            BaseProtoPreventDuplicater.this.lastResRequest = this.val$proto;
                            BaseProtoPreventDuplicater.this.lastResStartTime = this.val$curTime;
                            BaseProtoPreventDuplicater.this.lastResCode = code;
                            BaseProtoPreventDuplicater.this.lastResMsgTip = msg;
                            BaseProtoPreventDuplicater.this.lastResRoomId = this.val$roomId;
                        }
                    }
                }
                BaseProtoPreventDuplicater.this.recycleResponse();
                callback.onResponse(message, code, msg);
            }

            @Override
            public boolean needToken() {
                if (callback != null) {
                    return callback.needToken();
                }
                return true;
            }

            @Override
            public long getCacheEffectiveTime() {
                return Long.MIN_VALUE;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStarted() {
        BaseProtoPreventDuplicater baseProtoPreventDuplicater = this;
        synchronized (baseProtoPreventDuplicater) {
            return this.callBacks.size() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onStart(REQ proto, IProtoCallback<RES> callback) {
        BaseProtoPreventDuplicater baseProtoPreventDuplicater = this;
        synchronized (baseProtoPreventDuplicater) {
            this.startTime = SystemClock.uptimeMillis();
            this.request = proto;
            this.callBacks.add(callback);
        }
        this.onStarted();
    }

    protected void onStarted() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onFinish() {
        BaseProtoPreventDuplicater baseProtoPreventDuplicater = this;
        synchronized (baseProtoPreventDuplicater) {
            this.request = null;
            this.startTime = 0L;
            this.roomId = null;
            this.callBacks.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onNetConnected() {
        BaseProtoPreventDuplicater baseProtoPreventDuplicater = this;
        synchronized (baseProtoPreventDuplicater) {
            this.startTime = 0L;
        }
        if (RuntimeContext.isInGray()) {
            MLog.info((Object)this.tag, (String)"onNetConnected!", (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onWsConnected() {
        BaseProtoPreventDuplicater baseProtoPreventDuplicater = this;
        synchronized (baseProtoPreventDuplicater) {
            this.startTime = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onLoginOut() {
        BaseProtoPreventDuplicater baseProtoPreventDuplicater = this;
        synchronized (baseProtoPreventDuplicater) {
            this.startTime = 0L;
            this.resetResponseData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onTrimMemory(long curTime) {
        BaseProtoPreventDuplicater baseProtoPreventDuplicater = this;
        synchronized (baseProtoPreventDuplicater) {
            this.startTime = 0L;
            if (this.lastResMessage != null && curTime - this.lastResStartTime > this.lastObtainCacheEffectiveTime) {
                this.resetResponseData();
            }
        }
    }

    private void resetResponseData() {
        this.lastResMessage = null;
        this.lastResCode = -1L;
        this.lastResMsgTip = "";
        this.lastResRequest = null;
        this.lastResStartTime = -1L;
        this.lastResRoomId = "";
    }

    void recycleResponse() {
        long lastObtainCacheEffectiveTime = this.lastObtainCacheEffectiveTime;
        if (lastObtainCacheEffectiveTime > 0L && this.lastResMessage != null) {
            if (this.recycleResponse != null) {
                YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.recycleResponse);
            }
            RES finalData = this.lastResMessage;
            this.recycleResponse = new Runnable((AndroidMessage)finalData){
                final /* synthetic */ AndroidMessage val$finalData;
                {
                    this.val$finalData = androidMessage;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    BaseProtoPreventDuplicater baseProtoPreventDuplicater = BaseProtoPreventDuplicater.this;
                    synchronized (baseProtoPreventDuplicater) {
                        if (this.val$finalData == BaseProtoPreventDuplicater.this.lastResMessage) {
                            BaseProtoPreventDuplicater.this.resetResponseData();
                        }
                    }
                    if (SystemUtils.isShowEnvSetting()) {
                        MLog.info((Object)BaseProtoPreventDuplicater.this.tag, (String)"recycleResponse!", (Object[])new Object[0]);
                    }
                    BaseProtoPreventDuplicater.this.recycleResponse = null;
                }
            };
            YYTaskExecutor.postToMainThread((Runnable)this.recycleResponse, (long)(lastObtainCacheEffectiveTime + 2000L));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addCallBack(IProtoCallback<RES> callback) {
        BaseProtoPreventDuplicater baseProtoPreventDuplicater = this;
        synchronized (baseProtoPreventDuplicater) {
            if (callback == null) {
                return;
            }
            this.callBacks.add(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<IProtoCallback<RES>> getCallBacks() {
        BaseProtoPreventDuplicater baseProtoPreventDuplicater = this;
        synchronized (baseProtoPreventDuplicater) {
            return new ArrayList<IProtoCallback<RES>>(this.callBacks);
        }
    }

    private boolean retryWhenTimeoutInner(boolean canRetry) {
        List<IProtoCallback<RES>> callBacks = this.getCallBacks();
        this.onFinish();
        if (callBacks != null && callBacks.size() > 0) {
            for (IProtoCallback<RES> item : callBacks) {
                if (item == null) continue;
                item.retryWhenTimeout(canRetry);
            }
        }
        return false;
    }

    private boolean retryWhenErrorInner(boolean canRetry, String reason, int code) {
        List<IProtoCallback<RES>> callBacks = this.getCallBacks();
        this.onFinish();
        if (callBacks != null && callBacks.size() > 0) {
            for (IProtoCallback<RES> item : callBacks) {
                if (item == null) continue;
                item.retryWhenError(canRetry, reason, code);
            }
        }
        return false;
    }

    private void onResponseInner(@Nullable RES message) {
        List<IProtoCallback<RES>> callBacks = this.getCallBacks();
        this.onFinish();
        if (callBacks != null && callBacks.size() > 0) {
            for (IProtoCallback<RES> item : callBacks) {
                if (item == null) continue;
                item.onResponse(message);
            }
        }
    }

    private void onResponseInner(List<IProtoCallback<RES>> callBacks, @NonNull RES message, long code, String msg) {
        if (callBacks != null && callBacks.size() > 0) {
            for (IProtoCallback<RES> item : callBacks) {
                if (item == null) continue;
                item.onResponse(message, code, msg);
            }
        }
    }

    protected abstract void sendInner(String var1, REQ var2, @Nullable IProtoCallback<RES> var3);

    protected abstract boolean isWsRequest();

    public static interface IProtoPreventDuplicaterCallback<REQ extends AndroidMessage<REQ, ?>> {
        public long getDefaultProtoCacheEffectiveTime(@Nullable IProtoCallback var1, IRequestCompare var2);

        public void onDuplicateRequest(boolean var1, IRequestCompare var2, int var3, int var4, int var5);

        public void maybeDuplicateRequest(BaseProtoPreventDuplicater var1, long var2, IRequestCompare var4, REQ var5, REQ var6);
    }

    public static interface IRequestCompare<REQ extends AndroidMessage<REQ, ?>> {
        public boolean equal(REQ var1, REQ var2);

        default public String serviceName() {
            return "";
        }

        default public String methodName() {
            return "";
        }
    }
}

