/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.proto;

import com.yy.base.logger.MLog;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.proto.OneNotifyFrequencyHandler;
import ikxd.cproxy.InnerV2;
import java.util.HashMap;
import java.util.Set;

public class NotifyFrequencyHandler {
    private static final String TAG = "NotifyFrequency_Handler";
    private HashMap<String, OneNotifyFrequencyHandler> mHandlerHashMap;
    private OneNotifyFrequencyHandler.INotifySender notifySender;
    private volatile boolean needHandleConfigUpdate = false;
    private volatile boolean needHandleLowMemery = false;

    public NotifyFrequencyHandler(OneNotifyFrequencyHandler.INotifySender notifySender) {
        this.notifySender = notifySender;
        if (notifySender == null) {
            throw new RuntimeException("notifySender can not be null!");
        }
        notifySender.setConfigUpdateCommand(new Runnable(){

            @Override
            public void run() {
                MLog.info((Object)NotifyFrequencyHandler.TAG, (String)"onConfigUpdate!", (Object[])new Object[0]);
                NotifyFrequencyHandler.this.needHandleConfigUpdate = true;
            }
        });
        notifySender.setLowMemeryCommand(new Runnable(){

            @Override
            public void run() {
                MLog.info((Object)NotifyFrequencyHandler.TAG, (String)"onLowMemery!", (Object[])new Object[0]);
                NotifyFrequencyHandler.this.needHandleConfigUpdate = true;
            }
        });
    }

    public void notify(InnerV2 innerV2, byte[] payload) {
        OneNotifyFrequencyHandler item;
        Set<String> keys;
        if (this.needHandleConfigUpdate) {
            if (this.mHandlerHashMap != null) {
                keys = this.mHandlerHashMap.keySet();
                for (String key : keys) {
                    item = this.mHandlerHashMap.get(key);
                    if (item == null) continue;
                    item.updateTime(this.notifySender.getFrequencyTime(item.getServiceName(), item.getUri()));
                }
            }
            this.needHandleConfigUpdate = false;
        }
        if (this.needHandleLowMemery && this.mHandlerHashMap != null && this.mHandlerHashMap.size() > 200) {
            keys = this.mHandlerHashMap.keySet();
            for (String key : keys) {
                item = this.mHandlerHashMap.get(key);
                if (item == null || item.hasNotifyNotHandler()) continue;
                this.mHandlerHashMap.remove(key);
            }
        }
        if (innerV2 == null || innerV2.header == null || StringUtils.isEmpty((String)innerV2.header.sname)) {
            MLog.error((Object)TAG, (String)"inner not invalid!", (Object[])new Object[0]);
            this.notifySender.notify(innerV2, payload);
            return;
        }
        boolean switchOnBySnameAndUri = this.notifySender.isFrequencyLimitSwitchOn(innerV2.header.sname, innerV2.uri);
        boolean switchOnBySname = false;
        if (!switchOnBySnameAndUri) {
            switchOnBySname = this.notifySender.isFrequencyLimitSwitchOn(innerV2.header.sname);
        }
        OneNotifyFrequencyHandler handler = null;
        if (this.mHandlerHashMap != null) {
            handler = switchOnBySnameAndUri ? this.mHandlerHashMap.get(innerV2.header.sname + "&&" + innerV2.uri) : this.mHandlerHashMap.get(innerV2.header.sname);
        }
        if (!switchOnBySnameAndUri && !switchOnBySname) {
            if (handler != null && handler.hasNotifyNotHandler()) {
                handler.handleNotify(innerV2, payload);
            } else {
                if (handler != null) {
                    this.mHandlerHashMap.remove(innerV2.header.sname);
                }
                this.notifySender.notify(innerV2, payload);
            }
            return;
        }
        if (this.mHandlerHashMap == null) {
            this.mHandlerHashMap = new HashMap();
        }
        if (handler == null) {
            if (switchOnBySnameAndUri) {
                handler = new OneNotifyFrequencyHandler(innerV2.header.sname, innerV2.uri, this.notifySender, this.notifySender.getFrequencyTime(innerV2.header.sname, innerV2.uri));
                this.mHandlerHashMap.put(innerV2.header.sname + "&&" + innerV2.uri, handler);
            } else {
                handler = new OneNotifyFrequencyHandler(innerV2.header.sname, -1, this.notifySender, this.notifySender.getFrequencyTime(innerV2.header.sname, -1));
                this.mHandlerHashMap.put(innerV2.header.sname, handler);
            }
        }
        handler.handleNotify(innerV2, payload);
    }
}

