/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.proto;

import android.text.TextUtils;
import com.squareup.wire.AndroidMessage;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.hiyo.proto.ProtoUtils;
import com.yy.hiyo.proto.callback.IProtoNotify;
import com.yy.hiyo.proto.notify.INotifyInterceptor;
import com.yy.hiyo.proto.notify.NotifyData;
import ikxd.cproxy.InnerV2;
import java.lang.ref.WeakReference;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class NotifyDispatch {
    private static final String TAG = "NotifyDispatch";
    private final ConcurrentHashMap<String, List<IProtoNotify>> mNotify = new ConcurrentHashMap();
    private final CopyOnWriteArrayList<WeakReference<INotifyInterceptor>> mInterceptors = new CopyOnWriteArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerNotify(IProtoNotify notify) {
        if (notify == null) {
            return;
        }
        ConcurrentHashMap<String, List<IProtoNotify>> concurrentHashMap = this.mNotify;
        synchronized (concurrentHashMap) {
            String name = notify.serviceName();
            if (SystemUtils.isShowEnvSetting() && TextUtils.isEmpty((CharSequence)name)) {
                throw new IllegalArgumentException("sname \u4e0d\u80fd\u4e3a\u7a7a " + notify);
            }
            List<IProtoNotify> watchers = this.mNotify.get(name);
            if (watchers == null) {
                watchers = new ArrayList<IProtoNotify>();
                this.mNotify.put(name, watchers);
            }
            if (watchers.contains(notify)) {
                return;
            }
            watchers.add(notify);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterNotify(IProtoNotify notify) {
        if (notify == null) {
            return;
        }
        ConcurrentHashMap<String, List<IProtoNotify>> concurrentHashMap = this.mNotify;
        synchronized (concurrentHashMap) {
            String name = notify.serviceName();
            List<IProtoNotify> watchers = this.mNotify.get(name);
            if (watchers == null || watchers.size() == 0) {
                return;
            }
            watchers.remove(notify);
        }
    }

    void addNotifyInterceptor(INotifyInterceptor interceptor) {
        if (interceptor == null) {
            return;
        }
        if (RuntimeContext.sIsDebuggable && interceptor.getClass().isAnonymousClass()) {
            throw new RuntimeException("notify \u62e6\u622a\u5668\u4e0d\u80fd\u662f\u533f\u540d\u7c7b");
        }
        WeakReference<INotifyInterceptor> weakReference = this.findInterceptor(interceptor);
        if (weakReference == null) {
            weakReference = new WeakReference<INotifyInterceptor>(interceptor);
            this.mInterceptors.add(weakReference);
        } else {
            MLog.error((Object)TAG, (String)"addNotifyInterceptor duplication", (Object[])new Object[0]);
        }
    }

    void removeNotifyInterceptor(INotifyInterceptor interceptor) {
        if (interceptor == null) {
            return;
        }
        WeakReference<INotifyInterceptor> weakReference = this.findInterceptor(interceptor);
        if (weakReference != null) {
            this.mInterceptors.remove(weakReference);
        }
    }

    private WeakReference<INotifyInterceptor> findInterceptor(INotifyInterceptor interceptor) {
        ArrayList<WeakReference<INotifyInterceptor>> empty = null;
        WeakReference<INotifyInterceptor> weakReference = null;
        for (WeakReference<INotifyInterceptor> weak : this.mInterceptors) {
            if (weak == null) continue;
            if (weak.get() == null) {
                if (empty == null) {
                    empty = new ArrayList<WeakReference<INotifyInterceptor>>();
                }
                empty.add(weak);
                continue;
            }
            if (interceptor != weak.get()) continue;
            weakReference = weak;
        }
        if (empty != null) {
            this.mInterceptors.removeAll(empty);
        }
        return weakReference;
    }

    public void notify(List<NotifyData> notifys) {
        if (notifys == null || notifys.size() <= 0) {
            return;
        }
        final ArrayList<NotifyDataEx> notices = new ArrayList<NotifyDataEx>(notifys.size());
        for (NotifyData data : notifys) {
            if (data == null) continue;
            notices.add(this.parseData(data));
        }
        if (notices.size() <= 0) {
            return;
        }
        Runnable command = new Runnable(){

            @Override
            public void run() {
                for (NotifyDataEx notice : notices) {
                    if (notice == null || notice.listeners == null || notice.listeners.size() <= 0) continue;
                    if (!MLog.isLogLevelAboveDebug() && SystemUtils.isShowEnvSetting()) {
                        MLog.debug((Object)NotifyDispatch.TAG, (String)"notifyList item (%s), bytes: %s", (Object[])new Object[]{ProtoUtils.innerString(notice.notifyOriginData.innerV2()), StringUtils.byteToStringUtf8((byte[])notice.notifyOriginData.payload())});
                    }
                    for (IProtoNotify listener : notice.listeners) {
                        if (listener == null || notice.msg == null) continue;
                        if (NotifyDispatch.this.checkIntercept(notice.notifyOriginData.innerV2(), notice.msg)) {
                            MLog.info((Object)NotifyDispatch.TAG, (String)"notify had been intercepted, %s", (Object[])new Object[]{ProtoUtils.innerString(notice.notifyOriginData.innerV2())});
                            continue;
                        }
                        listener.onNotify(notice.msg);
                    }
                }
            }
        };
        YYTaskExecutor.postToMainThread((Runnable)command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NotifyDataEx parseData(NotifyData data) {
        NotifyDataEx itemData = new NotifyDataEx();
        itemData.notifyOriginData = data;
        ArrayList<IProtoNotify> copys = null;
        ConcurrentHashMap<String, List<IProtoNotify>> concurrentHashMap = this.mNotify;
        synchronized (concurrentHashMap) {
            List<IProtoNotify> list = this.mNotify.get(data.innerV2().header.sname);
            if (FP.empty(list)) {
                return null;
            }
            copys = new ArrayList<IProtoNotify>(list.size());
            copys.addAll(list);
            itemData.listeners = copys;
        }
        Class lastType = null;
        for (IProtoNotify listener : copys) {
            if (listener == null) continue;
            if (itemData.msg == null) {
                itemData.msg = ProtoUtils.parsePbBytes(listener, IProtoNotify.class, data.payload());
            }
            if (SystemUtils.isShowEnvSetting()) {
                try {
                    ParameterizedType pt = (ParameterizedType)ProtoUtils.getInterfaceType(listener, IProtoNotify.class);
                    Class type = (Class)pt.getActualTypeArguments()[0];
                    if (lastType != null && lastType != type) {
                        throw new RuntimeException("");
                    }
                    lastType = type;
                }
                catch (Exception e) {
                    MLog.error((Object)TAG, (Throwable)e);
                }
            }
            if (itemData.msg != null) break;
            MLog.error((Object)TAG, (String)"parse notify proto failed inner: %s", (Object[])new Object[]{ProtoUtils.innerString(data.innerV2())});
        }
        return itemData;
    }

    void notify(InnerV2 inner, byte[] bytes) {
        if (bytes == null) {
            return;
        }
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"notify (%s), bytes: %s", (Object[])new Object[]{ProtoUtils.innerString(inner), StringUtils.byteToStringUtf8((byte[])bytes)});
        }
        if (inner != null && inner.header != null) {
            List<IProtoNotify> notifys = this.mNotify.get(inner.header.sname);
            if (notifys == null || notifys.size() == 0) {
                MLog.error((Object)TAG, (String)"notifyForeach \u6ca1\u76d1\u542c\u5e7f\u64ad %s", (Object[])new Object[]{ProtoUtils.innerString(inner)});
            } else {
                this.notifyForeach(notifys, inner, bytes);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyForeach(List<IProtoNotify> notifys, InnerV2 inner, byte[] bytes) {
        if (notifys == null || notifys.size() == 0) {
            return;
        }
        ArrayList<IProtoNotify> copys = new ArrayList<IProtoNotify>();
        ConcurrentHashMap<String, List<IProtoNotify>> concurrentHashMap = this.mNotify;
        synchronized (concurrentHashMap) {
            copys.addAll(notifys);
        }
        AndroidMessage msg = null;
        Class lastType = null;
        for (IProtoNotify notify : copys) {
            if (notify == null) continue;
            if (msg == null) {
                msg = ProtoUtils.parsePbBytes(notify, IProtoNotify.class, bytes);
            }
            if (SystemUtils.isShowEnvSetting()) {
                try {
                    ParameterizedType pt = (ParameterizedType)ProtoUtils.getInterfaceType(notify, IProtoNotify.class);
                    Class type = (Class)pt.getActualTypeArguments()[0];
                    if (lastType != null && lastType != type) {
                        throw new RuntimeException("");
                    }
                    lastType = type;
                }
                catch (Exception e) {
                    MLog.error((Object)TAG, (Throwable)e);
                }
            }
            if (msg != null) {
                if (this.checkIntercept(inner, msg)) {
                    MLog.info((Object)TAG, (String)"notify had been intercepted, %s", (Object[])new Object[]{ProtoUtils.innerString(inner)});
                    continue;
                }
                this.notify(msg, notify);
                continue;
            }
            MLog.error((Object)TAG, (String)"parse notify proto failed inner: %s", (Object[])new Object[]{ProtoUtils.innerString(inner)});
        }
    }

    private void notify(AndroidMessage msg, IProtoNotify notify) {
        if (RuntimeContext.sIsDebuggable) {
            this.notifyOnUi(notify, msg);
        } else {
            try {
                this.notifyOnUi(notify, msg);
            }
            catch (Exception e) {
                MLog.error((Object)TAG, (Throwable)e);
            }
        }
    }

    private boolean checkIntercept(InnerV2 inner, AndroidMessage notify) {
        ArrayList<INotifyInterceptor> interceptors = null;
        ArrayList<INotifyInterceptor> nonInterceptors = null;
        MLog.debug((Object)TAG, (String)"checkIntercept mInterceptors.size: %d", (Object[])new Object[]{this.mInterceptors.size()});
        for (WeakReference<INotifyInterceptor> weak : this.mInterceptors) {
            if (weak == null) continue;
            INotifyInterceptor interceptor = null;
            interceptor = (INotifyInterceptor)weak.get();
            if (interceptor == null) continue;
            INotifyInterceptor.Opt result = interceptor.onIntercept(inner.header, notify);
            if (result == INotifyInterceptor.Opt.INTERCEPT) {
                if (interceptors == null) {
                    interceptors = new ArrayList<INotifyInterceptor>();
                }
                interceptors.add(interceptor);
                continue;
            }
            if (result != INotifyInterceptor.Opt.NON_INTERCEPT) continue;
            if (nonInterceptors == null) {
                nonInterceptors = new ArrayList<INotifyInterceptor>();
            }
            nonInterceptors.add(interceptor);
        }
        if (FP.empty(interceptors) && FP.empty(nonInterceptors)) {
            return false;
        }
        if (!FP.empty(interceptors) && !FP.empty(nonInterceptors)) {
            StringBuilder log = new StringBuilder("\u4e0d\u540c\u7684\u62e6\u622a\u5668\u5904\u7406\u7ed3\u679c\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5!!! ");
            log.append("\u62e6\u622a\uff1a");
            for (INotifyInterceptor interceptor : interceptors) {
                log.append(interceptor.getClass().getName()).append(";");
            }
            log.append("\u4e0d\u62e6\u622a\uff1a");
            for (INotifyInterceptor interceptor : nonInterceptors) {
                log.append(interceptor.getClass().getName()).append(";");
            }
            MLog.error((Object)TAG, (String)log.toString(), (Object[])new Object[0]);
            return true;
        }
        return !FP.empty(interceptors);
    }

    private void notifyOnUi(final IProtoNotify notify, final AndroidMessage msg) {
        if (notify == null) {
            return;
        }
        if (YYTaskExecutor.isMainThread()) {
            notify.onNotify(msg);
        } else {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    notify.onNotify(msg);
                }
            });
        }
    }

    private static class NotifyDataEx {
        NotifyData notifyOriginData;
        AndroidMessage msg;
        List<IProtoNotify> listeners;

        private NotifyDataEx() {
        }
    }
}

