/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.proto.preventduplicater;

import android.os.SystemClock;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import com.squareup.wire.AndroidMessage;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.DefaultCacheEffectiveTimeUtil;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.hiyo.proto.preventduplicater.IProtoRequestRealSender;
import com.yy.hiyo.proto.rpc.RpcMethod;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseProtoPreventDuplicater<REQ extends AndroidMessage<REQ, ?>, RES extends AndroidMessage<RES, ?>> {
    protected String tag = "";
    private long startTime;
    private String roomId = "";
    protected REQ request;
    private final ArrayList<IProtoCallback<RES>> callBacks = new ArrayList(3);
    private long lastResStartTime;
    protected REQ lastResRequest;
    private RES lastResMessage;
    private long lastResCode;
    private String lastResMsgTip;
    private String lastResRoomId = "";
    private long lastObtainCacheEffectiveTime;
    private IProtoPreventDuplicaterCallback mCallback;
    private int preventNumInCacheTime = 0;
    private long lastCacheStartTime = 0L;

    public BaseProtoPreventDuplicater(IProtoPreventDuplicaterCallback callback) {
        this.mCallback = callback;
    }

    public synchronized void send(REQ proto, @Nullable IProtoCallback<RES> callback, IRequestCompare<REQ> compare) {
        this.send("", proto, callback, compare);
    }

    public synchronized void send(String roomId, REQ proto, @Nullable IProtoCallback<RES> callback, IRequestCompare<REQ> compare) {
        this.send(roomId, proto, null, callback, compare, null);
    }

    public synchronized void send(String roomId, REQ proto, RpcMethod<REQ, RES> rpcMethod, final @Nullable IProtoCallback<RES> callback, IRequestCompare<REQ> compare, IProtoRequestRealSender sender) {
        if (roomId == null) {
            roomId = "";
        }
        long cacheEffectiveTime = -1L;
        if (this.mCallback != null) {
            cacheEffectiveTime = this.mCallback.getDefaultProtoCacheEffectiveTime(callback, compare);
        } else {
            long l = cacheEffectiveTime = callback != null ? callback.getCacheEffectiveTime() : DefaultCacheEffectiveTimeUtil.getDefaultProtoCacheEffectiveTime();
        }
        if (cacheEffectiveTime <= 0L) {
            if (sender != null) {
                sender.sendProtoRequest(roomId, proto, rpcMethod, callback, this.isWsRequest());
            } else {
                this.sendInner(roomId, proto, this.getMyProtoCallback(roomId, proto, SystemClock.uptimeMillis(), callback));
            }
            return;
        }
        if (StringUtils.isEmpty((String)this.tag) && compare != null) {
            this.tag = "RequestPreventer_Proto_" + compare.serviceName() + "_" + compare.methodName();
        }
        ++DefaultCacheEffectiveTimeUtil.sProtoAllRequestNum;
        long curTime = -1L;
        this.lastObtainCacheEffectiveTime = cacheEffectiveTime;
        if (this.lastResMessage != null && StringUtils.equal((String)roomId, (String)this.lastResRoomId)) {
            curTime = SystemClock.uptimeMillis();
            if (curTime > 0L && curTime - this.lastResStartTime < cacheEffectiveTime) {
                if (compare != null && proto != null && this.lastResRequest != null && compare.equal(this.lastResRequest, proto)) {
                    if (this.preventNumInCacheTime == 0) {
                        this.lastCacheStartTime = curTime;
                    } else if (curTime - this.lastCacheStartTime > 60000L) {
                        this.lastCacheStartTime = curTime;
                        this.preventNumInCacheTime = 0;
                    }
                    ++this.preventNumInCacheTime;
                    MLog.info((Object)this.tag, (String)"hit cache:1, happen prevent duplicate num:%d, allRequestNum:%d!", (Object[])new Object[]{++DefaultCacheEffectiveTimeUtil.sProtoPreventNum, DefaultCacheEffectiveTimeUtil.sHttpAllRequestNum});
                    if (this.mCallback != null) {
                        this.mCallback.onDuplicateRequest(false, compare, DefaultCacheEffectiveTimeUtil.sProtoPreventNum, DefaultCacheEffectiveTimeUtil.sHttpAllRequestNum, this.preventNumInCacheTime);
                    }
                    RES fLastResMessage = this.lastResMessage;
                    long fLastResCode = this.lastResCode;
                    String fLastResMsgTip = this.lastResMsgTip;
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable((AndroidMessage)fLastResMessage, fLastResCode, fLastResMsgTip){
                        final /* synthetic */ AndroidMessage val$fLastResMessage;
                        final /* synthetic */ long val$fLastResCode;
                        final /* synthetic */ String val$fLastResMsgTip;
                        {
                            this.val$fLastResMessage = androidMessage;
                            this.val$fLastResCode = l;
                            this.val$fLastResMsgTip = string;
                        }

                        @Override
                        public void run() {
                            if (callback != null) {
                                callback.onResponse(this.val$fLastResMessage, this.val$fLastResCode, this.val$fLastResMsgTip);
                            }
                        }
                    });
                    return;
                }
                if (SystemUtils.isShowEnvSetting()) {
                    MLog.info((Object)this.tag, (String)"hit cache:0, by request params not equal!", (Object[])new Object[0]);
                }
            } else {
                this.preventNumInCacheTime = 0;
                if (this.mCallback != null) {
                    this.mCallback.maybeDuplicateRequest(this, this.lastResStartTime, compare, this.lastResRequest, proto);
                }
            }
        }
        if (this.isStarted()) {
            if (!StringUtils.equal((String)roomId, (String)this.roomId)) {
                if (curTime == -1L) {
                    curTime = SystemClock.uptimeMillis();
                }
                if (sender != null) {
                    sender.sendProtoRequest(roomId, proto, rpcMethod, this.getMyProtoCallback(roomId, proto, curTime, callback), this.isWsRequest());
                } else {
                    this.sendInner(roomId, proto, this.getMyProtoCallback(roomId, proto, curTime, callback));
                }
                if (RuntimeContext.isInGray()) {
                    MLog.info((Object)this.tag, (String)"hit cache:0, by roomid not equal:%s,%s,class:%s!", (Object[])new Object[]{roomId, this.roomId, proto.getClass()});
                }
                return;
            }
            if (curTime == -1L) {
                curTime = SystemClock.uptimeMillis();
            }
            if (curTime == 0L || curTime - this.startTime > cacheEffectiveTime) {
                this.preventNumInCacheTime = 0;
                if (sender != null) {
                    sender.sendProtoRequest(roomId, proto, rpcMethod, this.getMyProtoCallback(roomId, proto, curTime, callback), this.isWsRequest());
                } else {
                    this.sendInner(roomId, proto, this.getMyProtoCallback(roomId, proto, curTime, callback));
                }
                if (RuntimeContext.isInGray()) {
                    MLog.info((Object)this.tag, (String)"hit cache:0, has a request is sending, but time out!", (Object[])new Object[0]);
                }
            } else if (compare != null && proto != null && this.request != null && compare.equal(this.request, proto)) {
                if (this.preventNumInCacheTime == 0) {
                    this.lastCacheStartTime = curTime;
                } else if (curTime - this.lastCacheStartTime > 60000L) {
                    this.lastCacheStartTime = curTime;
                    this.preventNumInCacheTime = 0;
                }
                ++DefaultCacheEffectiveTimeUtil.sProtoPreventNum;
                ++this.preventNumInCacheTime;
                if (this.mCallback != null) {
                    this.mCallback.onDuplicateRequest(true, compare, DefaultCacheEffectiveTimeUtil.sProtoPreventNum, DefaultCacheEffectiveTimeUtil.sHttpAllRequestNum, this.preventNumInCacheTime);
                }
                MLog.info((Object)this.tag, (String)"hit cache:1, has a request is sending, happen prevent duplicate num:%d, allRequestNum:%d!", (Object[])new Object[]{DefaultCacheEffectiveTimeUtil.sProtoPreventNum, DefaultCacheEffectiveTimeUtil.sHttpAllRequestNum});
                this.addCallBack(callback);
            } else {
                if (RuntimeContext.isInGray()) {
                    MLog.info((Object)this.tag, (String)"hit cache:0, has a request is sending, but params not equal!", (Object[])new Object[0]);
                }
                if (sender != null) {
                    sender.sendProtoRequest(roomId, proto, rpcMethod, this.getMyProtoCallback(roomId, proto, curTime, callback), this.isWsRequest());
                } else {
                    this.sendInner(roomId, proto, this.getMyProtoCallback(roomId, proto, curTime, callback));
                }
            }
            return;
        }
        this.roomId = roomId;
        this.onStart(proto, callback);
        IProtoCallback theCallback = new IProtoCallback<RES>(){

            @Override
            public boolean retryWhenTimeout(boolean canRetry) {
                return BaseProtoPreventDuplicater.this.retryWhenTimeoutInner(canRetry);
            }

            @Override
            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                return BaseProtoPreventDuplicater.this.retryWhenErrorInner(canRetry, reason, code);
            }

            @Override
            @Deprecated
            @UiThread
            public void onResponse(@Nullable RES message) {
                BaseProtoPreventDuplicater.this.onResponseInner(message);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @UiThread
            public void onResponse(@NonNull RES message, long code, String msg) {
                BaseProtoPreventDuplicater baseProtoPreventDuplicater = BaseProtoPreventDuplicater.this;
                synchronized (baseProtoPreventDuplicater) {
                    if (ProtoManager.isSuccessCode(code) && (BaseProtoPreventDuplicater.this.lastResMessage == null || BaseProtoPreventDuplicater.this.lastResStartTime < BaseProtoPreventDuplicater.this.startTime)) {
                        BaseProtoPreventDuplicater.this.lastResMessage = message;
                        BaseProtoPreventDuplicater.this.lastResRequest = BaseProtoPreventDuplicater.this.request;
                        BaseProtoPreventDuplicater.this.lastResStartTime = BaseProtoPreventDuplicater.this.startTime;
                        BaseProtoPreventDuplicater.this.lastResCode = code;
                        BaseProtoPreventDuplicater.this.lastResMsgTip = msg;
                        BaseProtoPreventDuplicater.this.lastResRoomId = BaseProtoPreventDuplicater.this.roomId;
                    }
                }
                BaseProtoPreventDuplicater.this.onResponseInner(message, code, msg);
            }

            @Override
            public boolean needToken() {
                if (callback != null) {
                    return callback.needToken();
                }
                return true;
            }

            @Override
            public long getCacheEffectiveTime() {
                return 0L;
            }
        };
        if (sender != null) {
            sender.sendProtoRequest(roomId, proto, rpcMethod, theCallback, this.isWsRequest());
        } else {
            this.sendInner(roomId, proto, theCallback);
        }
    }

    private IProtoCallback<RES> getMyProtoCallback(String roomId, REQ proto, long curTime, final IProtoCallback<RES> callback) {
        if (callback == null) {
            return null;
        }
        return new IProtoCallback<RES>((AndroidMessage)proto, curTime, roomId){
            final /* synthetic */ AndroidMessage val$proto;
            final /* synthetic */ long val$curTime;
            final /* synthetic */ String val$roomId;
            {
                this.val$proto = androidMessage;
                this.val$curTime = l;
                this.val$roomId = string;
            }

            @Override
            public boolean retryWhenTimeout(boolean canRetry) {
                return callback.retryWhenTimeout(canRetry);
            }

            @Override
            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                return callback.retryWhenError(canRetry, reason, code);
            }

            @Override
            @Deprecated
            @UiThread
            public void onResponse(@Nullable RES message) {
                callback.onResponse(message);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @UiThread
            public void onResponse(@NonNull RES message, long code, String msg) {
                if (ProtoManager.isSuccessCode(code)) {
                    BaseProtoPreventDuplicater baseProtoPreventDuplicater = BaseProtoPreventDuplicater.this;
                    synchronized (baseProtoPreventDuplicater) {
                        if (BaseProtoPreventDuplicater.this.lastResMessage == null || BaseProtoPreventDuplicater.this.lastResStartTime < BaseProtoPreventDuplicater.this.startTime) {
                            BaseProtoPreventDuplicater.this.lastResMessage = message;
                            BaseProtoPreventDuplicater.this.lastResRequest = this.val$proto;
                            BaseProtoPreventDuplicater.this.lastResStartTime = this.val$curTime;
                            BaseProtoPreventDuplicater.this.lastResCode = code;
                            BaseProtoPreventDuplicater.this.lastResMsgTip = msg;
                            BaseProtoPreventDuplicater.this.lastResRoomId = this.val$roomId;
                        }
                    }
                }
                callback.onResponse(message, code, msg);
            }

            @Override
            public boolean needToken() {
                if (callback != null) {
                    return callback.needToken();
                }
                return true;
            }

            @Override
            public long getCacheEffectiveTime() {
                return Long.MIN_VALUE;
            }
        };
    }

    public synchronized boolean isStarted() {
        return this.callBacks.size() > 0;
    }

    protected synchronized void onStart(REQ proto, IProtoCallback<RES> callback) {
        this.startTime = SystemClock.uptimeMillis();
        this.request = proto;
        this.callBacks.add(callback);
        this.onStarted();
    }

    protected synchronized void onStarted() {
    }

    protected synchronized void onFinish() {
        this.request = null;
        this.startTime = 0L;
        this.roomId = null;
        this.callBacks.clear();
    }

    protected synchronized void onNetConnected() {
        this.startTime = 0L;
        if (RuntimeContext.isInGray()) {
            MLog.info((Object)this.tag, (String)"onNetConnected!", (Object[])new Object[0]);
        }
    }

    protected synchronized void onWsConnected() {
        this.startTime = 0L;
    }

    protected synchronized void onLoginOut() {
        this.startTime = 0L;
        this.lastResMessage = null;
        this.lastResCode = -1L;
        this.lastResMsgTip = "";
        this.lastResRequest = null;
        this.lastResStartTime = -1L;
        this.lastResRoomId = "";
    }

    protected synchronized void onTrimMemory(long curTime) {
        this.startTime = 0L;
        if (this.lastResMessage != null && curTime - this.lastResStartTime > this.lastObtainCacheEffectiveTime) {
            this.lastResMessage = null;
            this.lastResCode = -1L;
            this.lastResMsgTip = "";
            this.lastResRequest = null;
            this.lastResStartTime = -1L;
            this.lastResRoomId = "";
        }
    }

    protected synchronized void addCallBack(IProtoCallback<RES> callback) {
        if (callback == null) {
            return;
        }
        this.callBacks.add(callback);
    }

    protected synchronized List<IProtoCallback<RES>> getCallBacks() {
        return new ArrayList<IProtoCallback<RES>>(this.callBacks);
    }

    private boolean retryWhenTimeoutInner(boolean canRetry) {
        List<IProtoCallback<RES>> callBacks = this.getCallBacks();
        this.onFinish();
        if (callBacks != null && callBacks.size() > 0) {
            for (IProtoCallback<RES> item : callBacks) {
                if (item == null) continue;
                item.retryWhenTimeout(canRetry);
            }
        }
        return false;
    }

    private boolean retryWhenErrorInner(boolean canRetry, String reason, int code) {
        List<IProtoCallback<RES>> callBacks = this.getCallBacks();
        this.onFinish();
        if (callBacks != null && callBacks.size() > 0) {
            for (IProtoCallback<RES> item : callBacks) {
                if (item == null) continue;
                item.retryWhenError(canRetry, reason, code);
            }
        }
        return false;
    }

    private void onResponseInner(@Nullable RES message) {
        List<IProtoCallback<RES>> callBacks = this.getCallBacks();
        this.onFinish();
        if (callBacks != null && callBacks.size() > 0) {
            for (IProtoCallback<RES> item : callBacks) {
                if (item == null) continue;
                item.onResponse(message);
            }
        }
    }

    private void onResponseInner(@NonNull RES message, long code, String msg) {
        List<IProtoCallback<RES>> callBacks = this.getCallBacks();
        this.onFinish();
        if (callBacks != null && callBacks.size() > 0) {
            for (IProtoCallback<RES> item : callBacks) {
                if (item == null) continue;
                item.onResponse(message, code, msg);
            }
        }
    }

    protected abstract void sendInner(String var1, REQ var2, @Nullable IProtoCallback<RES> var3);

    protected abstract boolean isWsRequest();

    public static interface IProtoPreventDuplicaterCallback<REQ extends AndroidMessage<REQ, ?>> {
        public long getDefaultProtoCacheEffectiveTime(@Nullable IProtoCallback var1, IRequestCompare var2);

        public void onDuplicateRequest(boolean var1, IRequestCompare var2, int var3, int var4, int var5);

        public void maybeDuplicateRequest(BaseProtoPreventDuplicater var1, long var2, IRequestCompare var4, REQ var5, REQ var6);
    }

    public static interface IRequestCompare<REQ extends AndroidMessage<REQ, ?>> {
        public boolean equal(REQ var1, REQ var2);

        default public String serviceName() {
            return "";
        }

        default public String methodName() {
            return "";
        }
    }
}

