/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.proto;

import android.os.SystemClock;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.squareup.wire.AndroidMessage;
import com.squareup.wire.Message;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.okhttp.websocket.WsClient;
import com.yy.base.okhttp.websocket.ws.RpcStat;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.proto.AbsProtoDispatch;
import com.yy.hiyo.proto.IDispatchCallback;
import com.yy.hiyo.proto.IProtoInnerCallback;
import com.yy.hiyo.proto.ProtoMonitor;
import com.yy.hiyo.proto.ProtoUtils;
import com.yy.hiyo.proto.RouteTransmission;
import com.yy.hiyo.proto.WsRequest;
import common.Header;
import ikxd.cproxy.InnerV2;
import java.util.Hashtable;
import java.util.Map;

public class ProtoDispatch
extends AbsProtoDispatch {
    private static final String TAG = "ProtoDispatch";
    private final Map<Long, WsRequest> mRequestMap = new Hashtable<Long, WsRequest>();
    private static boolean sHasStatHeart = false;

    protected ProtoDispatch(IDispatchCallback callback) {
        super(callback);
    }

    <T extends AndroidMessage<T, ?>> void send(final String wsUrl, final T proto, final IProtoInnerCallback<T> callback) {
        if (TextUtils.isEmpty((CharSequence)wsUrl) || proto == null) {
            return;
        }
        if (YYTaskExecutor.isMainThread()) {
            this.mDispatchCallback.execute(new Runnable(){

                @Override
                public void run() {
                    ProtoDispatch.this.sendAsync(wsUrl, proto, callback);
                }
            }, 0L);
        } else {
            this.sendAsync(wsUrl, proto, callback);
        }
    }

    @Override
    public int getCurTaskSize() {
        return this.mRequestMap.size();
    }

    @Override
    protected boolean onResend(WsClient wsClient, WsRequest request) {
        InnerV2 innerV2;
        if (request == null || (innerV2 = request.inner) == null) {
            MLog.error((Object)TAG, (String)"onResend error, request == null: %b", (Object[])new Object[]{request == null});
            return false;
        }
        Message.Builder builder = request.proto.newBuilder();
        long newSeqId = ProtoUtils.uniqueSeq();
        Header newHeader = innerV2.header.newBuilder().seqid(newSeqId).build();
        boolean success = this.setHeaderReflect(builder, newHeader);
        if (success) {
            long oldSeqId = request.seqId;
            request.seqId = newSeqId;
            request.proto = (AndroidMessage)builder.build();
            request.setData(request.proto.encode());
            request.inner = ProtoUtils.parseInner(request.getData());
            this.removeAndUpdate(oldSeqId, request);
        }
        return wsClient.send(request.getData());
    }

    private <T extends AndroidMessage<T, ?>> void sendAsync(String wsUrl, T proto, IProtoInnerCallback<T> callback) {
        WsClient wsClient = this.mDispatchCallback.getWsClient(wsUrl);
        if (wsClient == null) {
            return;
        }
        byte[] bs = proto.encode();
        InnerV2 inner = ProtoUtils.parseInner(bs);
        if (RuntimeContext.sIsDebuggable && !MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"proto sendAsync inner: %s", (Object[])new Object[]{ProtoUtils.innerString(inner)});
        }
        if (inner == null || inner.header == null) {
            return;
        }
        Header header = inner.header;
        long seqId = header.seqid;
        ProtoMonitor.monitorRequest(seqId, bs.length, wsUrl, header.sname, header.method, inner.uri, wsClient.queueSize(), proto);
        WsRequest request = WsRequest.obtain();
        request.wsUrl = wsUrl;
        request.seqId = seqId;
        request.callback = callback;
        request.setData(bs);
        request.proto = proto;
        request.time = System.currentTimeMillis();
        request.inner = inner;
        this.addRequest(seqId, request);
        boolean resendSuccess = wsClient.send(bs);
        if (resendSuccess && request.firstSendTime <= 0L) {
            request.firstSendTime = request.time;
        }
    }

    @Override
    void onResponse(String wsUrl, @NonNull byte[] resData, @NonNull InnerV2 inner, int originSize, long networkRt) {
        InnerV2 reqInner;
        if (RuntimeContext.sIsDebuggable && !MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"proto onResponse inner: %s", (Object[])new Object[]{ProtoUtils.innerString(inner)});
        }
        long receiveTime = -1L;
        if (RuntimeContext.sIsDebuggable) {
            receiveTime = SystemClock.uptimeMillis();
        }
        long fReceiveTime = receiveTime;
        Header header = inner.header;
        if (header == null) {
            return;
        }
        super.onResponse(wsUrl, resData, inner, originSize, networkRt);
        long seqId = header.seqid;
        WsRequest request = this.removeRequest(this.mRequestMap, seqId, " response");
        if (request != null && (reqInner = request.inner) != null && reqInner.header != null && header.sname.equals(reqInner.header.sname) && reqInner.uri + 1 == inner.uri) {
            long useTime = System.currentTimeMillis() - request.time;
            RouteTransmission.setCproxyRoutingKey(header.sname, header.routing_key);
            if (request.callback != null) {
                Object response = ProtoUtils.parseBytes(request.proto.adapter(), resData);
                ProtoMonitor.monitorResponseTimeGap(fReceiveTime, inner);
                this.onResponseCallback((AndroidMessage)response, request, inner, useTime, originSize);
            } else {
                request.recycle();
            }
        } else {
            if (request != null) {
                request.recycle();
            }
            this.onNotify(wsUrl, inner, resData);
        }
    }

    @Override
    @NonNull
    protected Map<Long, WsRequest> getRequestMap() {
        return this.mRequestMap;
    }

    private void onResponseCallback(AndroidMessage response, WsRequest request, InnerV2 inner, long useTime, int receiveSize) {
        Header header;
        IProtoInnerCallback callback = request.callback;
        if (response == null) {
            YYTaskExecutor.postToMainThread(() -> {
                if (callback != null) {
                    String sName = "";
                    int uri = 0;
                    InnerV2 reqInner = request.inner;
                    if (reqInner != null && reqInner.header != null) {
                        sName = reqInner.header.sname;
                        uri = reqInner.uri;
                    }
                    this.onRetryWhenError(callback, sName, uri, request.seqId, false, "parse byte failed", -1, useTime, request.retryCount, reqInner.header.method);
                }
                request.recycle();
            });
            return;
        }
        if (inner != null && (header = inner.header) != null) {
            ProtoMonitor.monitorResponse(header.sname, inner.uri, header.seqid, inner.payload.size());
            MLog.info((Object)TAG, (String)"onResponse sName:%s, method:%s", (Object[])new Object[]{header.sname != null ? header.sname : "", header.method != null ? header.method : ""});
            if (StringUtils.equal((String)header.sname, (String)"ikxd_online_d")) {
                if (!sHasStatHeart) {
                    RpcStat.statRpcSuccess((String)header.sname, (String)(header.method + request.inner.uri), (long)useTime, (int)request.length, (int)receiveSize, (int)request.retryCount);
                    sHasStatHeart = true;
                }
            } else {
                RpcStat.statRpcSuccess((String)header.sname, (String)(header.method + request.inner.uri), (long)useTime, (int)request.length, (int)receiveSize, (int)request.retryCount);
            }
        }
        YYTaskExecutor.postToMainThread(() -> {
            long startTime;
            block4: {
                startTime = -1L;
                if (RuntimeContext.sIsDebuggable) {
                    startTime = SystemClock.uptimeMillis();
                }
                try {
                    if (callback != null) {
                        callback.onResponse(response);
                    }
                }
                catch (Exception e) {
                    MLog.error((Object)TAG, (Throwable)e);
                    if (!RuntimeContext.sIsDebuggable) break block4;
                    throw e;
                }
            }
            ProtoMonitor.monitorResponseExecuteTime(startTime, inner);
            request.recycle();
        });
    }

    private void onNotify(String wsUrl, InnerV2 inner, byte[] bytes) {
        Header header = inner.header;
        ProtoMonitor.monitorNotify(wsUrl, bytes, header);
        this.mDispatchCallback.notify(inner, bytes);
    }

    private void removeAndUpdate(long oldSeqId, WsRequest request) {
        this.mRequestMap.remove(oldSeqId);
        this.mRequestMap.put(request.seqId, request);
    }

    private void addRequest(long requestId, WsRequest request) {
        if (RuntimeContext.sIsDebuggable) {
            request.statKey = request.statKey + " add";
        }
        this.mRequestMap.put(requestId, request);
    }
}

