/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.proto;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.grace.Response;
import com.yy.hiyo.proto.IBanedHandler;
import com.yy.hiyo.proto.IProtoInnerCallback;
import com.yy.hiyo.proto.IResponseInterceptor;
import com.yy.hiyo.proto.ProtoManager;
import java.util.Arrays;
import java.util.List;
import net.ihago.inform.srv.mgr.GetBanInfoReq;
import net.ihago.inform.srv.mgr.GetBanInfoRes;

public final class GlobalBanInterface
implements IResponseInterceptor,
INotify {
    private static final String TAG = "GlobalBanInterface";
    private static boolean mHasBanToken;
    private static boolean mHasBanAction;
    private static boolean mHasShownBanInfoAfterLaunchApp;
    @Nullable
    private static IBanedHandler mIBanedHandler;
    public static final GlobalBanInterface INSTANCE;
    public static final List<String> gTipsInterfacesType0;
    public static final List<String> gTipsInterfacesType1;
    private static final String KEY_TITLE = "key_ban_title";
    private static final String KEY_CONTENT = "key_ban_content";
    private static final String KEY_REASON = "key_ban_reason";
    private static final String KEY_REMAIN_SECONDS = "key_ban_rms";
    private static final String KEY_DAY = "key_ban_day";
    private static final String KEY_BANED = "key_ban_banded";

    public final void setMIBanedHandler(IBanedHandler var1) {
        mIBanedHandler = var1;
    }

    private void checkShowBanInfo() {
        if (mIBanedHandler != null && mIBanedHandler.getLoginUid() > 0L && RuntimeContext.sIsAppStartFinishAfterOneSecond) {
            this.fetchBanInfo();
        }
    }

    public boolean interceptHttpResponse(Response response, Object req) {
        if (response == null) {
            return false;
        }
        String header1 = response.raw().header("x-common-errcode");
        int code = StringUtils.safeParseInt((String)header1);
        return this.handleCode(response, code, req);
    }

    @Override
    public void interceptWsOnResponse(Object response, long errcode, Object req) {
        this.handleCode(response, (int)errcode, req);
    }

    public boolean isBandAction() {
        return mHasBanAction;
    }

    private boolean handleCode(Object response, int code, Object req) {
        if (code == 9401) {
            String s = "\u88ab\u7981Token\u5931\u6548\uff1a" + req.getClass().getSimpleName();
            MLog.info((Object)TAG, (String)s, (Object[])new Object[0]);
            this.handleTokenInvalid();
            if (SystemUtils.isShowEnvSetting()) {
                ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)s, (int)0);
            }
            return true;
        }
        if (code == 9403) {
            String mather;
            int type;
            if (req instanceof String) {
                type = 1;
                mather = (String)req;
            } else {
                type = 0;
                mather = req.getClass().getSimpleName();
            }
            String s = "\u88ab\u7981\u884c\u4e3a\uff1a" + mather;
            MLog.info((Object)TAG, (String)s, (Object[])new Object[0]);
            this.handleBanAction(type, mather);
            if (SystemUtils.isShowEnvSetting()) {
                ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)s, (int)0);
            }
            return true;
        }
        return false;
    }

    private void handleBanAction(int type, String req) {
        IBanedHandler var10000 = mIBanedHandler;
        if (var10000 != null) {
            if (var10000.getLoginUid() >= 0L) {
                mHasBanAction = true;
            }
            var10000.handleBanAction();
        }
        if (mIBanedHandler == null || mIBanedHandler.getLoginUid() <= 0L) {
            return;
        }
        if (!mHasShownBanInfoAfterLaunchApp) {
            mHasShownBanInfoAfterLaunchApp = true;
            this.notifyBanDialog();
            return;
        }
        if (type == 0 && gTipsInterfacesType0.contains(req)) {
            this.notifyBanDialog();
        } else if (type == 1 && this.gTipsInterfacesType1Match(req)) {
            this.notifyBanDialog();
        }
    }

    private boolean gTipsInterfacesType1Match(String input) {
        for (String item : gTipsInterfacesType1) {
            if (!input.contains(item)) continue;
            return true;
        }
        return false;
    }

    private void handleTokenInvalid() {
        if (!mHasBanToken && mIBanedHandler != null) {
            mHasBanToken = true;
            IBanedHandler var10000 = mIBanedHandler;
            if (var10000 != null) {
                var10000.handleTokenInvalid();
            }
        }
    }

    private GlobalBanInterface() {
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_LOGIN_ACCOUNT_CHANGED, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_STARTUP_FINISHED_AFTER_1_SECONDS, (INotify)this);
    }

    public void notify(Notification notification) {
        if (notification.id == NotificationDef.N_LOGIN_ACCOUNT_CHANGED) {
            if (mIBanedHandler != null) {
                if (mIBanedHandler.getLoginUid() <= 0L) {
                    mHasBanToken = false;
                    mHasBanAction = false;
                } else {
                    this.checkShowBanInfo();
                }
            }
        } else if (notification.id == NotificationDef.N_STARTUP_FINISHED_AFTER_1_SECONDS) {
            this.checkShowBanInfo();
        }
    }

    private void fetchBanInfo() {
        this.realRequest();
    }

    private void realRequest() {
        GetBanInfoReq req = new GetBanInfoReq.Builder().uid(mIBanedHandler.getLoginUid()).build();
        ProtoManager.getInstance().sendHttp(req, new IProtoInnerCallback<GetBanInfoRes>(){

            @Override
            public boolean retryWhenTimeout(boolean canRetry) {
                MLog.error((Object)GlobalBanInterface.TAG, (String)"retryWhenTimeout canRetry:%s", (Object[])new Object[]{canRetry});
                return false;
            }

            @Override
            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                MLog.error((Object)GlobalBanInterface.TAG, (String)"retryWhenError can:%s, rea:%s, code:%s", (Object[])new Object[]{canRetry, reason, code});
                return false;
            }

            @Override
            public void onResponse(@NonNull GetBanInfoRes message, long code, String msgTip) {
                super.onResponse(message, code, msgTip);
                if (ProtoManager.isSuccessCode(code) && message.uid_ban_info != null && !message.uid_ban_info.__isDefaultInstance()) {
                    if (message.uid_ban_info.banned.booleanValue()) {
                        String bannedTittle = message.uid_ban_info.msg;
                        String bannedContent = message.uid_ban_info.reason_msg;
                        String bannedReason = message.uid_ban_info.against_desc;
                        long day = message.uid_ban_info.days.intValue();
                        long remainSecond = message.uid_ban_info.remain_second;
                        mHasBanAction = true;
                        MLog.info((Object)GlobalBanInterface.TAG, (String)"banded bannedTittle:%s, bannedContent:%s, bannedReason:%s, day:%s, rm:%s", (Object[])new Object[]{bannedTittle, bannedContent, bannedReason, day, remainSecond});
                        GlobalBanInterface.this.updateBanInfo(bannedTittle, bannedContent, bannedReason, day, remainSecond, true);
                        GlobalBanInterface.this.showDialog(bannedTittle, bannedContent, bannedReason, day, remainSecond);
                    } else {
                        MLog.info((Object)GlobalBanInterface.TAG, (String)"not ban", (Object[])new Object[0]);
                        mHasBanAction = false;
                        GlobalBanInterface.this.updateBanInfo("", "", "", 0L, 0L, false);
                    }
                }
            }
        });
    }

    private void showDialog(String bannedTittle, String bannedContent, String bannedReason, long day, long remainSecond) {
        NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationDef.N_BAN_ACTION, (Object)new BanInfo(bannedTittle, bannedContent, bannedReason, day, remainSecond, true)));
    }

    public void notifyBanDialog() {
        this.checkShowBanInfo();
    }

    public void updateBanInfo(String bannedTittle, String bannedContent, String bannedReason, long day, long remainSecond, boolean band) {
        if (mIBanedHandler == null) {
            return;
        }
        mIBanedHandler.getSp().edit().putString(KEY_TITLE, bannedTittle).putString(KEY_CONTENT, bannedContent).putString(KEY_REASON, bannedReason).putLong(KEY_DAY, day).putLong(KEY_REMAIN_SECONDS, remainSecond).putInt(KEY_BANED, band ? 1 : 0).apply();
    }

    static {
        mHasShownBanInfoAfterLaunchApp = false;
        gTipsInterfacesType0 = Arrays.asList("SitdownReq", "SendMsgReq", "AcceptSitdownReq", "PostReq", "LikeReq", "UploadTokenReq", "AcceptJoinMicReq", "AddJoinMicQueueReq", "");
        gTipsInterfacesType1 = Arrays.asList("/uinfo/update_uinfo");
        INSTANCE = new GlobalBanInterface();
    }

    public static final class BanInfo {
        public final String bannedTittle;
        public final String bannedContent;
        public final String bannedReason;
        public final long day;
        public final long remainSecond;
        public final boolean ban;

        public BanInfo(String bannedTittle, String bannedContent, String bannedReason, long day, long remainSecond, boolean ban) {
            this.bannedTittle = bannedTittle;
            this.bannedContent = bannedContent;
            this.bannedReason = bannedReason;
            this.day = day;
            this.remainSecond = remainSecond;
            this.ban = ban;
        }
    }
}

