/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.pickme.ui;

import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import androidx.annotation.NonNull;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.logger.MLog;
import com.yy.base.utils.ResolutionUtils;
import com.yy.hiyo.channel.plugins.pickme.R;
import com.yy.hiyo.channel.plugins.pickme.bean.MatchSuccessInfo;
import com.yy.hiyo.channel.plugins.pickme.common.MatchEffectLevel;
import com.yy.hiyo.channel.plugins.pickme.ui.MatchEffectViewManager;
import com.yy.hiyo.channel.plugins.pickme.ui.base.IPlayAnimManager;
import com.yy.hiyo.channel.plugins.pickme.ui.callback.IPlayMatchEffectEnd;
import com.yy.hiyo.channel.plugins.pickme.ui.view.PickMeMatchSVGAView;
import com.yy.hiyo.channel.plugins.pickme.ui.view.PickMeTipView;

public class PlayAnimManager
implements IPlayAnimManager {
    private static final String TAG = "FTPickMe#PlayAnimManager";
    private RelativeLayout mViewContainer;
    private MatchEffectViewManager mMatchEffectViewManager;
    private IPlayMatchEffectEnd playMatchEffectEnd = success -> this.playMatchEffect();

    public PlayAnimManager(@NonNull RelativeLayout viewContainer) {
        this.mViewContainer = viewContainer;
    }

    @Override
    public void showStartIntroduceAnim() {
        if (!this.checkVaild()) {
            return;
        }
        PickMeTipView tipView = this.getPickMeTipsView();
        tipView.updateView(4);
    }

    @Override
    public void showStartChooseAnim() {
        if (!this.checkVaild()) {
            return;
        }
        PickMeTipView tipView = this.getPickMeTipsView();
        tipView.updateView(1);
    }

    @Override
    public void showPublishAnim() {
        if (!this.checkVaild()) {
            return;
        }
        PickMeTipView tipView = this.getPickMeTipsView();
        tipView.updateView(2);
    }

    @Override
    public void onPause() {
        FeatureLog.d((String)TAG, (String)"onPause", (Object[])new Object[0]);
        if (this.mMatchEffectViewManager != null) {
            this.mMatchEffectViewManager.clearMatchUserInfoEffect();
            this.mMatchEffectViewManager = null;
        }
        if (this.mViewContainer != null) {
            PickMeMatchSVGAView pickMeMatchSVGAView;
            PickMeTipView tipView = (PickMeTipView)this.mViewContainer.findViewById(R.id.pick_me_match_tip);
            if (tipView != null) {
                this.mViewContainer.removeView((View)tipView);
            }
            if ((pickMeMatchSVGAView = (PickMeMatchSVGAView)this.mViewContainer.findViewById(R.id.pick_me_match_success_effect)) != null) {
                this.mViewContainer.removeView((View)pickMeMatchSVGAView);
            }
        }
    }

    @Override
    public void showMatchAnim(MatchSuccessInfo matchSuccessInfo) {
        if (!this.checkVaild()) {
            return;
        }
        if (matchSuccessInfo == null) {
            if (FeatureLog.isLogLevelBlowInfo()) {
                FeatureLog.i((String)TAG, (String)"showMatchAnim but matchSuccessInfo is null!!!", (Object[])new Object[0]);
            }
            return;
        }
        if (this.mMatchEffectViewManager == null) {
            this.mMatchEffectViewManager = new MatchEffectViewManager();
        }
        this.mMatchEffectViewManager.addMatchSuccess(matchSuccessInfo, matchUserInfo -> {
            if (FeatureLog.isLogLevelBlowInfo()) {
                FeatureLog.i((String)TAG, (String)"addMatchSuccess matchUserInfo: %s", (Object[])new Object[]{matchUserInfo});
            }
            if (this.mViewContainer.findViewById(R.id.pick_me_match_success_effect) == null) {
                MatchEffectLevel level = matchSuccessInfo.getMatchEffectLevel();
                PickMeMatchSVGAView mSvgaImageView = this.createPickMeMatchEffectView(level);
                this.mViewContainer.addView((View)mSvgaImageView);
                this.playMatchEffect();
            }
        });
    }

    private void playMatchEffect() {
        if (this.mMatchEffectViewManager == null) {
            if (FeatureLog.isLogLevelBlowInfo()) {
                FeatureLog.i((String)TAG, (String)"playMatchEffect mMatchEffectViewManager is null", (Object[])new Object[0]);
            }
            return;
        }
        MatchSuccessInfo matchUserInfo = this.mMatchEffectViewManager.consumeMatchUserInfo();
        PickMeMatchSVGAView mSvgaImageView = (PickMeMatchSVGAView)this.mViewContainer.findViewById(R.id.pick_me_match_success_effect);
        if (matchUserInfo == null) {
            if (mSvgaImageView != null) {
                try {
                    this.mViewContainer.removeView((View)mSvgaImageView);
                }
                catch (Exception e) {
                    MLog.error((Object)TAG, (String)("mViewContainer removeView error, " + e.getMessage()), (Object[])new Object[0]);
                }
            }
            if (FeatureLog.isLogLevelBlowInfo()) {
                FeatureLog.i((String)TAG, (String)"playMatchEffect end!!!", (Object[])new Object[0]);
            }
            return;
        }
        if (mSvgaImageView != null) {
            mSvgaImageView.startMatchEffect(matchUserInfo);
        }
    }

    private boolean checkVaild() {
        if (this.mViewContainer != null) {
            return true;
        }
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)TAG, (String)"checkVaild is false!!!", (Object[])new Object[0]);
        }
        return false;
    }

    private PickMeTipView getPickMeTipsView() {
        PickMeTipView tipView = (PickMeTipView)this.mViewContainer.findViewById(R.id.pick_me_match_tip);
        if (tipView != null) {
            return tipView;
        }
        tipView = new PickMeTipView(this.mViewContainer.getContext());
        tipView.setId(R.id.pick_me_match_tip);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -2);
        layoutParams.topMargin = ResolutionUtils.dip2Px((float)125.0f);
        tipView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.mViewContainer.addView((View)tipView);
        return tipView;
    }

    private PickMeMatchSVGAView createPickMeMatchEffectView(MatchEffectLevel matchEffectLevel) {
        PickMeMatchSVGAView svgaImageView = new PickMeMatchSVGAView(this.mViewContainer.getContext());
        RelativeLayout.LayoutParams layoutParams = null;
        switch (matchEffectLevel) {
            case PRIMARY: 
            case MEDIUM: {
                layoutParams = new RelativeLayout.LayoutParams(-1, ResolutionUtils.dip2Px((float)720.0f));
                layoutParams.topMargin = ResolutionUtils.dip2Px((float)55.0f);
                break;
            }
            case ULTIMATE: {
                layoutParams = new RelativeLayout.LayoutParams(-1, -1);
                break;
            }
            default: {
                layoutParams = new RelativeLayout.LayoutParams(-1, ResolutionUtils.dip2Px((float)240.0f));
                layoutParams.topMargin = ResolutionUtils.dip2Px((float)55.0f);
            }
        }
        svgaImageView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        svgaImageView.setId(R.id.pick_me_match_success_effect);
        svgaImageView.setPlayMatchEffectEnd(this.playMatchEffectEnd);
        return svgaImageView;
    }
}

