/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.pickme.model;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.util.Pair;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.account.AccountUtil;
import com.yy.base.logger.MLog;
import com.yy.hiyo.channel.plugins.pickme.bean.PlayerInfo;
import com.yy.hiyo.channel.plugins.pickme.bean.PublishResultInfo;
import com.yy.hiyo.channel.plugins.pickme.bean.RoundInfo;
import com.yy.hiyo.channel.plugins.pickme.common.MatchEffectLevel;
import com.yy.hiyo.channel.plugins.pickme.model.ProtoResult;
import com.yy.hiyo.channel.plugins.pickme.model.base.IProtoNotifyHandler;
import com.yy.hiyo.channel.plugins.pickme.model.base.IProtoService;
import com.yy.hiyo.channel.plugins.pickme.model.base.IResCallback;
import com.yy.hiyo.channel.plugins.pickme.model.base.IResDataCallback;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.hiyo.proto.callback.IProtoNotify;
import com.yy.hiyo.proto.callback.SimpleProtoCallback;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.ihago.room.api.calculator.GetPickMeCharmValueReq;
import net.ihago.room.api.calculator.GetPickMeCharmValueRes;
import net.ihago.room.srv.makefriend.FriendInfo;
import net.ihago.room.srv.makefriend.FriendNotify;
import net.ihago.room.srv.makefriend.GetRoundInfoReq;
import net.ihago.room.srv.makefriend.GetRoundInfoRes;
import net.ihago.room.srv.makefriend.NewRoundReq;
import net.ihago.room.srv.makefriend.NewRoundRes;
import net.ihago.room.srv.makefriend.PublishResultNotify;
import net.ihago.room.srv.makefriend.PublishResultReq;
import net.ihago.room.srv.makefriend.PublishResultRes;
import net.ihago.room.srv.makefriend.RoundStatus;
import net.ihago.room.srv.makefriend.SelectFriendItem;
import net.ihago.room.srv.makefriend.SelectFriendNotify;
import net.ihago.room.srv.makefriend.SelectFriendReq;
import net.ihago.room.srv.makefriend.SelectFriendRes;
import net.ihago.room.srv.makefriend.StartPublishResultReq;
import net.ihago.room.srv.makefriend.StartPublishResultRes;
import net.ihago.room.srv.makefriend.StartSelectFriendReq;
import net.ihago.room.srv.makefriend.StartSelectFriendRes;
import net.ihago.room.srv.makefriend.Uri;

public class ProtoService
implements IProtoService,
IProtoNotify<FriendNotify> {
    private static final String TAG = "FTPickMe#ProtoService";
    private final List<IProtoNotifyHandler> mNotifyHandlers = new LinkedList<IProtoNotifyHandler>();
    private String mRoomId;
    private static final int UNKNOW_STATUS = -1;

    public ProtoService(String roomId) {
        this.mRoomId = roomId;
    }

    @Override
    public void getRoundInfo(final @Nullable IResDataCallback<RoundInfo> callback) {
        GetRoundInfoReq req = new GetRoundInfoReq.Builder().build();
        ProtoManager.getInstance().sendRpc(this.mRoomId, (AndroidMessage)req, (IProtoCallback)new SimpleProtoCallback<GetRoundInfoRes>(){

            public void onResponse(@NonNull GetRoundInfoRes message, long code, String msg) {
                PlayerInfo playerInfo;
                super.onResponse((AndroidMessage)message, code, msg);
                if (callback == null) {
                    return;
                }
                if (code != (long)ProtoResult.SUCCESS.getCode()) {
                    callback.onFailure(code, msg);
                    return;
                }
                RoundInfo roundInfo = new RoundInfo();
                int roundStatus = ProtoService.this.parseStatus(message.status);
                if (roundStatus == -1) {
                    roundInfo.setSupport(false);
                } else {
                    roundInfo.setSupport(true);
                    roundInfo.setRoundStatus(roundStatus);
                }
                if (message.hasIntroduce.booleanValue()) {
                    roundInfo.setNewPickMe(true);
                } else {
                    roundInfo.setNewPickMe(false);
                }
                ArrayList<PlayerInfo> playerInfoList = new ArrayList<PlayerInfo>();
                if (message.select_friends != null) {
                    for (FriendInfo friendInfo : message.select_friends) {
                        playerInfo = new PlayerInfo();
                        playerInfo.setUid(friendInfo.from_uid);
                        playerInfo.setChoosedUid(friendInfo.to_uid);
                        playerInfo.setStatus(1);
                        playerInfoList.add(playerInfo);
                    }
                }
                if (message.publish_friends != null) {
                    for (FriendInfo friendInfo : message.publish_friends) {
                        playerInfo = new PlayerInfo();
                        playerInfo.setUid(friendInfo.from_uid);
                        playerInfo.setChoosedUid(friendInfo.to_uid);
                        playerInfo.setStatus(2);
                        playerInfoList.add(playerInfo);
                    }
                }
                roundInfo.setPlayerList(playerInfoList);
                callback.onSuccess(roundInfo);
            }

            public void onError(String reason, int code) {
                super.onError(reason, code);
                if (callback == null) {
                    return;
                }
                callback.onFailure(code, reason);
            }
        });
    }

    public int parseStatus(RoundStatus roundStatus) {
        int status = -1;
        switch (roundStatus) {
            case NotStart: {
                status = 0;
                break;
            }
            case Introduce: {
                status = 4;
                break;
            }
            case SelectFriend: {
                status = 1;
                break;
            }
            case PublishResult: {
                status = 2;
                break;
            }
            case GameOver: {
                status = 3;
                break;
            }
        }
        return status;
    }

    @Override
    public void startSelectFriend(final @Nullable IResCallback callback) {
        StartSelectFriendReq req = new StartSelectFriendReq().newBuilder().build();
        ProtoManager.getInstance().sendRpc(this.mRoomId, (AndroidMessage)req, (IProtoCallback)new SimpleProtoCallback<StartSelectFriendRes>(){

            public void onResponse(@NonNull StartSelectFriendRes message, long code, String msg) {
                super.onResponse((AndroidMessage)message, code, msg);
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)ProtoService.TAG, (String)"start select friend success code: %s,msg: %s", (Object[])new Object[]{code, msg});
                }
                if (callback == null) {
                    return;
                }
                if (code != (long)ProtoResult.SUCCESS.getCode()) {
                    callback.onFailure(code, msg);
                    return;
                }
                callback.onSuccess();
            }

            public void onError(String reason, int code) {
                super.onError(reason, code);
                MLog.error((Object)ProtoService.TAG, (String)"start select friend onError: %s, code: ", (Object[])new Object[]{reason, code});
                if (callback != null) {
                    callback.onFailure(code, reason);
                }
            }
        });
    }

    @Override
    public void selectFriend(long uid, boolean isSelect, final @Nullable IResCallback callback) {
        FriendInfo friendInfo = new FriendInfo.Builder().from_uid(Long.valueOf(AccountUtil.getUid())).to_uid(Long.valueOf(uid)).build();
        SelectFriendItem selectFriendItem = new SelectFriendItem.Builder().friend(friendInfo).select(Boolean.valueOf(isSelect)).build();
        SelectFriendReq req = new SelectFriendReq.Builder().select_friend_items(Collections.singletonList(selectFriendItem)).build();
        ProtoManager.getInstance().sendRpc(this.mRoomId, (AndroidMessage)req, (IProtoCallback)new SimpleProtoCallback<SelectFriendRes>(){

            public void onResponse(@NonNull SelectFriendRes message, long code, String msg) {
                super.onResponse((AndroidMessage)message, code, msg);
                if (callback == null) {
                    return;
                }
                if (code != (long)ProtoResult.SUCCESS.getCode()) {
                    callback.onFailure(code, msg);
                    return;
                }
                callback.onSuccess();
            }

            public void onError(String reason, int code) {
                super.onError(reason, code);
                if (callback == null) {
                    return;
                }
                callback.onFailure(code, reason);
            }
        });
    }

    @Override
    public void startNewRound(final @Nullable IResCallback callback) {
        NewRoundReq req = new NewRoundReq.Builder().build();
        ProtoManager.getInstance().sendRpc(this.mRoomId, (AndroidMessage)req, (IProtoCallback)new SimpleProtoCallback<NewRoundRes>(){

            public void onResponse(@NonNull NewRoundRes message, long code, String msg) {
                super.onResponse((AndroidMessage)message, code, msg);
                if (callback == null) {
                    return;
                }
                if (code != (long)ProtoResult.SUCCESS.getCode()) {
                    callback.onFailure(code, msg);
                    return;
                }
                callback.onSuccess();
            }

            public void onError(String reason, int code) {
                super.onError(reason, code);
                if (callback == null) {
                    return;
                }
                callback.onFailure(code, reason);
            }
        });
    }

    @Override
    public void startPublish(final @Nullable IResCallback callback) {
        StartPublishResultReq req = new StartPublishResultReq.Builder().build();
        ProtoManager.getInstance().sendRpc(this.mRoomId, (AndroidMessage)req, (IProtoCallback)new SimpleProtoCallback<StartPublishResultRes>(){

            public void onResponse(@NonNull StartPublishResultRes message, long code, String msg) {
                super.onResponse((AndroidMessage)message, code, msg);
                if (callback == null) {
                    return;
                }
                if (code != (long)ProtoResult.SUCCESS.getCode()) {
                    callback.onFailure(code, msg);
                    return;
                }
                callback.onSuccess();
            }

            public void onError(String reason, int code) {
                super.onError(reason, code);
                callback.onFailure(code, reason);
            }
        });
    }

    @Override
    public void publishPlayerChoice(long uid, final @Nullable IResCallback callback) {
        PublishResultReq req = new PublishResultReq.Builder().uids(Collections.singletonList(uid)).build();
        ProtoManager.getInstance().sendRpc(this.mRoomId, (AndroidMessage)req, (IProtoCallback)new SimpleProtoCallback<PublishResultRes>(){

            public void onResponse(@NonNull PublishResultRes message, long code, String msg) {
                super.onResponse((AndroidMessage)message, code, msg);
                if (callback == null) {
                    return;
                }
                if (code != (long)ProtoResult.SUCCESS.getCode()) {
                    callback.onFailure(code, msg);
                    return;
                }
                callback.onSuccess();
            }

            public void onError(String reason, int code) {
                super.onError(reason, code);
                if (callback == null) {
                    return;
                }
                callback.onFailure(code, reason);
            }
        });
    }

    @Override
    public void getCharmInfo(long maleUid, long femaleUid, final IResDataCallback<Pair<Long, MatchEffectLevel>> callback) {
        GetPickMeCharmValueReq req = new GetPickMeCharmValueReq.Builder().room_id(this.mRoomId).man_uid(Long.valueOf(maleUid)).girl_uid(Long.valueOf(femaleUid)).build();
        ProtoManager.getInstance().sendRpc(this.mRoomId, (AndroidMessage)req, (IProtoCallback)new SimpleProtoCallback<GetPickMeCharmValueRes>(){

            public void onResponse(@NonNull GetPickMeCharmValueRes message, long code, String msg) {
                super.onResponse((AndroidMessage)message, code, msg);
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)ProtoService.TAG, (String)"getCharmValue onResponse code: %s,msg: %s", (Object[])new Object[]{code, msg});
                }
                if (callback == null) {
                    return;
                }
                if (code != (long)ProtoResult.SUCCESS.getCode()) {
                    callback.onFailure(code, msg);
                    return;
                }
                Pair pair = new Pair((Object)message.pickme_charm_total, (Object)ProtoService.this.parseCharmRange(message.pickme_charm_range));
                callback.onSuccess(pair);
            }

            public void onError(String reason, int code) {
                super.onError(reason, code);
                MLog.error((Object)ProtoService.TAG, (String)"getCharmValue onError reason: %s,code: %s", (Object[])new Object[]{reason, code});
                if (callback == null) {
                    return;
                }
                callback.onFailure(code, reason);
            }
        });
    }

    private MatchEffectLevel parseCharmRange(long charmRange) {
        MatchEffectLevel level = charmRange == 2L ? MatchEffectLevel.PRIMARY : (charmRange == 3L ? MatchEffectLevel.MEDIUM : (charmRange == 4L ? MatchEffectLevel.ULTIMATE : MatchEffectLevel.LOWER));
        return level;
    }

    @Override
    public void addNotifyHandler(IProtoNotifyHandler handler) {
        if (this.mNotifyHandlers.contains(handler)) {
            return;
        }
        this.mNotifyHandlers.add(handler);
    }

    @Override
    public void removeNotifyHandler(IProtoNotifyHandler handler) {
        this.mNotifyHandlers.remove(handler);
    }

    @Override
    public void startNotifyListen() {
        ProtoManager.getInstance().registerNotify((IProtoNotify)this);
    }

    @Override
    public void stopNotifyListen() {
        ProtoManager.getInstance().unregisterNotify((IProtoNotify)this);
        this.mNotifyHandlers.clear();
    }

    public String serviceName() {
        return "net.ihago.room.srv.makefriend";
    }

    public void onNotify(@NonNull FriendNotify notify) {
        block21: {
            PublishResultNotify publishResultNotify;
            block24: {
                block23: {
                    SelectFriendNotify selectFriendNotify;
                    block22: {
                        block20: {
                            if (notify.uri != Uri.kUriStartIntroduce) break block20;
                            if (MLog.isLogLevelBlowInfo()) {
                                MLog.info((Object)TAG, (String)"onStartIntroduce", (Object[])new Object[0]);
                            }
                            for (IProtoNotifyHandler handler : this.mNotifyHandlers) {
                                handler.onStartIntroduceNotify();
                            }
                            break block21;
                        }
                        if (notify.uri != Uri.kUriStartSelectFriend) break block22;
                        if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)TAG, (String)"onStartSelectNotify", (Object[])new Object[0]);
                        }
                        for (IProtoNotifyHandler handler : this.mNotifyHandlers) {
                            handler.onStartSelectNotify();
                        }
                        break block21;
                    }
                    if (notify.uri != Uri.kUriSelectFriend) break block23;
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TAG, (String)"onSelectStatusNotify", (Object[])new Object[0]);
                    }
                    if ((selectFriendNotify = notify.select_friend_notify) == null) {
                        return;
                    }
                    ArrayList<PlayerInfo> playerInfoList = new ArrayList<PlayerInfo>();
                    if (selectFriendNotify.select_friend_items != null) {
                        for (SelectFriendItem friendItem : selectFriendNotify.select_friend_items) {
                            if (friendItem.friend == null) continue;
                            PlayerInfo playerInfo = new PlayerInfo();
                            playerInfo.setUid(friendItem.friend.from_uid);
                            playerInfo.setChoosedUid(friendItem.friend.to_uid);
                            if (friendItem.select.booleanValue()) {
                                playerInfo.setStatus(1);
                            } else {
                                playerInfo.setStatus(0);
                            }
                            playerInfoList.add(playerInfo);
                        }
                    }
                    for (IProtoNotifyHandler handler : this.mNotifyHandlers) {
                        handler.onSelectStatusNotify(playerInfoList);
                    }
                    break block21;
                }
                if (notify.uri != Uri.kUriStartPublishResult) break block24;
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)"onPublishStartNotify", (Object[])new Object[0]);
                }
                for (IProtoNotifyHandler handler : this.mNotifyHandlers) {
                    handler.onPublishStartNotify();
                }
                break block21;
            }
            if (notify.uri != Uri.kUriPublishResult) break block21;
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"onPublishResultNotify", (Object[])new Object[0]);
            }
            if ((publishResultNotify = notify.publish_result_notify) == null) {
                return;
            }
            ArrayList<PlayerInfo> playerInfoList = new ArrayList<PlayerInfo>();
            if (publishResultNotify.publish_friends != null) {
                for (Object friendInfo : publishResultNotify.publish_friends) {
                    PlayerInfo playerInfo = new PlayerInfo();
                    playerInfo.setUid(((FriendInfo)friendInfo).from_uid);
                    playerInfo.setChoosedUid(((FriendInfo)friendInfo).to_uid);
                    playerInfo.setStatus(2);
                    playerInfoList.add(playerInfo);
                }
            }
            ArrayList<PlayerInfo> matchSuccessPlayers = new ArrayList<PlayerInfo>();
            if (publishResultNotify.match_results != null) {
                for (FriendInfo friendInfo : publishResultNotify.match_results) {
                    PlayerInfo playerInfo = new PlayerInfo();
                    playerInfo.setUid(friendInfo.from_uid);
                    playerInfo.setChoosedUid(friendInfo.to_uid);
                    matchSuccessPlayers.add(playerInfo);
                }
            }
            PublishResultInfo resultInfo = new PublishResultInfo();
            resultInfo.setPublishPlayers(playerInfoList);
            resultInfo.setMatchSuccessPlayers(matchSuccessPlayers);
            resultInfo.setRandomNumber(publishResultNotify.random);
            resultInfo.setCanNextRound(publishResultNotify.can_start_new_round);
            for (IProtoNotifyHandler handler : this.mNotifyHandlers) {
                handler.onPublishResultNotify(resultInfo);
            }
        }
    }
}

