/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.pickme.ui.view;

import android.app.Dialog;
import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.LinearLayout;
import com.yy.appbase.ui.widget.image.RoundImageView;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.ResourceUtils;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogId;
import com.yy.hiyo.channel.plugins.pickme.DR;
import com.yy.hiyo.channel.plugins.pickme.R;
import com.yy.hiyo.channel.plugins.pickme.ui.callback.IPublishGuideCallback;
import com.yy.hiyo.channel.plugins.pickme.ui.callback.IStartGuideCallback;
import com.yy.hiyo.channel.plugins.pickme.ui.view.RulesView;
import com.yy.hiyo.dyres.api.DyResLoader;
import java.util.ArrayList;
import java.util.List;

public class PickMeRulesDialog
implements BaseDialog {
    private int dialogType;
    private YYLinearLayout linearLayout;
    private YYTextView tvLater;
    private YYTextView tvOk;
    private YYTextView tvTitle;
    private RoundImageView ivTitle;
    private IPublishGuideCallback publishGuideCallback;
    private IStartGuideCallback startGuideCallback;

    public void setPublishGuideCallback(IPublishGuideCallback publishGuideCallback) {
        this.publishGuideCallback = publishGuideCallback;
    }

    public void setStartGuideCallback(IStartGuideCallback startGuideCallback) {
        this.startGuideCallback = startGuideCallback;
    }

    public PickMeRulesDialog(int dialogType) {
        this.dialogType = dialogType;
    }

    public void init(Dialog dialog2) {
        Window window = dialog2.getWindow();
        dialog2.setCanceledOnTouchOutside(false);
        dialog2.setCancelable(true);
        if (window == null) {
            return;
        }
        window.setContentView(R.layout.layout_room_pick_me_tip_dialog_channel);
        this.linearLayout = (YYLinearLayout)window.findViewById(R.id.ll_rules);
        this.ivTitle = (RoundImageView)window.findViewById(R.id.iv_title);
        this.tvLater = (YYTextView)window.findViewById(R.id.tv_later);
        this.tvOk = (YYTextView)window.findViewById(R.id.tv_ok);
        this.tvTitle = (YYTextView)window.findViewById(R.id.tv_title);
        this.initView(window.getContext(), dialog2);
    }

    private void initView(Context context, Dialog dialog2) {
        String title = this.getTitle();
        this.tvTitle.setText((CharSequence)title);
        List<String> tipList = this.getTipList();
        for (int i = 0; i < tipList.size(); ++i) {
            String tip = tipList.get(i);
            RulesView view = new RulesView(context);
            view.setRule(tip);
            LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -2);
            view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            this.linearLayout.addView((View)view);
        }
        if (this.dialogType == 2) {
            DyResLoader.INSTANCE.loadImage((RecycleImageView)this.ivTitle, DR.ico_pick_me_annouce);
            this.tvLater.setText((CharSequence)ResourceUtils.getString((int)R.string.btn_pick_me_later));
            this.tvOk.setText((CharSequence)ResourceUtils.getString((int)R.string.btn_picme_publish));
        } else {
            DyResLoader.INSTANCE.loadImage((RecycleImageView)this.ivTitle, DR.ico_pick_me_rules);
            this.tvLater.setVisibility(8);
            this.tvOk.setText((CharSequence)ResourceUtils.getString((int)R.string.btn_pick_me_get_it));
        }
        this.tvLater.setOnClickListener(v -> {
            dialog2.dismiss();
            if (this.publishGuideCallback != null) {
                this.publishGuideCallback.onLater();
            }
        });
        this.tvOk.setOnClickListener(v -> {
            dialog2.dismiss();
            if (this.dialogType == 2) {
                if (this.publishGuideCallback != null) {
                    this.publishGuideCallback.onPublish();
                }
            } else if (this.startGuideCallback != null) {
                this.startGuideCallback.onGet();
            }
        });
    }

    public int getId() {
        return DialogId.PickMeRulesDialog;
    }

    private String getTitle() {
        if (this.dialogType == 2) {
            return ResourceUtils.getString((int)R.string.title_announce);
        }
        if (this.dialogType == 0) {
            return ResourceUtils.getString((int)R.string.title_pick_me);
        }
        return ResourceUtils.getString((int)R.string.title_pick_me_guide_dialog);
    }

    private List<String> getTipList() {
        ArrayList<String> tipList = new ArrayList<String>();
        if (this.dialogType == 2) {
            tipList.add(ResourceUtils.getString((int)R.string.tips_announce_1));
            tipList.add(ResourceUtils.getString((int)R.string.tips_announce_2));
            return tipList;
        }
        if (this.dialogType == 0) {
            tipList.add(ResourceUtils.getString((int)R.string.tips_picke_me_1));
            tipList.add(ResourceUtils.getString((int)R.string.tips_picke_me_2));
            tipList.add(ResourceUtils.getString((int)R.string.tips_picke_me_3));
            return tipList;
        }
        tipList.add(ResourceUtils.getString((int)R.string.tips_pick_me_new_guide_1));
        tipList.add(ResourceUtils.getString((int)R.string.tips_picke_me_1));
        tipList.add(ResourceUtils.getString((int)R.string.tips_pick_me_new_guide_2));
        return tipList;
    }
}

