/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.pickme.ui.view;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.yy.appbase.DpToPxDef;
import com.yy.appbase.ui.widget.bubble.BubblePopupWindow;
import com.yy.appbase.ui.widget.bubble.BubbleStyle;
import com.yy.appbase.ui.widget.bubble.BubbleTextView;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.memoryrecycle.views.YYRelativeLayout;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.LanguageUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.hiyo.channel.plugins.pickme.R;
import com.yy.hiyo.channel.plugins.pickme.bean.FuncBtnStatus;
import com.yy.hiyo.channel.plugins.pickme.ui.callback.IFunctionMenuClickListener;

public class FunctionMenuView
extends YYRelativeLayout
implements View.OnClickListener {
    public TextView mTvFuncBtn;
    public TextView mTvEndBtn;
    public TextView mTvQueueBtn;
    public TextView mTvNextBtn;
    public YYImageView mFuncImg;
    public YYImageView mEndImg;
    public YYImageView mQueueImg;
    public YYImageView mNextImg;
    public YYLinearLayout mFuncContainer;
    public YYLinearLayout mEndContainer;
    public YYLinearLayout mQueueContainer;
    public YYLinearLayout mNextContainer;
    public ImageView mIvIcon;
    private boolean isAniming = false;
    private int animTime = 300;
    private int stayCloseTime = 3000;
    private boolean isOpen = false;
    private Runnable delayRunnable = null;
    private IFunctionMenuClickListener listener;
    boolean isGuideShowed = false;
    private Runnable mCloseRunnable = () -> {
        if (this.isOpen) {
            this.closeFunctionMenuView();
        }
    };

    public void setListener(IFunctionMenuClickListener listener) {
        this.listener = listener;
    }

    public FunctionMenuView(Context context) {
        super(context);
        this.createView();
    }

    public FunctionMenuView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.createView();
    }

    public FunctionMenuView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.createView();
    }

    private void createView() {
        FunctionMenuView.inflate((Context)this.getContext(), (int)R.layout.view_pick_me_function_menu_channel, (ViewGroup)this);
        this.mTvFuncBtn = (TextView)this.findViewById(R.id.tv_func_btn);
        this.mTvEndBtn = (TextView)this.findViewById(R.id.tv_end_btn);
        this.mTvQueueBtn = (TextView)this.findViewById(R.id.tv_queue_btn);
        this.mTvNextBtn = (TextView)this.findViewById(R.id.tv_next_btn);
        this.mFuncImg = (YYImageView)this.findViewById(R.id.announce_img);
        this.mEndImg = (YYImageView)this.findViewById(R.id.end_img);
        this.mQueueImg = (YYImageView)this.findViewById(R.id.queu_img);
        this.mNextImg = (YYImageView)this.findViewById(R.id.next_img);
        this.mFuncContainer = (YYLinearLayout)this.findViewById(R.id.ll_announce);
        this.mEndContainer = (YYLinearLayout)this.findViewById(R.id.ll_end);
        this.mQueueContainer = (YYLinearLayout)this.findViewById(R.id.ll_queue);
        this.mNextContainer = (YYLinearLayout)this.findViewById(R.id.ll_next_round);
        this.mIvIcon = (ImageView)this.findViewById(R.id.iv_pick_me);
        this.mIvIcon.setOnClickListener((View.OnClickListener)this);
        this.mFuncContainer.setOnClickListener((View.OnClickListener)this);
        this.mEndContainer.setOnClickListener((View.OnClickListener)this);
        this.mQueueContainer.setOnClickListener((View.OnClickListener)this);
    }

    public void updateWaitingSize(int size) {
        this.mTvQueueBtn.setText((CharSequence)ResourceUtils.getString((int)R.string.short_tips_queue, (Object[])new Object[]{size}));
    }

    public void hasEmptySeat(boolean has) {
        if (has) {
            this.mQueueContainer.setVisibility(8);
            YYTaskExecutor.removeTask((Runnable)this.delayRunnable);
            this.delayRunnable = null;
        } else {
            this.mQueueContainer.setVisibility(0);
            if (this.delayRunnable == null && !this.isGuideShowed) {
                this.isGuideShowed = SettingFlags.getBoolean((String)"key_pick_me_queue_guide", (boolean)false);
                if (!this.isGuideShowed) {
                    this.delayRunnable = new Runnable(){

                        @Override
                        public void run() {
                            FunctionMenuView.this.showBubbleWindow();
                        }
                    };
                    YYTaskExecutor.postToMainThread((Runnable)this.delayRunnable, (long)10000L);
                }
            }
        }
    }

    public void showBubbleWindow() {
        View createBubbleView = View.inflate((Context)this.getContext(), (int)R.layout.dialog_channel_common_guide, null);
        createBubbleView.setBackgroundColor(ResourceUtils.getColor((int)R.color.white));
        BubbleTextView bubbleTv = (BubbleTextView)createBubbleView.findViewById(R.id.create_bubble_tv);
        bubbleTv.setText(R.string.short_tips_join_guide);
        bubbleTv.setFillColor(ResourceUtils.getColor((int)R.color.white));
        bubbleTv.setTextColor(ResourceUtils.getColor((int)R.color.color_333333));
        bubbleTv.setCornerRadius((float)ResolutionUtils.dip2Px((float)3.0f));
        BubblePopupWindow mWindow = new BubblePopupWindow(createBubbleView, (BubbleStyle)bubbleTv);
        mWindow.setCancelOnTouchOutside(true);
        mWindow.setCancelOnLater(10000L);
        mWindow.showArrowTo((View)this.mIvIcon, BubbleStyle.ArrowDirection.Down, DpToPxDef.RESOLUTION_5_DP);
        SettingFlags.setBoolean((String)"key_pick_me_queue_guide", (boolean)true);
        this.isGuideShowed = true;
    }

    public void updateStatus(FuncBtnStatus status) {
        if (status.getType() == -1) {
            this.mTvFuncBtn.setText(R.string.title_pick_me);
            this.mFuncImg.setImageResource(R.drawable.icon_announce);
            this.updateAlpha(status);
        } else if (status.getType() == 0) {
            this.mTvFuncBtn.setText(R.string.btn_pick_me_publish);
            this.mFuncImg.setImageResource(R.drawable.icon_announce);
            this.updateAlpha(status);
        } else if (status.getType() == 1) {
            this.mTvFuncBtn.setText(R.string.btn_pick_me_new_round);
            this.mFuncImg.setImageResource(R.drawable.icon_next);
            this.updateAlpha(status);
        }
        this.mTvEndBtn.setActivated(true);
    }

    private void updateAlpha(FuncBtnStatus status) {
        if (status.isCanClick()) {
            this.mFuncImg.setAlpha(1.0f);
        } else {
            this.mFuncImg.setAlpha(0.4f);
        }
        this.mTvFuncBtn.setActivated(status.isCanClick());
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.openFunctionMenuView();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        YYTaskExecutor.removeTask((Runnable)this.mCloseRunnable);
        YYTaskExecutor.removeTask((Runnable)this.delayRunnable);
        this.delayRunnable = null;
        this.clearAnimation();
    }

    private void openFunctionMenuView() {
        YYTaskExecutor.removeTask((Runnable)this.mCloseRunnable);
        this.isAniming = true;
        this.isOpen = true;
        int width = ResolutionUtils.dip2Px((float)200.0f);
        int transX = LanguageUtils.isRtl() ? ResolutionUtils.dip2Px((float)42.0f) - width : width - ResolutionUtils.dip2Px((float)42.0f);
        ObjectAnimator tranAni = ObjectAnimator.ofFloat((Object)((Object)this), (String)"translationX", (float[])new float[]{transX, 0.0f});
        tranAni.setDuration((long)this.animTime);
        tranAni.start();
        tranAni.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                FunctionMenuView.this.isAniming = false;
                YYTaskExecutor.postToMainThread((Runnable)FunctionMenuView.this.mCloseRunnable, (long)FunctionMenuView.this.stayCloseTime);
            }
        });
    }

    private void closeFunctionMenuView() {
        YYTaskExecutor.removeTask((Runnable)this.mCloseRunnable);
        this.isAniming = true;
        this.isOpen = false;
        int width = ResolutionUtils.dip2Px((float)180.0f);
        int transX = LanguageUtils.isRtl() ? ResolutionUtils.dip2Px((float)42.0f) - width : width - ResolutionUtils.dip2Px((float)42.0f);
        ObjectAnimator tranAni = ObjectAnimator.ofFloat((Object)((Object)this), (String)"translationX", (float[])new float[]{0.0f, transX});
        tranAni.setDuration((long)this.animTime);
        tranAni.start();
        tranAni.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                FunctionMenuView.this.isAniming = false;
            }
        });
    }

    public void onClick(View v) {
        YYTaskExecutor.removeTask((Runnable)this.mCloseRunnable);
        YYTaskExecutor.postToMainThread((Runnable)this.mCloseRunnable, (long)this.stayCloseTime);
        if (this.listener == null) {
            return;
        }
        if (v == this.mFuncContainer) {
            this.listener.onFunctionClick();
        } else if (v == this.mEndContainer) {
            this.listener.onEndClick();
        } else if (v == this.mIvIcon) {
            if (this.isAniming) {
                return;
            }
            if (this.isOpen) {
                this.closeFunctionMenuView();
            } else {
                this.openFunctionMenuView();
            }
            if (this.listener != null) {
                this.listener.onIconClick();
            }
        } else if (v == this.mQueueContainer && this.listener != null) {
            this.listener.onQueueClick();
        }
    }
}

