/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.pickme.seat;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.lifecycle.LifecycleOwner;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.UserInfoModule;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.callback.OnProfileCallback;
import com.yy.appbase.ui.adapter.BaseItemBinder;
import com.yy.base.logger.MLog;
import com.yy.hiyo.channel.base.bean.SeatUser;
import com.yy.hiyo.channel.cbase.context.IChannelPageContext;
import com.yy.hiyo.channel.component.seat.SeatMvp;
import com.yy.hiyo.channel.component.seat.SeatViewContainer;
import com.yy.hiyo.channel.component.seat.bean.SeatItem;
import com.yy.hiyo.channel.component.seat.seatview.NormalSeatViewWrapper;
import com.yy.hiyo.channel.plugins.pickme.R;
import com.yy.hiyo.channel.plugins.pickme.base.PickMeContext;
import com.yy.hiyo.channel.plugins.pickme.bean.PlayerInfo;
import com.yy.hiyo.channel.plugins.pickme.business.dataprovider.IDataProvider;
import com.yy.hiyo.channel.plugins.pickme.seat.PickMeSeatItem;
import com.yy.hiyo.channel.plugins.pickme.seat.PickMeSeatItemHolder;
import com.yy.hiyo.channel.plugins.pickme.ui.base.ISeatViewManager;
import com.yy.hiyo.channel.plugins.pickme.ui.callback.IPickMeHolderCallback;
import com.yy.hiyo.channel.plugins.voiceroom.base.AbsRoomSeatPresenter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.drakeet.multitype.ItemViewBinder;

public class PickmeSeatPresenter
extends AbsRoomSeatPresenter<NormalSeatViewWrapper>
implements ISeatViewManager {
    private static final String TAG = "FTPickMe#SeatViewManager";
    private PickMeContext pickMeContext;
    private IDataProvider provider;
    private Map<Long, PickMeSeatItem> pickMeSeatItems = new LinkedHashMap<Long, PickMeSeatItem>();
    private Set<Long> hadShowResult = new HashSet<Long>();
    private long selfChooseUid = 0L;
    private IPickMeHolderCallback pickMeHolderCallback = null;
    private IPickMeHolderCallback mInnerCallbackHolder = new IPickMeHolderCallback(){

        @Override
        public void onPickMeOperationClick(int pickMode, long chooseUid) {
            if (PickmeSeatPresenter.this.pickMeHolderCallback != null) {
                PickmeSeatPresenter.this.pickMeHolderCallback.onPickMeOperationClick(pickMode, chooseUid);
            }
        }

        @Override
        public int getUidIndex(long uid) {
            if (PickmeSeatPresenter.this.pickMeHolderCallback != null) {
                return PickmeSeatPresenter.this.pickMeHolderCallback.getUidIndex(uid);
            }
            return 0;
        }

        @Override
        public boolean hasShowResult(long uid) {
            if (PickmeSeatPresenter.this.pickMeHolderCallback != null) {
                return PickmeSeatPresenter.this.pickMeHolderCallback.hasShowResult(uid);
            }
            return false;
        }

        @Override
        public void setHasShowResult(long uid) {
            if (PickmeSeatPresenter.this.pickMeHolderCallback != null) {
                PickmeSeatPresenter.this.pickMeHolderCallback.setHasShowResult(uid);
            }
        }
    };

    @Override
    public void initPickMeContext(@NonNull PickMeContext pickMeContext) {
        this.pickMeContext = pickMeContext;
    }

    @Override
    public void initDataProvider(IDataProvider dataProvider, LifecycleOwner lifecycleOwner) {
        this.provider = dataProvider;
        this.provider.getStatus().observe(lifecycleOwner, status -> {
            if (status == null) {
                return;
            }
            MLog.info((Object)TAG, (String)"observe status:%d", (Object[])new Object[]{status});
            this.updateAllUserStatus();
            if (this.pickMeContext.isNewPickMe()) {
                if (status == 4) {
                    this.hadShowResult.clear();
                }
            } else if (status == 1) {
                this.hadShowResult.clear();
            }
        });
        this.provider.getPlayerUpdateData().observe(lifecycleOwner, playerUpdateData -> {
            if (playerUpdateData == null) {
                return;
            }
            if (playerUpdateData.getType() == 2 || playerUpdateData.getType() == 0) {
                long uid = playerUpdateData.getUid();
                PlayerInfo playerInfo = this.provider.getPlayerByUid(uid);
                this.updateStatus(uid, playerInfo);
            }
        });
    }

    private void updateStatus(long changeUid, PlayerInfo playerInfo) {
        this.updateStatus(changeUid, playerInfo, true);
    }

    private void updateStatus(long changeUid, PlayerInfo playerInfo, boolean checkSex) {
        if (playerInfo != null) {
            int runningStatus = (Integer)this.provider.getStatus().getValue();
            long choosenUid = playerInfo.getChoosedUid();
            int playerStatus = playerInfo.getStatus();
            if (!MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)TAG, (String)"updateStatus, runningStatus=%s, %s", (Object[])new Object[]{runningStatus, playerInfo});
            }
            if (runningStatus == 0) {
                MLog.info((Object)TAG, (String)"NONE uid:%d, chose:%d, playerStatus:%d", (Object[])new Object[]{changeUid, choosenUid, playerStatus});
            } else if (runningStatus == 4) {
                if (playerStatus == 0) {
                    this.updateStatusInner(changeUid, 2, 0L, checkSex);
                }
                this.selfChooseUid = 0L;
                this.updateStatusInner(changeUid, 1, 0L, checkSex);
            } else if (runningStatus == 1) {
                if (playerStatus == 0) {
                    MLog.info((Object)TAG, (String)"CHOOSING NOCHOICE uid:%d, chose:%d, playerStatus:%d", (Object[])new Object[]{changeUid, choosenUid, playerStatus});
                    this.updateStatusInner(changeUid, 2, 0L, checkSex);
                } else if (playerStatus == 1) {
                    MLog.info((Object)TAG, (String)"CHOOSING CHOOSED uid:%d, chose:%d, playerStatus:%d", (Object[])new Object[]{changeUid, choosenUid, playerStatus});
                    this.updateStatusInner(changeUid, 4, choosenUid, checkSex);
                }
                boolean selfInSeat = this.getChannel().getSeatService().isInSeat(AccountUtil.getUid());
                MLog.info((Object)TAG, (String)"CHOOSING uid:%d, selfInSeat:%b, selfChooseUid:%d", (Object[])new Object[]{changeUid, selfInSeat, this.selfChooseUid});
                if (selfInSeat) {
                    if (changeUid == AccountUtil.getUid()) {
                        if (playerStatus == 0) {
                            if (this.selfChooseUid > 0L) {
                                this.updateStatusInner(this.selfChooseUid, 8, 0L, checkSex);
                            }
                            this.selfChooseUid = 0L;
                        } else if (playerStatus == 1) {
                            if (choosenUid != this.selfChooseUid) {
                                if (this.selfChooseUid > 0L) {
                                    this.updateStatusInner(this.selfChooseUid, 8, 0L, checkSex);
                                }
                                if (choosenUid > 0L) {
                                    this.updateStatusInner(choosenUid, 16, 0L, checkSex);
                                }
                            }
                            this.selfChooseUid = choosenUid;
                        }
                        this.updateStatusInner(changeUid, 1, 0L, checkSex);
                    } else if (this.selfChooseUid == changeUid) {
                        this.updateStatusInner(changeUid, 16, 0L, checkSex);
                    } else {
                        this.updateStatusInner(changeUid, 8, 0L, checkSex);
                    }
                } else {
                    this.updateStatusInner(changeUid, 1, 0L, checkSex);
                }
            } else if (runningStatus == 2 || runningStatus == 3) {
                if (playerStatus == 0) {
                    MLog.info((Object)TAG, (String)"PUBLISHING NOCHOICE uid:%d, chose:%d, playerStatus:%d", (Object[])new Object[]{changeUid, choosenUid, playerStatus});
                    this.updateStatusInner(changeUid, 1, 0L, checkSex);
                } else if (playerStatus == 1) {
                    MLog.info((Object)TAG, (String)"PUBLISHING CHOOSED uid:%d, chose:%d, playerStatus:%d", (Object[])new Object[]{changeUid, choosenUid, playerStatus});
                    if ((this.getChannel().getRoleService().isOwnerOrMaster(AccountUtil.getUid()) || this.getChannel().getRoleService().isAnchor(AccountUtil.getUid())) && this.getChannel().getSeatService().isInFirstSeat(AccountUtil.getUid())) {
                        this.updateStatusInner(changeUid, 64, choosenUid, checkSex);
                    } else {
                        this.updateStatusInner(changeUid, 32, choosenUid, checkSex);
                    }
                } else if (playerStatus == 2) {
                    MLog.info((Object)TAG, (String)"PUBLISHING PUBLISHED uid:%d, chose:%d, playerStatus:%d", (Object[])new Object[]{changeUid, choosenUid, playerStatus});
                    this.updateStatusInner(changeUid, 128, choosenUid, checkSex);
                }
            }
        } else {
            this.updateStatusInner(changeUid, 1, 0L, checkSex);
            MLog.info((Object)TAG, (String)"PUBLISHING NOT_VALID uid:%d, chose:%d, playerStatus:%d", (Object[])new Object[]{changeUid, 0, 0});
        }
    }

    @Override
    public void destroy() {
        SeatViewContainer seatView = this.getSeatViewContainer();
        if (seatView != null) {
            int counts = ((NormalSeatViewWrapper)this.mSeatViewWrapper).getAdapter().getItemCount();
            View innerSeatView = seatView.getInnerView();
            if (innerSeatView instanceof RecyclerView) {
                for (int i = 0; i < counts; ++i) {
                    RecyclerView.ViewHolder viewHolder = ((RecyclerView)innerSeatView).findViewHolderForAdapterPosition(i);
                    if (!(viewHolder instanceof PickMeSeatItemHolder)) continue;
                    PickMeSeatItemHolder seatItemHolder = (PickMeSeatItemHolder)viewHolder;
                    seatItemHolder.destroy();
                }
            }
        }
    }

    @Override
    public void setCallBack(IPickMeHolderCallback iPickMeHolderCallback) {
        this.pickMeHolderCallback = iPickMeHolderCallback;
        MLog.info((Object)TAG, (String)"setCallBack pickMeHolderCallback:%s", (Object[])new Object[]{this.pickMeHolderCallback});
    }

    @Override
    public void onResume() {
        if (this.selfChooseUid > 0L) {
            ((NormalSeatViewWrapper)this.mSeatViewWrapper).getAdapter().notifyDataSetChanged();
        }
        this.updateAllUserStatus();
    }

    @Override
    public boolean hasShowResult(long uid) {
        return this.hadShowResult.contains(uid);
    }

    @Override
    public void setHasShowResult(long uid) {
        this.hadShowResult.add(uid);
    }

    public void updateStatusInner(final long uid, int mode, long choosenUid, boolean checkSex) {
        PickMeSeatItem item = this.pickMeSeatItems.get(uid);
        if (item != null) {
            if (checkSex && item.userInfo.uid > 0L && !item.userInfo.isLoadFinish()) {
                item.setPickMode(1);
                ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getUserInfo(item.userInfo.uid, new OnProfileCallback(){

                    public void onSuccess(int id2, List<UserInfoKS> userInfoKSList) {
                        if (PickmeSeatPresenter.this.provider != null) {
                            PlayerInfo playerInfo = PickmeSeatPresenter.this.provider.getPlayerByUid(uid);
                            PickmeSeatPresenter.this.updateStatus(uid, playerInfo, false);
                        }
                    }

                    public void onFail(int id2, String msg, String response) {
                    }

                    public int id() {
                        return 0;
                    }
                });
            } else if (PickMeSeatItem.isSameMainMode(mode, 8) && ((IUserInfoService)ServiceManagerProxy.getService(IUserInfoService.class)).getUserInfo((long)AccountUtil.getUid()).sex == item.userInfo.sex) {
                item.setPickMode(1);
            } else {
                item.setPickMode(mode);
            }
            if (choosenUid > 0L) {
                item.setPickedPerson(((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getUserInfo(choosenUid, null));
            } else {
                item.setPickedPerson(null);
            }
        }
    }

    public void updateAllUserStatus() {
        ArrayList<PickMeSeatItem> allUser = new ArrayList<PickMeSeatItem>(this.pickMeSeatItems.values());
        for (PickMeSeatItem seatItem : allUser) {
            this.updateStatus(seatItem.uid, this.provider.getPlayerByUid(seatItem.uid));
        }
    }

    protected NormalSeatViewWrapper createSeatViewWrapper() {
        NormalSeatViewWrapper seatViewWrapper = new NormalSeatViewWrapper();
        seatViewWrapper.getAdapter().register(PickMeSeatItem.class, (ItemViewBinder)new BaseItemBinder<PickMeSeatItem, PickMeSeatItemHolder>(){

            @NonNull
            protected PickMeSeatItemHolder onCreateViewHolder(@NonNull LayoutInflater inflater, @NonNull ViewGroup parent) {
                PickMeSeatItemHolder holder = new PickMeSeatItemHolder(this.createItemView(inflater, parent, R.layout.voice_room_stage_pickme_item_channel), (IChannelPageContext)PickmeSeatPresenter.this.getMvpContext());
                return holder;
            }

            protected void onBindViewHolder(@NonNull PickMeSeatItemHolder holder, @NonNull PickMeSeatItem item) {
                holder.setSelfPicked(PickmeSeatPresenter.this.selfChooseUid > 0L && item.uid == PickmeSeatPresenter.this.selfChooseUid);
                holder.setHolderCallback(PickmeSeatPresenter.this.mInnerCallbackHolder);
                holder.setData(item);
                holder.setRoomId(PickmeSeatPresenter.this.getRoomId());
                holder.setOnSeatItemListener((SeatMvp.IView.OnSeatItemListener)PickmeSeatPresenter.this);
            }
        });
        return seatViewWrapper;
    }

    protected List<SeatItem> createSeatItems(List<SeatUser> seatList) {
        ArrayList<SeatItem> mSeatList = new ArrayList<SeatItem>();
        for (int i = 0; i < seatList.size(); ++i) {
            SeatUser seatUser = seatList.get(i);
            long key = seatUser.uid > 0L ? seatUser.uid : (long)i;
            PickMeSeatItem seatItem = this.pickMeSeatItems.get(key);
            if (seatItem == null) {
                seatItem = new PickMeSeatItem();
            }
            super.initSeat((SeatItem)seatItem, seatUser);
            this.pickMeSeatItems.put(key, seatItem);
            if (seatUser.uid > 0L) {
                PlayerInfo playerInfo = null;
                if (this.provider != null) {
                    playerInfo = this.provider.getPlayerByUid(seatUser.uid);
                } else {
                    MLog.error((Object)TAG, (String)"provider null", (Object[])new Object[0]);
                }
                if (playerInfo != null) {
                    this.updateStatus(seatUser.uid, playerInfo);
                } else {
                    MLog.error((Object)TAG, (String)"post playerInfo null!!!", (Object[])new Object[0]);
                }
            }
            mSeatList.add(seatItem);
        }
        return mSeatList;
    }

    public void onDestroy() {
        super.onDestroy();
    }
}

