/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.pickme.seat;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.util.Property;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.constraintlayout.widget.ConstraintLayout;
import com.opensource.svgaplayer.hago.SVGADrawable;
import com.opensource.svgaplayer.hago.SVGADynamicEntity;
import com.opensource.svgaplayer.hago.SVGAImageView;
import com.opensource.svgaplayer.hago.SVGAVideoEntity;
import com.yy.appbase.DpToPxDef;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.UserInfoModule;
import com.yy.appbase.service.callback.OnProfileCallback;
import com.yy.appbase.ui.widget.image.CircleImageView;
import com.yy.base.env.RuntimeContext;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.event.kvo.helper.KvoBinder;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYRelativeLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.framework.core.ui.svga.ISvgaLoadCallback;
import com.yy.hiyo.channel.base.bean.CalculatorData;
import com.yy.hiyo.channel.base.bean.HatEffectData;
import com.yy.hiyo.channel.cbase.context.IChannelPageContext;
import com.yy.hiyo.channel.component.seat.bean.SeatItem;
import com.yy.hiyo.channel.component.seat.holder.SeatItemHolder;
import com.yy.hiyo.channel.plugins.pickme.DR;
import com.yy.hiyo.channel.plugins.pickme.R;
import com.yy.hiyo.channel.plugins.pickme.seat.PickMeSeatItem;
import com.yy.hiyo.channel.plugins.pickme.ui.callback.IPickMeHolderCallback;
import com.yy.hiyo.dyres.api.DyResLoader;
import java.util.List;

public class PickMeSeatItemHolder
extends SeatItemHolder<PickMeSeatItem> {
    private static final String TAG = "FTPickMe#SeatHolder";
    private RecycleImageView ivSpeaking;
    private RecycleImageView ivSpeaking1;
    private RecycleImageView ivPickStatus;
    private YYTextView tvAction;
    private YYRelativeLayout rlAction;
    private SVGAImageView svPicked;
    private View baseItemView;
    private CircleImageView ivRound;
    private IPickMeHolderCallback callback;
    private SVGAImageView svResult;
    private boolean isSpeakAnimating = false;
    private boolean isPicked = false;
    private boolean isPickAnimating = false;
    private int dp21 = ResolutionUtils.dip2Px((float)21.0f);
    private int dp20 = ResolutionUtils.dip2Px((float)20.0f);
    private boolean destroyed = false;
    private AnimatorSet setOne;
    private AnimatorSet setTwo;
    private RecycleImageView mPickCapImgView;
    private boolean replacePic = true;
    private ObjectAnimator scaleAnim = null;
    HatEffectData hatEffectData = null;
    IChannelPageContext pageContext = null;
    AnimatorSet animatorSet = new AnimatorSet();
    private HatEffectData.HatState mHatState = HatEffectData.HatState.DEFAULT;
    private int mHatId = 0;
    private Animator.AnimatorListener animatorListener = new Animator.AnimatorListener(){

        public void onAnimationStart(Animator animation) {
            if (PickMeSeatItemHolder.this.destroyed) {
                return;
            }
        }

        public void onAnimationEnd(Animator animation) {
            if (PickMeSeatItemHolder.this.destroyed) {
                return;
            }
            PickMeSeatItemHolder.this.isSpeakAnimating = false;
            PickMeSeatItemHolder.this.ivSpeaking1.setVisibility(4);
            PickMeSeatItem data = (PickMeSeatItem)((Object)PickMeSeatItemHolder.this.getData());
            if (data != null) {
                PickMeSeatItemHolder.this.updateSpeaking(data);
            }
        }

        public void onAnimationCancel(Animator animation) {
            if (PickMeSeatItemHolder.this.destroyed) {
                return;
            }
            PickMeSeatItemHolder.this.isSpeakAnimating = false;
            PickMeSeatItemHolder.this.ivSpeaking1.setVisibility(4);
        }

        public void onAnimationRepeat(Animator animation) {
            if (PickMeSeatItemHolder.this.destroyed) {
                return;
            }
        }
    };
    private final KvoBinder mBinder = new KvoBinder((Object)this);

    public PickMeSeatItemHolder(View itemView, IChannelPageContext pageContext) {
        super(itemView, pageContext);
        this.pageContext = pageContext;
        this.baseItemView = itemView.findViewById(R.id.base_item_root);
        this.ivSpeaking = (RecycleImageView)itemView.findViewById(R.id.iv_pm_speaking);
        this.ivSpeaking1 = (RecycleImageView)itemView.findViewById(R.id.iv_pm_speaking1);
        this.ivPickStatus = (RecycleImageView)itemView.findViewById(R.id.iv_pm_pick_status);
        this.tvAction = (YYTextView)itemView.findViewById(R.id.tv_pm_action);
        this.rlAction = (YYRelativeLayout)itemView.findViewById(R.id.rl_action);
        this.svPicked = (SVGAImageView)itemView.findViewById(R.id.svga_pm_picked);
        this.ivRound = (CircleImageView)itemView.findViewById(R.id.iv_round);
        this.svResult = (SVGAImageView)itemView.findViewById(R.id.sv_result);
        this.mPickCapImgView = (RecycleImageView)itemView.findViewById(R.id.pick_hat);
        this.svResult.setFillMode(SVGAImageView.FillMode.Forward);
        this.svResult.setClearsAfterStop(false);
        this.svResult.setLoopCount(1);
        this.rlAction.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PickMeSeatItem data = (PickMeSeatItem)((Object)PickMeSeatItemHolder.this.getData());
                if (data != null && PickMeSeatItemHolder.this.callback != null) {
                    PickMeSeatItemHolder.this.callback.onPickMeOperationClick(data.getPickMode(), data.uid);
                } else {
                    MLog.error((Object)PickMeSeatItemHolder.TAG, (String)"click event not invoke!!! check data:%s, handler:%s", (Object[])new Object[]{data, PickMeSeatItemHolder.this.callback});
                }
            }
        });
    }

    public void setHolderCallback(IPickMeHolderCallback callback) {
        this.callback = callback;
    }

    public void setData(PickMeSeatItem data) {
        PickMeSeatItem lastData = (PickMeSeatItem)((Object)this.getData());
        boolean isDataChanged = lastData != data;
        super.setData((SeatItem)data);
        this.mSpeakAnimView.setVisibility(4);
        if (isDataChanged) {
            this.mBinder.clearKvoConnection("seat");
            this.mBinder.singleBindSourceTo("seat", (KvoSource)data);
        } else {
            this.onPickModeChange(null);
        }
        this.updateSpeaking(data);
        if (this.pageContext != null && this.pageContext.getChannel().getCalculatorService().isHatOpen()) {
            if (data != null) {
                this.setPickData(data.mCalculatorData);
            }
        } else {
            this.mPickCapImgView.setVisibility(8);
        }
    }

    public void onViewDetach() {
        super.onViewDetach();
        this.mBinder.clearKvoConnection("seat");
    }

    public void startSpeakAnim() {
        if (this.getData() != null) {
            ((PickMeSeatItem)((Object)this.getData())).isSpeaking = true;
            this.updateSpeaking((PickMeSeatItem)((Object)this.getData()));
        }
    }

    public void stopSpeakAnim() {
        if (this.getData() != null) {
            ((PickMeSeatItem)((Object)this.getData())).isSpeaking = false;
            this.updateSpeaking((PickMeSeatItem)((Object)this.getData()));
        }
    }

    private void updateSpeaking(final PickMeSeatItem data) {
        if (this.destroyed) {
            return;
        }
        if (this.isSpeakAnimating) {
            if (data.userInfo == null || data.userInfo.uid <= 0L) {
                this.isSpeakAnimating = false;
                this.ivSpeaking.setVisibility(4);
                this.ivSpeaking1.setVisibility(4);
            }
            return;
        }
        if (data.isSpeaking && data.userInfo != null && data.userInfo.uid > 0L) {
            if (this.setOne != null) {
                this.setOne.removeAllListeners();
                this.setOne.cancel();
            }
            if (this.setTwo != null) {
                this.setTwo.removeAllListeners();
                this.setTwo.cancel();
            }
            this.isSpeakAnimating = true;
            this.ivSpeaking.setVisibility(0);
            Drawable drawable2 = ResourceUtils.getDrawable((int)(data.userInfo.sex == 0 ? R.drawable.bg_pickme_speak_red : R.drawable.bg_pickme_speak_blue));
            this.ivSpeaking.setImageDrawable(drawable2);
            this.ivSpeaking1.setImageDrawable(drawable2);
            ObjectAnimator x = ObjectAnimator.ofFloat((Object)this.ivSpeaking, (Property)View.SCALE_X, (float[])new float[]{1.0f, 1.6f});
            ObjectAnimator y = ObjectAnimator.ofFloat((Object)this.ivSpeaking, (Property)View.SCALE_Y, (float[])new float[]{1.0f, 1.6f});
            ObjectAnimator alpha = ObjectAnimator.ofFloat((Object)this.ivSpeaking, (Property)View.ALPHA, (float[])new float[]{1.0f, 0.7f});
            AnimatorSet set = new AnimatorSet();
            set.setDuration(800L);
            set.playTogether(new Animator[]{x, y, alpha});
            set.removeAllListeners();
            set.start();
            this.setOne = set;
            ObjectAnimator x1 = ObjectAnimator.ofFloat((Object)this.ivSpeaking1, (Property)View.SCALE_X, (float[])new float[]{1.0f, 1.6f});
            ObjectAnimator y1 = ObjectAnimator.ofFloat((Object)this.ivSpeaking1, (Property)View.SCALE_Y, (float[])new float[]{1.0f, 1.6f});
            ObjectAnimator alpha1 = ObjectAnimator.ofFloat((Object)this.ivSpeaking1, (Property)View.ALPHA, (float[])new float[]{1.0f, 0.7f});
            AnimatorSet set1 = new AnimatorSet();
            set1.setDuration(800L);
            set1.playTogether(new Animator[]{x1, y1, alpha1});
            set1.removeAllListeners();
            set1.addListener(this.animatorListener);
            set1.setStartDelay(300L);
            set1.start();
            this.setTwo = set1;
            this.ivSpeaking1.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (PickMeSeatItemHolder.this.isSpeakAnimating && data.userInfo.uid > 0L) {
                        PickMeSeatItemHolder.this.ivSpeaking1.setVisibility(0);
                    }
                }
            }, 300L);
            MLog.info((Object)"animator", (String)"updateSpeaking", (Object[])new Object[0]);
        } else {
            this.ivSpeaking.setVisibility(4);
            this.ivSpeaking1.setVisibility(4);
        }
        this.updateRound();
    }

    private void updateRound() {
        PickMeSeatItem data = (PickMeSeatItem)((Object)this.getData());
        if (data.isSpeaking && data.userInfo != null && data.userInfo.uid > 0L) {
            this.ivRound.setVisibility(0);
            this.ivRound.setImageDrawable(ResourceUtils.getDrawable((int)(data.userInfo.sex == 0 ? R.color.color_FF4684 : R.color.color_2EEAFF)));
        } else {
            this.ivRound.setVisibility(8);
        }
    }

    @KvoMethodAnnotation(sourceClass=PickMeSeatItem.class, name="pickMode")
    public void onPickModeChange(KvoEventIntent event) {
        PickMeSeatItem item = (PickMeSeatItem)((Object)this.getData());
        if (item == null) {
            return;
        }
        int mode = item.getPickMode();
        if (PickMeSeatItem.isSameMainMode(mode, 8) && item.uid > 0L) {
            MLog.info((Object)TAG, (String)"onPickModeChange UNPICK_IN_SEAT index:%d, uid:%d, mode:%d", (Object[])new Object[]{item.index, item.uid, mode});
            this.updatePickIcon(item);
            this.tvAction.setVisibility(0);
            this.rlAction.setVisibility(0);
            this.tvAction.setText((CharSequence)ResourceUtils.getString((int)R.string.btn_picme_pick));
            this.rlAction.setBackgroundDrawable(ResourceUtils.getDrawable((int)R.drawable.icon_pickme_pick));
            this.tvAction.setTextColor(ResourceUtils.getColor((int)R.color.white));
            this.mSeatIndexView.setVisibility(4);
            this.mNickName.setVisibility(4);
            this.isPicked = false;
            this.isPickAnimating = false;
            this.svResult.stopAnimation();
            this.svResult.setVisibility(8);
            this.updatePickAnimation();
        } else if (PickMeSeatItem.isSameMainMode(mode, 16) && item.uid > 0L) {
            MLog.info((Object)TAG, (String)"onPickModeChange PICKED_IN_SEAT index:%d, uid:%d, mode:%d", (Object[])new Object[]{item.index, item.uid, mode});
            this.updatePickIcon(item);
            this.tvAction.setVisibility(0);
            this.rlAction.setVisibility(0);
            this.rlAction.setBackgroundDrawable(ResourceUtils.getDrawable((int)R.drawable.bg_pickme_cancel));
            this.tvAction.setTextColor(ResourceUtils.getColor((int)R.color.color_DF0ED8));
            this.tvAction.setText((CharSequence)ResourceUtils.getString((int)R.string.str_button_cancel));
            this.mSeatIndexView.setVisibility(4);
            this.mNickName.setVisibility(4);
            this.svResult.stopAnimation();
            this.svResult.setVisibility(8);
            this.isPicked = true;
            this.updatePickAnimation();
        } else if (PickMeSeatItem.isSameMainMode(mode, 32) && item.uid > 0L) {
            MLog.info((Object)TAG, (String)"onPickModeChange WAIT_OWNER_PUBLISH index:%d, uid:%d, mode:%d", (Object[])new Object[]{item.index, item.uid, mode});
            this.ivPickStatus.setVisibility(0);
            this.ivPickStatus.setImageDrawable(ResourceUtils.getDrawable((int)R.drawable.icon_pickme_unpublish));
            this.ivPickStatus.getLayoutParams().width = this.dp21;
            this.ivPickStatus.getLayoutParams().height = this.dp21;
            this.rlAction.setVisibility(4);
            this.tvAction.setVisibility(4);
            this.mSeatIndexView.setVisibility(0);
            this.mNickName.setVisibility(0);
            this.svResult.stopAnimation();
            this.svResult.setVisibility(8);
            this.updatePickAnimation();
        } else if (PickMeSeatItem.isSameMainMode(mode, 64) && item.uid > 0L) {
            MLog.info((Object)TAG, (String)"onPickModeChange WAIT_SELF_PUBLISH index:%d, uid:%d, mode:%d", (Object[])new Object[]{item.index, item.uid, mode});
            this.ivPickStatus.setVisibility(0);
            this.ivPickStatus.setImageDrawable(ResourceUtils.getDrawable((int)R.drawable.icon_pickme_unpublish));
            this.ivPickStatus.getLayoutParams().width = this.dp21;
            this.ivPickStatus.getLayoutParams().height = this.dp21;
            this.rlAction.setVisibility(0);
            this.tvAction.setVisibility(0);
            this.tvAction.setText((CharSequence)ResourceUtils.getString((int)R.string.btn_picme_publish));
            this.rlAction.setBackgroundDrawable(ResourceUtils.getDrawable((int)R.drawable.icon_pickme_pick));
            this.tvAction.setTextColor(ResourceUtils.getColor((int)R.color.white));
            this.mSeatIndexView.setVisibility(4);
            this.mNickName.setVisibility(4);
            this.svResult.stopAnimation();
            this.svResult.setVisibility(8);
            this.updatePickAnimation();
        } else if (PickMeSeatItem.isSameMainMode(mode, 128) && item.uid > 0L) {
            MLog.info((Object)TAG, (String)"onPickModeChange PUBLISHED index:%d, uid:%d, mode:%d", (Object[])new Object[]{item.index, item.uid, mode});
            final UserInfoKS userPicked = item.getPickedPerson();
            if (userPicked == null) {
                this.ivPickStatus.setVisibility(8);
                this.ivPickStatus.setImageDrawable(null);
                this.svResult.stopAnimation();
                this.svResult.setVisibility(8);
            } else if (this.callback != null && this.callback.hasShowResult(((PickMeSeatItem)((Object)this.getData())).uid)) {
                int defaultDrawable;
                this.ivPickStatus.setVisibility(0);
                this.ivPickStatus.setImageDrawable(null);
                this.svResult.stopAnimation();
                this.svResult.setVisibility(4);
                final long uid = userPicked.uid;
                int n = defaultDrawable = userPicked.sex == 0 ? R.drawable.icon_avatar_default_female : R.drawable.icon_avatar_default_male;
                if (StringUtils.isNotEmpty((String)userPicked.avatar)) {
                    ImageLoader.loadImage((ImageView)this.ivPickStatus, (String)userPicked.avatar, (int)defaultDrawable);
                } else {
                    this.ivPickStatus.setImageDrawable(ResourceUtils.getDrawable((int)defaultDrawable));
                    ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getUserInfo(userPicked.uid, new OnProfileCallback(){

                        public void onSuccess(int id2, List<UserInfoKS> userInfoKSList) {
                            PickMeSeatItem currentItem = (PickMeSeatItem)((Object)PickMeSeatItemHolder.this.getData());
                            if (PickMeSeatItem.isSameMainMode(currentItem.getPickMode(), 128) && currentItem.getPickedPerson() != null && currentItem.getPickedPerson().uid == uid) {
                                ImageLoader.loadImage((ImageView)PickMeSeatItemHolder.this.ivPickStatus, (String)userPicked.avatar, (int)defaultDrawable);
                            }
                        }

                        public void onFail(int id2, String msg, String response) {
                        }

                        public int id() {
                            return 0;
                        }
                    });
                }
            } else {
                this.ivPickStatus.setVisibility(8);
                this.ivPickStatus.setImageDrawable(null);
                this.svResult.stopAnimation();
                this.svResult.setVisibility(0);
                final long uid = userPicked.uid;
                DyResLoader.INSTANCE.loadSvga(this.svResult, DR.pickme_result, new ISvgaLoadCallback(){

                    public void onFinished(final SVGAVideoEntity entity) {
                        final Runnable runnable = new Runnable(){

                            @Override
                            public void run() {
                                ImageLoader.loadBitmap((Context)PickMeSeatItemHolder.this.ivPickStatus.getContext(), (String)(userPicked.avatar + YYImageUtils.getThumbSmall()), (ImageLoader.BitmapLoadListener)new ImageLoader.BitmapLoadListener(){

                                    public void onLoadFailed(Exception e) {
                                        MLog.error((Object)PickMeSeatItemHolder.TAG, (String)"onLoadFailed", (Object[])new Object[0]);
                                    }

                                    public void onResourceReady(Bitmap bitmap) {
                                        if (PickMeSeatItemHolder.this.checkSvga(entity, uid)) {
                                            SVGADynamicEntity dynamicEntity = new SVGADynamicEntity();
                                            dynamicEntity.setDynamicImage(bitmap, "chosen");
                                            int index = -1;
                                            if (PickMeSeatItemHolder.this.callback != null) {
                                                index = PickMeSeatItemHolder.this.callback.getUidIndex(userPicked.uid);
                                            }
                                            if (index > 0) {
                                                int res = 0;
                                                res = index == 1 ? R.drawable.icon_pickme_1 : (index == 2 ? R.drawable.icon_pickme_2 : (index == 3 ? R.drawable.icon_pickme_3 : (index == 4 ? R.drawable.icon_pickme_4 : (index == 5 ? R.drawable.icon_pickme_5 : (index == 6 ? R.drawable.icon_pickme_6 : (index == 7 ? R.drawable.icon_pickme_7 : R.drawable.icon_pickme_8))))));
                                                Bitmap bitmap1 = YYImageUtils.decodeResource((Context)PickMeSeatItemHolder.this.svResult.getContext(), (int)res);
                                                if (bitmap1 != null) {
                                                    dynamicEntity.setDynamicImage(bitmap1, "number");
                                                }
                                            }
                                            SVGADrawable drawable2 = new SVGADrawable(entity, dynamicEntity);
                                            PickMeSeatItemHolder.this.svResult.setImageDrawable((Drawable)drawable2);
                                            PickMeSeatItemHolder.this.svResult.startAnimation();
                                            if (PickMeSeatItemHolder.this.callback != null) {
                                                PickMeSeatItemHolder.this.callback.setHasShowResult(((PickMeSeatItem)((Object)PickMeSeatItemHolder.this.getData())).uid);
                                            }
                                        }
                                    }
                                });
                            }
                        };
                        if (StringUtils.isNotEmpty((String)userPicked.avatar)) {
                            runnable.run();
                        } else {
                            ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getUserInfo(userPicked.uid, new OnProfileCallback(){

                                public void onSuccess(int id2, List<UserInfoKS> userInfoKSList) {
                                    runnable.run();
                                }

                                public void onFail(int id2, String msg, String response) {
                                }

                                public int id() {
                                    return 0;
                                }
                            });
                        }
                    }

                    public void onFailed(Exception e) {
                        MLog.error((Object)PickMeSeatItemHolder.TAG, (String)("loadSvga err:" + e), (Object[])new Object[0]);
                    }
                });
            }
            this.tvAction.setVisibility(4);
            this.rlAction.setVisibility(4);
            this.mSeatIndexView.setVisibility(0);
            this.mNickName.setVisibility(0);
            this.updatePickAnimation();
        } else if (PickMeSeatItem.isSameMainMode(mode, 1) || item.uid == 0L) {
            if (RuntimeContext.isInGray()) {
                MLog.info((Object)TAG, (String)"onPickModeChange NOT_VALID index:%d, uid:%d, mode:%d", (Object[])new Object[]{item.index, item.uid, mode});
            }
            this.updatePickIcon(item);
            this.tvAction.setVisibility(8);
            this.rlAction.setVisibility(8);
            this.mSeatIndexView.setVisibility(0);
            this.isPicked = false;
            this.mNickName.setVisibility(((PickMeSeatItem)((Object)this.getData())).hasUser() ? 0 : 8);
            this.updatePickAnimation();
            this.svResult.stopAnimation();
            this.svResult.setVisibility(8);
        }
        this.updateRound();
    }

    private boolean checkSvga(SVGAVideoEntity entity, long uid) {
        return this.svResult != null && entity != null && this.getData() != null && PickMeSeatItem.isSameMainMode(((PickMeSeatItem)((Object)this.getData())).getPickMode(), 128) && ((PickMeSeatItem)((Object)this.getData())).getPickedPerson() != null && ((PickMeSeatItem)((Object)this.getData())).getPickedPerson().uid == uid;
    }

    protected void updateReadyIcon() {
        this.mReadyIcon.setVisibility(8);
    }

    private void updatePickAnimation() {
        long uid = ((PickMeSeatItem)((Object)this.getData())).uid;
        if (uid <= 0L) {
            this.isPicked = false;
        }
        if (!this.isPicked) {
            this.svPicked.setVisibility(4);
            this.svPicked.stopAnimation();
            this.isPickAnimating = false;
        } else {
            if (!this.isPickAnimating) {
                this.isPickAnimating = true;
                DyResLoader.INSTANCE.loadSvga(this.svPicked, DR.pickme_picked, new ISvgaLoadCallback(){

                    public void onFinished(SVGAVideoEntity svgaVideoEntity) {
                        if (PickMeSeatItemHolder.this.svPicked != null && PickMeSeatItemHolder.this.isPicked) {
                            PickMeSeatItemHolder.this.svPicked.startAnimation();
                        } else {
                            PickMeSeatItemHolder.this.isPickAnimating = false;
                        }
                    }

                    public void onFailed(Exception e) {
                        MLog.error((Object)PickMeSeatItemHolder.TAG, (String)"load picked svga fail:%s", (Throwable)e, (Object[])new Object[0]);
                        PickMeSeatItemHolder.this.isPickAnimating = false;
                    }
                });
            }
            this.svPicked.setVisibility(0);
        }
    }

    private void updatePickIcon(PickMeSeatItem item) {
        boolean hasPick = PickMeSeatItem.isSameMainMode(item.getPickMode(), 4);
        if (hasPick) {
            this.ivPickStatus.setVisibility(0);
            this.ivPickStatus.setImageDrawable(ResourceUtils.getDrawable((int)R.drawable.icon_pickme_picked));
            this.ivPickStatus.getLayoutParams().height = this.dp20;
            this.ivPickStatus.getLayoutParams().width = this.dp20;
        } else {
            this.ivPickStatus.setImageDrawable(null);
            this.ivPickStatus.setVisibility(4);
        }
    }

    private void startGetCapAnim(HatEffectData data) {
        this.hatEffectData = data;
        if (this.mPickCapImgView == null) {
            return;
        }
        ConstraintLayout.LayoutParams layoutParams = (ConstraintLayout.LayoutParams)this.mPickCapImgView.getLayoutParams();
        layoutParams.rightMargin = 0;
        layoutParams.bottomMargin = 0;
        this.mPickCapImgView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.mPickCapImgView.setTranslationX(0.0f);
        this.mPickCapImgView.setTranslationY(0.0f);
        this.scaleAnim = ObjectAnimator.ofPropertyValuesHolder((Object)this.mPickCapImgView, (PropertyValuesHolder[])new PropertyValuesHolder[]{PropertyValuesHolder.ofFloat((Property)View.SCALE_X, (float[])new float[]{0.0f, 1.0f}), PropertyValuesHolder.ofFloat((Property)View.SCALE_Y, (float[])new float[]{0.0f, 1.0f}), PropertyValuesHolder.ofFloat((Property)View.TRANSLATION_Y, (float[])new float[]{0.0f, -DpToPxDef.RESOLUTION_50_DP})});
        ObjectAnimator scaleAfterTrans = ObjectAnimator.ofPropertyValuesHolder((Object)this.mPickCapImgView, (PropertyValuesHolder[])new PropertyValuesHolder[]{PropertyValuesHolder.ofFloat((Property)View.SCALE_X, (float[])new float[]{1.0f, 0.8f}), PropertyValuesHolder.ofFloat((Property)View.SCALE_Y, (float[])new float[]{1.0f, 0.8f})});
        ObjectAnimator scaleWithTrans = ObjectAnimator.ofPropertyValuesHolder((Object)this.mPickCapImgView, (PropertyValuesHolder[])new PropertyValuesHolder[]{PropertyValuesHolder.ofFloat((Property)View.SCALE_X, (float[])new float[]{0.8f, 1.0f}), PropertyValuesHolder.ofFloat((Property)View.SCALE_Y, (float[])new float[]{0.8f, 1.0f})});
        ObjectAnimator enterAnim = ObjectAnimator.ofPropertyValuesHolder((Object)this.mPickCapImgView, (PropertyValuesHolder[])new PropertyValuesHolder[]{PropertyValuesHolder.ofFloat((Property)View.TRANSLATION_X, (float[])new float[]{0.0f, -DpToPxDef.RESOLUTION_13_DP}), PropertyValuesHolder.ofFloat((Property)View.TRANSLATION_Y, (float[])new float[]{-DpToPxDef.RESOLUTION_65_DP})});
        this.scaleAnim.setDuration(500L);
        enterAnim.setDuration(500L);
        scaleAfterTrans.setDuration(500L);
        scaleWithTrans.setDuration(1000L);
        if (this.animatorSet != null) {
            this.animatorSet.play((Animator)enterAnim).after((Animator)this.scaleAnim).with((Animator)scaleAfterTrans).before((Animator)scaleWithTrans);
            this.animatorSet.start();
        }
        this.loadImg();
        this.mPickCapImgView.setVisibility(0);
    }

    private void loadImg() {
        String url = "";
        if (this.hatEffectData != null && this.mCalculatorView != null) {
            MLog.info((Object)TAG, (String)"loadImg : %s", (Object[])new Object[]{this.hatEffectData.getEffectId()});
            url = this.mCalculatorView.getHatUrl(this.hatEffectData.getEffectId());
        }
        ImageLoader.loadImage((ImageView)this.mPickCapImgView, (String)(url + YYImageUtils.getThumbnailPostfix((int)DpToPxDef.RESOLUTION_40_DP)), (int)0);
    }

    public void setPickData(CalculatorData data) {
        if (this.mPickCapImgView == null) {
            return;
        }
        if (data == null || data.getMHatData() == null) {
            this.mPickCapImgView.setVisibility(8);
            this.mHatState = HatEffectData.HatState.DEFAULT;
            this.mHatId = 0;
            return;
        }
        if (this.mHatState == data.getMHatData().getMHatState() && this.mHatId == data.getMHatData().getEffectId()) {
            return;
        }
        this.mHatState = data.getMHatData().getMHatState();
        this.mHatId = data.getMHatData().getEffectId();
        if (data.isHasHat()) {
            if (data.getMHatData().getMHatState() == HatEffectData.HatState.OBTAIN_HAT) {
                this.startGetCapAnim(data.getMHatData());
            }
            if (data.getMHatData().getMHatState() == HatEffectData.HatState.UPGRADE_HAT) {
                this.startUpGradCapAnim(data.getMHatData());
            }
            if (data.getMHatData().getMHatState() == HatEffectData.HatState.SHOW_HAT) {
                if (this.animatorSet != null && this.animatorSet.isStarted()) {
                    this.animatorSet.end();
                }
                this.mPickCapImgView.setTranslationX(0.0f);
                this.mPickCapImgView.setTranslationY(0.0f);
                ConstraintLayout.LayoutParams layoutParams = (ConstraintLayout.LayoutParams)this.mPickCapImgView.getLayoutParams();
                layoutParams.rightMargin = DpToPxDef.RESOLUTION_19_DP;
                layoutParams.bottomMargin = DpToPxDef.RESOLUTION_65_DP;
                this.mPickCapImgView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                this.hatEffectData = data.getMHatData();
                this.loadImg();
                this.mPickCapImgView.setVisibility(0);
            }
        }
    }

    private void startUpGradCapAnim(HatEffectData data) {
        this.hatEffectData = data;
        this.replacePic = true;
        this.scaleAnim = this.getScaleAnim();
        this.scaleAnim.addUpdateListener(animation -> {
            float frac = animation.getAnimatedFraction();
            if (this.replacePic && (double)frac > 0.5) {
                this.replacePic = false;
                this.loadImg();
            }
        });
        this.scaleAnim.setDuration(800L);
        this.scaleAnim.start();
        this.mPickCapImgView.setVisibility(0);
    }

    private ObjectAnimator getScaleAnim() {
        return ObjectAnimator.ofPropertyValuesHolder((Object)this.mPickCapImgView, (PropertyValuesHolder[])new PropertyValuesHolder[]{PropertyValuesHolder.ofFloat((Property)View.SCALE_X, (float[])new float[]{1.0f, 0.2f, 1.0f}), PropertyValuesHolder.ofFloat((Property)View.SCALE_Y, (float[])new float[]{1.0f, 0.2f, 1.0f}), PropertyValuesHolder.ofFloat((Property)View.ALPHA, (float[])new float[]{1.0f, 0.2f, 1.0f})});
    }

    protected View getBaseItemView() {
        return this.baseItemView;
    }

    public void setSelfPicked(boolean b) {
        this.isPicked = b;
    }

    public void destroy() {
        this.destroyed = true;
        super.destroy();
        if (this.setOne != null) {
            this.setOne.removeAllListeners();
            if (this.setOne.isStarted()) {
                this.setOne.end();
            }
            this.setOne = null;
        }
        if (this.setTwo != null) {
            this.setTwo.removeAllListeners();
            if (this.setTwo.isStarted()) {
                this.setTwo.end();
            }
            this.setTwo = null;
        }
        if (this.scaleAnim != null) {
            this.scaleAnim.removeAllListeners();
            if (this.scaleAnim.isStarted()) {
                this.scaleAnim.end();
            }
            this.scaleAnim = null;
        }
        if (this.animatorSet != null) {
            this.animatorSet.removeAllListeners();
            if (this.animatorSet.isStarted()) {
                this.animatorSet.end();
            }
            this.animatorSet = null;
        }
        if (this.svPicked != null && this.svPicked.isAnimating()) {
            this.svPicked.stopAnimation();
        }
        this.mBinder.clearKvoConnection("seat");
    }
}

