/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.pickme.business.manager;

import androidx.annotation.Nullable;
import androidx.collection.LongSparseArray;
import androidx.core.util.Pair;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.logger.MLog;
import com.yy.hiyo.channel.base.bean.SeatData;
import com.yy.hiyo.channel.base.bean.SeatUser;
import com.yy.hiyo.channel.base.service.ISeatService;
import com.yy.hiyo.channel.base.service.ISeatUpdateListener;
import com.yy.hiyo.channel.plugins.pickme.base.PickMeContext;
import com.yy.hiyo.channel.plugins.pickme.bean.MatchSuccessInfo;
import com.yy.hiyo.channel.plugins.pickme.bean.MatchSuccessNotify;
import com.yy.hiyo.channel.plugins.pickme.bean.PlayerInfo;
import com.yy.hiyo.channel.plugins.pickme.bean.PlayerUpdateData;
import com.yy.hiyo.channel.plugins.pickme.bean.PublishResultInfo;
import com.yy.hiyo.channel.plugins.pickme.business.manager.BaseManager;
import com.yy.hiyo.channel.plugins.pickme.business.manager.IPlayerManager;
import com.yy.hiyo.channel.plugins.pickme.common.MatchEffectLevel;
import com.yy.hiyo.channel.plugins.pickme.common.PickMeEvent;
import com.yy.hiyo.channel.plugins.pickme.model.base.IProtoNotifyHandler;
import com.yy.hiyo.channel.plugins.pickme.model.base.IProtoService;
import com.yy.hiyo.channel.plugins.pickme.model.base.IResCallback;
import com.yy.hiyo.channel.plugins.pickme.model.base.IResDataCallback;
import com.yy.hiyo.channel.plugins.pickme.model.base.SimpleProtoNotifyHandler;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PlayerManager
extends BaseManager
implements IPlayerManager,
ISeatUpdateListener {
    private static final String TAG = "FTPickMe#PlayerManager";
    private final LongSparseArray<PlayerInfo> mPlayerInfoMap = new LongSparseArray();
    private final MutableLiveData<PlayerUpdateData> mPlayerUpdateData = new MutableLiveData();
    private final MutableLiveData<Boolean> mCanStartPublish = new MutableLiveData();
    private final MutableLiveData<MatchSuccessNotify> mMatchSuccessNotify = new MutableLiveData();
    private final MutableLiveData<Boolean> mSelectPeopleRequesting = new MutableLiveData();
    private IProtoNotifyHandler mNotifyHandler = new SimpleProtoNotifyHandler(){

        @Override
        public void onSelectStatusNotify(List<PlayerInfo> playerInfoList) {
            if (!MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)PlayerManager.TAG, (String)("onSelectStatusNotify, " + playerInfoList), (Object[])new Object[0]);
            }
            for (PlayerInfo playerInfo : playerInfoList) {
                PlayerManager.this.playerChoiceChanged(playerInfo);
            }
        }

        @Override
        public void onPublishResultNotify(PublishResultInfo result2) {
            if (!MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)PlayerManager.TAG, (String)("onPublishResultNotify, " + result2), (Object[])new Object[0]);
            }
            for (PlayerInfo playerInfo : result2.getPublishPlayers()) {
                PlayerManager.this.playerPublish(playerInfo);
            }
            ISeatService seatService = null;
            if (PlayerManager.this.mContext != null && PlayerManager.this.mContext.getRoomData() != null) {
                seatService = PlayerManager.this.mContext.getRoomPageContext().getChannel().getSeatService();
            }
            LongSparseArray matchSuccessMap = new LongSparseArray(result2.getMatchSuccessPlayers().size());
            for (PlayerInfo playerInfo : result2.getMatchSuccessPlayers()) {
                long leftUid = playerInfo.getUid();
                long rightUid = playerInfo.getChoosedUid();
                if (matchSuccessMap.get(leftUid) != null || matchSuccessMap.get(rightUid) != null) continue;
                MatchSuccessInfo matchSuccessInfo = new MatchSuccessInfo();
                matchSuccessInfo.setLeftUid(playerInfo.getUid());
                int leftIndex = seatService != null ? seatService.getSeatIndex(playerInfo.getUid()) : 0;
                matchSuccessInfo.setLeftIndex(leftIndex);
                matchSuccessInfo.setRightUid(playerInfo.getChoosedUid());
                int rightIndex = seatService != null ? seatService.getSeatIndex(playerInfo.getChoosedUid()) : 0;
                matchSuccessInfo.setRightIndex(rightIndex);
                matchSuccessInfo.setRandomNumber(result2.getRandomNumber());
                matchSuccessMap.put(matchSuccessInfo.getLeftUid(), (Object)matchSuccessInfo);
                matchSuccessMap.put(matchSuccessInfo.getRightUid(), (Object)matchSuccessInfo);
                MatchSuccessNotify matchSuccessNotify = new MatchSuccessNotify();
                matchSuccessNotify.setMatchSuccessInfo(matchSuccessInfo);
                matchSuccessNotify.setNotifyTime(System.currentTimeMillis());
                PlayerManager.this.mMatchSuccessNotify.postValue((Object)matchSuccessNotify);
            }
            if (result2.isCanNextRound()) {
                PlayerManager.this.sendEvent(PickMeEvent.ON_CAN_NEW_ROUND);
            }
        }
    };

    public PlayerManager(@NotNull PickMeContext context, @NotNull IProtoService protoService) {
        super(context, protoService);
    }

    @Override
    public void initPlayerData(List<PlayerInfo> playerInfoList) {
        this.mPlayerInfoMap.clear();
        if (playerInfoList == null) {
            return;
        }
        for (PlayerInfo playerInfo : playerInfoList) {
            this.mPlayerInfoMap.put(playerInfo.getUid(), (Object)playerInfo);
        }
    }

    @Override
    public void resetAllPlayerStatus() {
        for (int i = 0; i < this.mPlayerInfoMap.size(); ++i) {
            PlayerInfo playerInfo = (PlayerInfo)this.mPlayerInfoMap.valueAt(i);
            playerInfo.setChoosedUid(0L);
            playerInfo.setStatus(0);
            this.playerInfoUpdate(playerInfo);
        }
    }

    @Override
    public void selfLikePeople(long uid) {
        MLog.info((Object)TAG, (String)("selfLikePeople, uid=" + uid), (Object[])new Object[0]);
        this.selectPeopleReal(uid, true);
    }

    @Override
    public void selfUnlikePeople(long uid) {
        MLog.info((Object)TAG, (String)("selfUnlikePeople, uid=" + uid), (Object[])new Object[0]);
        this.selectPeopleReal(uid, false);
    }

    @Override
    public void publishPlayerChoice(final long uid) {
        MLog.info((Object)TAG, (String)"publishPlayerChoice, uid=%d", (Object[])new Object[]{uid});
        this.mProtoService.publishPlayerChoice(uid, new IResCallback(){

            @Override
            public void onSuccess() {
                MLog.info((Object)PlayerManager.TAG, (String)"publishPlayerChoice success, uid=%d", (Object[])new Object[]{uid});
            }

            @Override
            public void onFailure(long code, String msg) {
                MLog.error((Object)PlayerManager.TAG, (String)"publishPlayerChoice failed, uid=%d, code=%d, msg=%s", (Object[])new Object[]{uid, code, msg});
            }
        });
    }

    private void selectPeopleReal(final long uid, final boolean isSelect) {
        MLog.info((Object)TAG, (String)"selectPeopleReal, uid=%d, isSelect=%b", (Object[])new Object[]{uid, isSelect});
        if (this.mSelectPeopleRequesting.getValue() != null && ((Boolean)this.mSelectPeopleRequesting.getValue()).booleanValue()) {
            MLog.error((Object)TAG, (String)"selectPeopleReal, but select people requesting", (Object[])new Object[0]);
            return;
        }
        this.mSelectPeopleRequesting.setValue((Object)true);
        this.mProtoService.selectFriend(uid, isSelect, new IResCallback(){

            @Override
            public void onSuccess() {
                MLog.info((Object)PlayerManager.TAG, (String)"selectFriend success, uid=%d, isSelect=%b", (Object[])new Object[]{uid, isSelect});
                PlayerManager.this.mSelectPeopleRequesting.setValue((Object)false);
            }

            @Override
            public void onFailure(long code, String msg) {
                MLog.error((Object)PlayerManager.TAG, (String)"selectFriend failed, uid=%d, isSelect=%b, code=%d, msg=%s", (Object[])new Object[]{uid, isSelect, code, msg});
                PlayerManager.this.mSelectPeopleRequesting.setValue((Object)false);
            }
        });
    }

    @Override
    public LiveData<PlayerUpdateData> getPlayerUpdateData() {
        return this.mPlayerUpdateData;
    }

    @Override
    @Nullable
    public PlayerInfo getPlayerByUid(long uid) {
        return (PlayerInfo)this.mPlayerInfoMap.get(uid);
    }

    @Override
    public List<PlayerInfo> getCurrentAllPlayers() {
        ArrayList<PlayerInfo> playerInfoList = new ArrayList<PlayerInfo>(this.mPlayerInfoMap.size());
        for (int i = 0; i < this.mPlayerInfoMap.size(); ++i) {
            playerInfoList.add((PlayerInfo)this.mPlayerInfoMap.valueAt(i));
        }
        return playerInfoList;
    }

    @Override
    public LiveData<Boolean> getCanStartPublish() {
        return this.mCanStartPublish;
    }

    @Override
    public LiveData<MatchSuccessNotify> getMatchSuccessNotify() {
        return this.mMatchSuccessNotify;
    }

    @Override
    public void getCharmInfo(long maleUid, long femaleUid, IResDataCallback<Pair<Long, MatchEffectLevel>> callback) {
        this.mProtoService.getCharmInfo(maleUid, femaleUid, callback);
    }

    @KvoMethodAnnotation(sourceClass=SeatData.class, name="isSeatChanged", thread=1)
    public void onSeatDataChanged(KvoEventIntent event) {
        SeatData seatData = (SeatData)event.source();
        List seatUidsList = seatData.getSeatUidsList();
        HashSet<Long> currPlayerUidSet = new HashSet<Long>(this.mPlayerInfoMap.size());
        for (int i = 0; i < this.mPlayerInfoMap.size(); ++i) {
            currPlayerUidSet.add(this.mPlayerInfoMap.keyAt(i));
        }
        for (Long uid : seatUidsList) {
            if (uid <= 0L || currPlayerUidSet.contains(uid)) continue;
            this.playerJoin(uid);
        }
        for (Long uid : currPlayerUidSet) {
            if (seatUidsList.contains(uid)) continue;
            this.playerLeave(uid);
        }
    }

    public void onSeatUpdate(List<SeatUser> seatUserList) {
        List seatUidsList = this.mContext.getRoomPageContext().getChannel().getSeatService().getSeatUidsList();
        HashSet<Long> currPlayerUidSet = new HashSet<Long>(this.mPlayerInfoMap.size());
        for (int i = 0; i < this.mPlayerInfoMap.size(); ++i) {
            currPlayerUidSet.add(this.mPlayerInfoMap.keyAt(i));
        }
        for (Long uid : seatUidsList) {
            if (uid <= 0L || currPlayerUidSet.contains(uid)) continue;
            this.playerJoin(uid);
        }
        for (Long uid : currPlayerUidSet) {
            if (seatUidsList.contains(uid)) continue;
            this.playerLeave(uid);
        }
    }

    private void notifyPlayerDataUpdate(int type, long uid) {
        this.mPlayerUpdateData.setValue((Object)new PlayerUpdateData(type, uid));
        this.updateCanStartPublish();
    }

    private void playerPublish(PlayerInfo playerInfo) {
        this.playerInfoUpdate(playerInfo);
    }

    private void playerChoiceChanged(PlayerInfo playerInfo) {
        this.playerInfoUpdate(playerInfo);
    }

    private void playerJoin(long uid) {
        MLog.info((Object)TAG, (String)("player join, uid=" + uid), (Object[])new Object[0]);
        if (this.mPlayerInfoMap.get(uid) != null) {
            this.mPlayerInfoMap.remove(uid);
        }
        PlayerInfo playerInfo = new PlayerInfo();
        playerInfo.setUid(uid);
        playerInfo.setStatus(0);
        this.mPlayerInfoMap.put(uid, (Object)playerInfo);
        this.notifyPlayerDataUpdate(0, uid);
    }

    private void playerLeave(long uid) {
        MLog.info((Object)TAG, (String)("player leave, uid=" + uid), (Object[])new Object[0]);
        this.mPlayerInfoMap.remove(uid);
        this.notifyPlayerDataUpdate(1, uid);
    }

    private void playerInfoUpdate(PlayerInfo player) {
        if (player == null) {
            MLog.error((Object)TAG, (String)"player info update, but player is null", (Object[])new Object[0]);
            return;
        }
        PlayerInfo playerInRound = (PlayerInfo)this.mPlayerInfoMap.get(player.getUid());
        if (playerInRound == null) {
            MLog.error((Object)TAG, (String)"player info update, but uid not in players", (Object[])new Object[0]);
            return;
        }
        MLog.info((Object)TAG, (String)"player info update, %s -> %s", (Object[])new Object[]{playerInRound, player});
        playerInRound.setChoosedUid(player.getChoosedUid());
        playerInRound.setStatus(player.getStatus());
        this.notifyPlayerDataUpdate(2, player.getUid());
    }

    @Override
    public void onServiceInit() {
        super.onServiceInit();
        this.updateCanStartPublish();
        this.mSelectPeopleRequesting.setValue((Object)false);
        this.mContext.getRoomPageContext().getChannel().getSeatService().addSeatUpdateListener((ISeatUpdateListener)this);
        this.mProtoService.addNotifyHandler(this.mNotifyHandler);
    }

    @Override
    public void onServiceDestroy() {
        super.onServiceDestroy();
        this.mContext.getRoomPageContext().getChannel().getSeatService().removeSeatUpdateListener((ISeatUpdateListener)this);
        this.mProtoService.removeNotifyHandler(this.mNotifyHandler);
        this.mPlayerInfoMap.clear();
    }

    private boolean checkCanStartPublish() {
        for (int i = 0; i < this.mPlayerInfoMap.size(); ++i) {
            PlayerInfo playerInfo = (PlayerInfo)this.mPlayerInfoMap.valueAt(i);
            if (playerInfo.getStatus() != 1) continue;
            return true;
        }
        return false;
    }

    private void updateCanStartPublish() {
        boolean checkResult = this.checkCanStartPublish();
        if (this.mCanStartPublish.getValue() != null && (Boolean)this.mCanStartPublish.getValue() == checkResult) {
            return;
        }
        this.mCanStartPublish.setValue((Object)checkResult);
    }
}

