/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.pickme.business;

import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.core.util.Pair;
import androidx.lifecycle.LiveData;
import com.yy.appbase.account.AccountUtil;
import com.yy.base.logger.MLog;
import com.yy.hiyo.channel.plugins.pickme.base.IEventHandler;
import com.yy.hiyo.channel.plugins.pickme.base.PickMeContext;
import com.yy.hiyo.channel.plugins.pickme.bean.MatchSuccessNotify;
import com.yy.hiyo.channel.plugins.pickme.bean.PlayerInfo;
import com.yy.hiyo.channel.plugins.pickme.bean.PlayerUpdateData;
import com.yy.hiyo.channel.plugins.pickme.bean.RoundInfo;
import com.yy.hiyo.channel.plugins.pickme.business.AbsPickMePlayController;
import com.yy.hiyo.channel.plugins.pickme.business.ServiceProvider;
import com.yy.hiyo.channel.plugins.pickme.business.base.ILifecycleObserver;
import com.yy.hiyo.channel.plugins.pickme.business.base.IPickMePrepareCallback;
import com.yy.hiyo.channel.plugins.pickme.business.base.IServiceProvider;
import com.yy.hiyo.channel.plugins.pickme.business.dataprovider.IDataProvider;
import com.yy.hiyo.channel.plugins.pickme.common.MatchEffectLevel;
import com.yy.hiyo.channel.plugins.pickme.common.PickMeEvent;
import com.yy.hiyo.channel.plugins.pickme.model.base.IResDataCallback;
import com.yy.hiyo.channel.plugins.pickme.seat.waitqueue.PickMeSeatWaitingPresenter;
import com.yy.hiyo.channel.plugins.pickme.seat.waitqueue.data.PickMeSeatWaitingKvoData;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class PickMePlayController
extends AbsPickMePlayController {
    private static final String TAG = "FTPickMe#PickMePlayController";
    private IDataProvider mDataProvider;

    public PickMePlayController(@NonNull PickMeContext context) {
        super(context);
    }

    @Override
    public void preparePickMe(final @androidx.annotation.Nullable IPickMePrepareCallback callback) {
        MLog.info((Object)TAG, (String)"preparePickMe", (Object[])new Object[0]);
        if (this.mContext == null) {
            MLog.error((Object)TAG, (String)"preparePickMe, context is null", (Object[])new Object[0]);
            return;
        }
        if (this.mContext.getRoomData() == null) {
            MLog.error((Object)TAG, (String)"preparePickMe, roomData is null", (Object[])new Object[0]);
            return;
        }
        this.mServiceProvider.getProtoService().getRoundInfo(new IResDataCallback<RoundInfo>(){

            @Override
            public void onSuccess(RoundInfo data) {
                if (!MLog.isLogLevelAboveDebug()) {
                    MLog.debug((Object)PickMePlayController.TAG, (String)("preparePickMe, getRoundInfo success, " + data), (Object[])new Object[0]);
                }
                if (!data.isSupport()) {
                    if (callback != null) {
                        callback.onNotSupport();
                    }
                    return;
                }
                boolean isNewPickMe = data.isNewPickMe();
                MLog.info((Object)PickMePlayController.TAG, (String)"is new pick me: %s", (Object[])new Object[]{isNewPickMe});
                PickMePlayController.this.mContext.setNewPickMe(isNewPickMe);
                PickMePlayController.this.initPickMeRoundInfo(data);
                if (callback != null) {
                    callback.onSuccess();
                }
            }

            @Override
            public void onFailure(long code, String msg) {
                MLog.error((Object)PickMePlayController.TAG, (String)"preparePickMe, getRoundInfo failed, code=%d, msg=%s", (Object[])new Object[]{code, msg});
                if (callback != null) {
                    callback.onFailure();
                }
            }
        });
    }

    private void initPickMeRoundInfo(RoundInfo roundInfo) {
        this.mServiceProvider.getPlayerManager().addEventHandler(this);
        this.mServiceProvider.getLifecycleManager().addEventHandler(this);
        this.mServiceProvider.getRoleManager().addEventHandler(this);
        this.mServiceProvider.getLifecycleManager().initStatus(roundInfo.getRoundStatus());
        this.mServiceProvider.getPlayerManager().initPlayerData(roundInfo.getPlayerList());
        this.mServiceProvider.onServiceInit();
        if (!this.mContext.getRoomPageContext().isDestroy()) {
            ((PickMeSeatWaitingPresenter)this.mContext.getRoomPageContext().getPresenter(PickMeSeatWaitingPresenter.class)).initSeatWaitingService(this.mServiceProvider.getPickMeSeatWaitingService());
        }
    }

    @Override
    public void closePickMe() {
        MLog.info((Object)TAG, (String)"closePickMe", (Object[])new Object[0]);
        this.mServiceProvider.getLifecycleManager().close();
        this.mServiceProvider.onServiceDestroy();
    }

    @Override
    protected IServiceProvider createServices() {
        return new ServiceProvider(this.mContext);
    }

    @Override
    public IEventHandler getViewEventHandler() {
        return this;
    }

    @Override
    public IDataProvider getDataProvider() {
        if (this.mDataProvider == null) {
            this.mDataProvider = new IDataProvider(){

                @Override
                public PickMeSeatWaitingKvoData getSeatWaitingData() {
                    return PickMePlayController.this.mServiceProvider.getPickMeSeatWaitingService().getPickMeWaitingKvoData();
                }

                @Override
                public void unJoinWaitingList() {
                    PickMePlayController.this.mServiceProvider.getPickMeSeatWaitingService().delQueue(AccountUtil.getUid(), null);
                }

                @Override
                public LiveData<Integer> getStatus() {
                    return PickMePlayController.this.mServiceProvider.getLifecycleManager().getStatus();
                }

                @Override
                public long getStatusUpdateTime() {
                    return PickMePlayController.this.mServiceProvider.getLifecycleManager().getStatusUpdateTime();
                }

                @Override
                public LiveData<Integer> getRoleType() {
                    return PickMePlayController.this.mServiceProvider.getRoleManager().getRoleType();
                }

                @Override
                public LiveData<PlayerUpdateData> getPlayerUpdateData() {
                    return PickMePlayController.this.mServiceProvider.getPlayerManager().getPlayerUpdateData();
                }

                @Override
                @androidx.annotation.Nullable
                public PlayerInfo getPlayerByUid(long uid) {
                    return PickMePlayController.this.mServiceProvider.getPlayerManager().getPlayerByUid(uid);
                }

                @Override
                public List<PlayerInfo> getCurrentAllPlayers() {
                    return PickMePlayController.this.mServiceProvider.getPlayerManager().getCurrentAllPlayers();
                }

                @Override
                public LiveData<Boolean> getCanStartPublish() {
                    return PickMePlayController.this.mServiceProvider.getPlayerManager().getCanStartPublish();
                }

                @Override
                public LiveData<MatchSuccessNotify> getMatchSuccessNotify() {
                    return PickMePlayController.this.mServiceProvider.getPlayerManager().getMatchSuccessNotify();
                }

                @Override
                public void getCharmInfo(long maleUid, long femaleUid, IResDataCallback<Pair<Long, MatchEffectLevel>> callback) {
                    PickMePlayController.this.mServiceProvider.getPlayerManager().getCharmInfo(maleUid, femaleUid, callback);
                }
            };
        }
        return this.mDataProvider;
    }

    @Override
    public void addLifecycleObserver(@NonNull ILifecycleObserver observer) {
        this.mServiceProvider.getLifecycleManager().addLifecycleObserver(observer);
    }

    @Override
    public void removeLifecycleObserver(@NonNull ILifecycleObserver observer) {
        this.mServiceProvider.getLifecycleManager().removeLifecycleObserver(observer);
    }

    @Override
    public void handleEvent(int eventId, @Nullable Bundle data) {
        LiveData<Integer> statusData;
        super.handleEvent(eventId, data);
        if (eventId == PickMeEvent.ON_NEW_ROUND_CLICK) {
            this.handleNewRoundClicked();
        } else if (eventId == PickMeEvent.ON_START_CHOOSE_CLICK) {
            this.handleChooseClicked();
        } else if (eventId == PickMeEvent.ON_START_PUBLISH_CLICK) {
            this.handlePublishClicked();
        } else if (eventId == PickMeEvent.ON_PICK_SOMEONE_CLICK) {
            this.handleSelectPeople(data);
        } else if (eventId == PickMeEvent.ON_CANCEL_PICK_SOMEONE_CLICK) {
            this.handleUnselectPeople(data);
        } else if (eventId == PickMeEvent.ON_PUBLISH_SOMEONE_CLICK) {
            this.handlePublishPlayerChoice(data);
        } else if (eventId == PickMeEvent.ON_PRE_NEW_ROUND_START) {
            this.mServiceProvider.getPlayerManager().resetAllPlayerStatus();
        } else if (eventId == PickMeEvent.ON_CAN_NEW_ROUND && (statusData = this.mServiceProvider.getLifecycleManager().getStatus()).getValue() != null && 2 == (Integer)statusData.getValue()) {
            this.mServiceProvider.getLifecycleManager().enterFinishedStatus();
        }
    }

    private void handleNewRoundClicked() {
        MLog.info((Object)TAG, (String)"handleNewRoundClicked", (Object[])new Object[0]);
        this.mServiceProvider.getLifecycleManager().startNewRound();
    }

    private void handleChooseClicked() {
        MLog.info((Object)TAG, (String)"handleChooseClicked", (Object[])new Object[0]);
        this.mServiceProvider.getLifecycleManager().startChoose();
    }

    private void handlePublishClicked() {
        MLog.info((Object)TAG, (String)"handlePublishClicked", (Object[])new Object[0]);
        this.mServiceProvider.getLifecycleManager().startPublish();
    }

    private void handlePublishPlayerChoice(Bundle data) {
        MLog.info((Object)TAG, (String)"handlePublishPlayerChoice", (Object[])new Object[0]);
        if (data == null) {
            MLog.error((Object)TAG, (String)"handlePublishPlayerChoice, but data is null", (Object[])new Object[0]);
            return;
        }
        long uid = data.getLong("seatUid", 0L);
        if (uid > 0L) {
            this.mServiceProvider.getPlayerManager().publishPlayerChoice(uid);
        }
    }

    private void handleSelectPeople(Bundle data) {
        MLog.info((Object)TAG, (String)"handleSelectPeople", (Object[])new Object[0]);
        if (data == null) {
            MLog.error((Object)TAG, (String)"handleSelectPeople, but data is null", (Object[])new Object[0]);
            return;
        }
        long uid = data.getLong("seatUid", 0L);
        if (uid > 0L) {
            this.mServiceProvider.getPlayerManager().selfLikePeople(uid);
        }
    }

    private void handleUnselectPeople(Bundle data) {
        MLog.info((Object)TAG, (String)"handleUnselectPeople", (Object[])new Object[0]);
        if (data == null) {
            MLog.error((Object)TAG, (String)"handleUnselectPeople, but data is null", (Object[])new Object[0]);
            return;
        }
        long uid = data.getLong("seatUid", 0L);
        if (uid > 0L) {
            this.mServiceProvider.getPlayerManager().selfUnlikePeople(uid);
        }
    }
}

