/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.pickme;

import android.os.Bundle;
import androidx.annotation.Nullable;
import androidx.lifecycle.MutableLiveData;
import com.yy.appbase.common.Callback;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.logger.MLog;
import com.yy.base.utils.ResourceUtils;
import com.yy.framework.core.ui.DefaultWindow;
import com.yy.hiyo.channel.cbase.AbsPage;
import com.yy.hiyo.channel.cbase.context.IChannelPageContext;
import com.yy.hiyo.channel.cbase.publicscreen.IPublicScreenService;
import com.yy.hiyo.channel.cbase.publicscreen.callback.IPublicScreenModulePresenter;
import com.yy.hiyo.channel.cbase.publicscreen.msg.PureTextMsg;
import com.yy.hiyo.channel.common.FacePoint;
import com.yy.hiyo.channel.component.base.ProxyPresenter;
import com.yy.hiyo.channel.component.seat.SeatPresenter;
import com.yy.hiyo.channel.component.theme.ThemePresenter;
import com.yy.hiyo.channel.component.theme.model.DrawableResThemeBean;
import com.yy.hiyo.channel.plugins.pickme.DR;
import com.yy.hiyo.channel.plugins.pickme.R;
import com.yy.hiyo.channel.plugins.pickme.base.IEventHandler;
import com.yy.hiyo.channel.plugins.pickme.base.PickMeContext;
import com.yy.hiyo.channel.plugins.pickme.business.PickMePlayController;
import com.yy.hiyo.channel.plugins.pickme.business.base.IPickMePlayController;
import com.yy.hiyo.channel.plugins.pickme.business.base.IPickMePrepareCallback;
import com.yy.hiyo.channel.plugins.pickme.business.dataprovider.IDataProvider;
import com.yy.hiyo.channel.plugins.pickme.common.PickMeEvent;
import com.yy.hiyo.channel.plugins.pickme.ui.PickMeViewController;
import com.yy.hiyo.channel.plugins.pickme.ui.base.IPickMeViewController;
import com.yy.hiyo.channel.plugins.voiceroom.plugin.AbsPluginPresenter;
import com.yy.hiyo.channel.publicscreen.BaseImMsg;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.service.IGameInfoService;
import com.yy.hiyo.mvp.base.callback.IDestroyable;
import com.yy.hiyo.mvp.base.callback.WeakCallback;
import java.util.Map;

public class PickMePresenter
extends AbsPluginPresenter
implements IEventHandler {
    private static final String TAG = "FTPickMe#PickMePresenter";
    private PickMeContext mPickMeContext;
    private boolean mPickMeRunning = false;
    private boolean mPickMeViewInstall = false;
    private boolean mPrepareSuccess = false;
    private IPickMeViewController mViewController;
    private IPickMePlayController mPlayController;

    private void preparePickMe() {
        MLog.info((Object)TAG, (String)"preparePickMe", (Object[])new Object[0]);
        if (this.mPickMeRunning) {
            MLog.error((Object)TAG, (String)"preparePickMe failed, PickMe plugin is running", (Object[])new Object[0]);
            return;
        }
        ((SeatPresenter)this.getPresenter(SeatPresenter.class)).setClipView(false);
        this.mPickMeRunning = true;
        this.mPickMeContext = new PickMeContext();
        this.mPickMeContext.setRoomPageContext((IChannelPageContext)this.getMvpContext());
        this.mPickMeContext.setRoomData(this.getRoomData());
        GameInfo gameInfo = ((IGameInfoService)((IChannelPageContext)this.getMvpContext()).getServiceManager().getService(IGameInfoService.class)).getGameInfoByGid("pickme");
        if (gameInfo != null) {
            this.mPickMeContext.setPickMeName(gameInfo.getGname());
        } else {
            this.mPickMeContext.setPickMeName(ResourceUtils.getString((int)R.string.title_pick_me));
        }
        this.mPlayController = new PickMePlayController(this.mPickMeContext);
        this.mPlayController.preparePickMe(new IPickMePrepareCallback(){

            @Override
            public void onSuccess() {
                MLog.info((Object)PickMePresenter.TAG, (String)"preparePickMe success", (Object[])new Object[0]);
                if (!PickMePresenter.this.mPickMeRunning) {
                    MLog.info((Object)PickMePresenter.TAG, (String)"PickMe closed", (Object[])new Object[0]);
                    return;
                }
                PickMePresenter.this.mPrepareSuccess = true;
                PickMePresenter.this.initPickMeViewController();
                PickMePresenter.this.showPickMeTheme();
            }

            @Override
            public void onNotSupport() {
                MLog.error((Object)PickMePresenter.TAG, (String)"preparePickMe , but not support", (Object[])new Object[0]);
                PickMePresenter.this.mPlayController = null;
                PickMePresenter.this.mPickMeRunning = false;
                PickMePresenter.this.mPrepareSuccess = false;
            }

            @Override
            public void onFailure() {
                MLog.error((Object)PickMePresenter.TAG, (String)"preparePickMe failed", (Object[])new Object[0]);
                PickMePresenter.this.mPlayController = null;
                PickMePresenter.this.mPickMeRunning = false;
                PickMePresenter.this.mPrepareSuccess = false;
            }
        });
    }

    private void initPickMeViewController() {
        if (this.getWindow() != null && this.mPrepareSuccess && !this.mPickMeViewInstall && this.mPlayController != null) {
            this.mPickMeViewInstall = true;
            this.mViewController = new PickMeViewController((IChannelPageContext)this.getMvpContext(), (DefaultWindow)this.getWindow(), this.mPickMeContext);
            this.mViewController.addEventHandler(this.mPlayController.getViewEventHandler());
            this.mViewController.addEventHandler(this);
            this.mViewController.initDataObserver(this.mPlayController.getDataProvider());
            this.mViewController.resume();
        }
    }

    private void closePickMe() {
        MLog.info((Object)TAG, (String)"closePickMe", (Object[])new Object[0]);
        if (this.mPlayController != null) {
            this.mPlayController.closePickMe();
            this.mPlayController = null;
        }
        if (this.mViewController != null) {
            this.mViewController.clear();
            this.mViewController = null;
        }
        this.mPickMeContext.setNewPickMe(false);
        this.mPickMeRunning = false;
        this.mPickMeViewInstall = false;
        this.mPrepareSuccess = false;
    }

    public void handleModeChange(long mode) {
        super.handleModeChange(mode);
        MLog.info((Object)TAG, (String)"handleModeChange, mode=%d, mPickMeRunning=%b", (Object[])new Object[]{mode, this.mPickMeRunning});
        if (!this.mPickMeRunning) {
            this.preparePickMe();
        }
    }

    public boolean interceptModeChange() {
        super.interceptModeChange();
        this.onPickMeModeExited();
        return false;
    }

    @Override
    public void handleEvent(int eventId, @Nullable Bundle data) {
        if (eventId == PickMeEvent.ON_END_CLICK) {
            this.requestSwitchMode();
        }
    }

    public void resumePlugin() {
        super.resumePlugin();
        if (this.mViewController != null) {
            this.mViewController.resume();
        }
    }

    public boolean canChangeSeat() {
        return true;
    }

    public boolean haveSelfFaceLocation() {
        return false;
    }

    public MutableLiveData<Map<Long, FacePoint>> getFaceLocation() {
        return null;
    }

    public boolean interceptRunningState() {
        return false;
    }

    public void onPageDetach(AbsPage page) {
        super.onPageDetach(page);
        if (this.mViewController != null) {
            this.mViewController.pause();
        }
    }

    public void onDestroy() {
        super.onDestroy();
        this.closePickMe();
    }

    public void onPageAttach(AbsPage page, boolean isReAttach) {
        super.onPageAttach(page, isReAttach);
        this.initPickMeViewController();
        if (isReAttach && this.mViewController != null) {
            this.mViewController.resume();
        }
    }

    private void requestSwitchMode() {
        MLog.info((Object)TAG, (String)"requestSwitchMode", (Object[])new Object[0]);
        ((ProxyPresenter)this.getPresenter(ProxyPresenter.class)).closeCurrentPlugin((Callback)WeakCallback.of((IDestroyable)this, result2 -> MLog.info((Object)TAG, (String)"requestSwitchMode, switchMode result=%b", (Object[])new Object[]{result2})));
    }

    private void onPickMeModeExited() {
        this.showPickMeClosedMsg();
        this.closePickMe();
    }

    private void showPickMeClosedMsg() {
        if (this.mPickMeContext == null || this.isDestroyed()) {
            return;
        }
        IPublicScreenService service = (IPublicScreenService)ServiceManagerProxy.getService(IPublicScreenService.class);
        if (service != null) {
            PureTextMsg pureTextMsg = service.getMsgItemFactory().generateLocalPureTextMsg(this.getChannel().getChannelId(), (CharSequence)ResourceUtils.getString((int)R.string.short_tips_pick_me_closed, (Object[])new Object[]{this.mPickMeContext.getPickMeName()}), this.getChannel().getRoleService().getRoleCache(this.getRoomData().getPlayManagerUid()), this.getRoomData().getPlayManagerUid());
            pureTextMsg.setMsgState(1);
            ((IPublicScreenModulePresenter)this.getPresenter(IPublicScreenModulePresenter.class)).getPublicScreenPresenter().appendLocalMsg((BaseImMsg)pureTextMsg);
        }
    }

    private void showPickMeTheme() {
        if (this.isDestroyed()) {
            return;
        }
        DrawableResThemeBean drawableResThemeBean = new DrawableResThemeBean();
        drawableResThemeBean.setRemoteBgDrawableRes(DR.bg_pick_me);
        ((ThemePresenter)this.getPresenter(ThemePresenter.class)).getModeTheme().setValue((Object)drawableResThemeBean);
    }

    @Nullable
    public IDataProvider getDataProvider() {
        return this.mPlayController == null ? null : this.mPlayController.getDataProvider();
    }
}

