/*
 * Decompiled with CFR 0.152.
 */
package com.duowan.hago.party.imp.login;

import android.content.Context;
import com.duowan.hago.party.imp.login.LoginChecker;
import com.yy.appbase.account.AccountUtil;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;

public class AutoGuestLoginer {
    private static volatile boolean sIsAutoLogining = false;
    private static INotify sLoginNotify;
    private static int sRetryTimes;

    private static void initNotify() {
        if (sLoginNotify == null && NotificationCenter.getGlobalInstance().isInited()) {
            sLoginNotify = new INotify(){

                public void notify(Notification notification) {
                    if (notification.id == NotificationDef.N_NETWORK_STATE_CHANGE && NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
                        if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)"AutoGuestLoginer", (String)"net is ok now!", (Object[])new Object[0]);
                        }
                        AutoGuestLoginer.startAutoLoginIfNeed();
                        sRetryTimes = 0;
                    }
                }
            };
            NotificationCenter.getGlobalInstance().register(NotificationDef.N_NETWORK_STATE_CHANGE, sLoginNotify);
        }
    }

    public static void startAutoLoginIfNeed() {
        AutoGuestLoginer.initNotify();
        if (AccountUtil.getUid() > 0L || sIsAutoLogining) {
            return;
        }
        sIsAutoLogining = true;
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)"AutoGuestLoginer", (String)"startAutoLogin!", (Object[])new Object[0]);
        }
        LoginChecker.ensureLogin(null, new Runnable(){

            @Override
            public void run() {
                sIsAutoLogining = false;
            }
        }, new Runnable(){

            @Override
            public void run() {
                sIsAutoLogining = false;
                if (NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)"AutoGuestLoginer", (String)"error!", (Object[])new Object[0]);
                    }
                    YYTaskExecutor.execute((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (AccountUtil.getUid() > 0L) {
                                return;
                            }
                            AutoGuestLoginer.startAutoLoginIfNeed();
                        }
                    }, (long)(1000 + sRetryTimes * 100));
                } else if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)"AutoGuestLoginer", (String)"error by no net!", (Object[])new Object[0]);
                }
            }
        });
    }

    static {
        sRetryTimes = 0;
    }
}

