/*
 * Decompiled with CFR 0.152.
 */
package com.duowan.hago.party.imp.game.channelgame.model;

import androidx.annotation.Nullable;
import com.duowan.hago.party.imp.game.channelgame.model.RoomGameListRsp;
import com.duowan.hago.party.imp.game.channelgame.model.VoiceRoomGameCategory;
import com.duowan.hago.party.imp.game.channelgame.model.VoiceRoomGameData;
import com.google.gson.reflect.TypeToken;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.constant.CommonPerfUtils;
import com.yy.appbase.envsetting.uriprovider.UriProvider;
import com.yy.appbase.http.BaseResponseBean;
import com.yy.appbase.http.HttpUtil;
import com.yy.appbase.http.INetRespCallback;
import com.yy.appbase.service.IServiceManager;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.env.RuntimeContext;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.filestorage.FileStorageUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.hiyo.game.base.GameDataBean;
import com.yy.hiyo.game.base.bean.GameCategory;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.base.bean.GameInfoSource;
import com.yy.hiyo.game.base.channelgame.IChannelGameListModel;
import com.yy.hiyo.game.base.channelgame.IRoomGameListCallback;
import com.yy.hiyo.game.base.helper.ModifyJsGameHelper;
import com.yy.hiyo.game.service.IGameInfoService;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import okhttp3.Call;
import org.jetbrains.annotations.NotNull;

public class GameListModel
implements IChannelGameListModel {
    private static final String TAG = "FTVoiceRoom GameListModel";
    private static final String FILE_NAME = "VoiceRoomGameList";
    private static final String IN_VOICE_ROOM_FILE_NAME = "InVoiceRoomGameList";

    public void requestGameList(final @Nullable IRoomGameListCallback callback) {
        boolean hadVoiceGameList = this.hadVoiceGameList();
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)TAG, (String)"requestGameList hadVoiceGameList: %b", (Object[])new Object[]{hadVoiceGameList});
        }
        if (hadVoiceGameList) {
            ((IGameInfoService)this.getServiceManager().getService(IGameInfoService.class)).setRoomGameLoaded();
            if (callback != null) {
                callback.onSuccess(2);
            }
            return;
        }
        YYTaskExecutor.execute(() -> {
            Type type;
            BaseResponseBean res;
            String data = FileStorageUtils.getInstance().getStrFromFile(true, FILE_NAME);
            String versoin = "";
            List<VoiceRoomGameData> voiceRoomGameDataList = null;
            if (StringUtils.isNotEmpty((String)data) && (res = (BaseResponseBean)JsonParser.parseJsonObject((String)data, (Type)(type = new TypeToken<BaseResponseBean<RoomGameListRsp>>(){}.getType()))) != null && res.isSuccess() && res.data != null && ((RoomGameListRsp)res.data).list != null && (voiceRoomGameDataList = ((RoomGameListRsp)res.data).list).size() > 0) {
                versoin = ((RoomGameListRsp)res.data).version;
            }
            if (RuntimeContext.isInGray()) {
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)TAG, (String)"requestGameList get local ver: %s data: %s", (Object[])new Object[]{versoin, data});
                }
            } else if (data != null && FeatureLog.isLogLevelBlowInfo()) {
                FeatureLog.i((String)TAG, (String)"requestGameList get local ver: %s dataSize: %s", (Object[])new Object[]{versoin, data.length()});
            }
            if (!FP.empty(voiceRoomGameDataList)) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)"requestGameList \u5148\u8bbe\u7f6e\u672c\u5730\u7f13\u5b58\u6570\u636e", (Object[])new Object[0]);
                }
                this.onFetchListSuccess(data, voiceRoomGameDataList);
                ((IGameInfoService)this.getServiceManager().getService(IGameInfoService.class)).setRoomGameLoaded();
            }
            HashMap<String, String> params = new HashMap<String, String>(2);
            params.put("version", versoin);
            params.put("entryType", String.valueOf(0));
            final String finalVersion = versoin;
            final List<VoiceRoomGameData> fVoiceRoomGameDataList = voiceRoomGameDataList;
            HttpUtil.httpReq((String)UriProvider.getVoiceRoomGameList(), params, (int)1, (INetRespCallback)new INetRespCallback<RoomGameListRsp>(){

                public void onError(Call call, Exception e, int id2) {
                    if (FeatureLog.isLogLevelBlowInfo()) {
                        FeatureLog.i((String)GameListModel.TAG, (String)"requestGameList \u83b7\u53d6\u6e38\u620f\u5217\u8868\u51fa\u9519:%s", (Object[])new Object[]{e});
                    }
                    if (callback != null) {
                        callback.onSuccess(0);
                    }
                }

                public void onResponse(String response, BaseResponseBean<RoomGameListRsp> res, int id2) {
                    if (RuntimeContext.isInGray() && FeatureLog.isLogLevelBlowInfo()) {
                        FeatureLog.i((String)GameListModel.TAG, (String)"requestGameList onResponse: %s", (Object[])new Object[]{response});
                    }
                    GameListModel.this.onGameListResponse(response, (BaseResponseBean<RoomGameListRsp>)res, finalVersion, fVoiceRoomGameDataList, callback);
                }
            });
        });
    }

    private void onGameListResponse(String response, BaseResponseBean<RoomGameListRsp> res, String finalVersion, List<VoiceRoomGameData> fVoiceRoomGameDataList, @Nullable IRoomGameListCallback callback) {
        if (res.isSuccess() && res.data != null) {
            if (StringUtils.isNotEmpty((String)finalVersion) && finalVersion.equals(((RoomGameListRsp)res.data).version)) {
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)TAG, (String)" onGameListResponse version \u4e00\u6837\uff0c\u4f7f\u7528\u7f13\u5b58\uff1a%d", (Object[])new Object[]{FP.size(fVoiceRoomGameDataList)});
                }
                if (callback != null) {
                    callback.onSuccess(1);
                }
                return;
            }
            this.onFetchListSuccess(response, ((RoomGameListRsp)res.data).list);
            ((IGameInfoService)this.getServiceManager().getService(IGameInfoService.class)).setRoomGameLoaded();
            YYTaskExecutor.execute(() -> FileStorageUtils.getInstance().saveToFile(true, response, FILE_NAME));
            if (callback != null) {
                callback.onSuccess(1);
            }
        } else if (callback != null) {
            callback.onSuccess(0);
        }
    }

    public void requestInVoiceRoomGameList(final @Nullable IRoomGameListCallback callback) {
        boolean hadVoiceGameList = this.hadInVoiceGameList();
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)TAG, (String)"requestInVoiceRoomGameList hadVoiceGameList: %b", (Object[])new Object[]{hadVoiceGameList});
        }
        if (hadVoiceGameList) {
            if (callback != null) {
                callback.onSuccess(2);
            }
            return;
        }
        YYTaskExecutor.execute(() -> {
            Type type;
            BaseResponseBean res;
            final String cacheFileName = AccountUtil.getUid() + "aec76199ed9c79a27632e4fb8706a69e";
            String data = FileStorageUtils.getInstance().getStrFromFile(true, cacheFileName);
            String versoin = "";
            boolean isradio = false;
            List<VoiceRoomGameData> voiceRoomGameDataList = null;
            List<VoiceRoomGameData> floatGameDataList = null;
            List<VoiceRoomGameCategory> roomCatGames = null;
            if (StringUtils.isNotEmpty((String)data) && (res = (BaseResponseBean)JsonParser.parseJsonObject((String)data, (Type)(type = new TypeToken<BaseResponseBean<RoomGameListRsp>>(){}.getType()))) != null && res.isSuccess() && res.data != null && ((RoomGameListRsp)res.data).list != null) {
                voiceRoomGameDataList = ((RoomGameListRsp)res.data).list;
                floatGameDataList = ((RoomGameListRsp)res.data).popupList;
                roomCatGames = ((RoomGameListRsp)res.data).roomCatGames;
                if (voiceRoomGameDataList.size() > 0) {
                    versoin = ((RoomGameListRsp)res.data).version;
                }
                boolean bl = isradio = ((RoomGameListRsp)res.data).isradio != null && ((RoomGameListRsp)res.data).isradio != false;
            }
            if (RuntimeContext.isInGray()) {
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)TAG, (String)"requestInVoiceRoomGameList get local version: %s data: %s", (Object[])new Object[]{versoin, data});
                }
            } else if (FeatureLog.isLogLevelBlowInfo()) {
                FeatureLog.i((String)TAG, (String)"requestInVoiceRoomGameList get local version: %s data: %d", (Object[])new Object[]{versoin, data != null ? data.length() : 0});
            }
            if (!FP.empty(voiceRoomGameDataList)) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)"requestInVoiceRoomGameList \u5148\u8bbe\u7f6e\u672c\u5730\u7f13\u5b58\u6570\u636e", (Object[])new Object[0]);
                }
                this.onFetchInVoiceRoomListSuccess(data, voiceRoomGameDataList, floatGameDataList, roomCatGames, isradio);
                ((IGameInfoService)this.getServiceManager().getService(IGameInfoService.class)).setRoomInGameLoaded();
            }
            HashMap<String, String> params = new HashMap<String, String>(2);
            params.put("version", versoin);
            params.put("entryType", String.valueOf(1));
            final List<VoiceRoomGameData> fVoiceRoomGameDataList = voiceRoomGameDataList;
            final List<VoiceRoomGameData> fFloatGameDataList = floatGameDataList;
            final String finalVersion = versoin;
            HttpUtil.httpReq((String)UriProvider.getVoiceRoomGameList(), params, (int)1, (INetRespCallback)new INetRespCallback<RoomGameListRsp>(){

                public void onError(Call call, Exception e, int id2) {
                    if (FeatureLog.isLogLevelBlowInfo()) {
                        FeatureLog.i((String)GameListModel.TAG, (String)"requestInVoiceRoomGameList \u83b7\u53d6\u6e38\u620f\u5217\u8868\u51fa\u9519:%s", (Object[])new Object[]{e});
                    }
                    if (callback != null) {
                        callback.onSuccess(0);
                    }
                }

                public void onResponse(String response, BaseResponseBean<RoomGameListRsp> res, int id2) {
                    if (RuntimeContext.isInGray()) {
                        if (FeatureLog.isLogLevelBlowInfo()) {
                            FeatureLog.i((String)GameListModel.TAG, (String)"requestInVoiceRoomGameList onResponse: %s", (Object[])new Object[]{response});
                        }
                    } else if (FeatureLog.isLogLevelBlowInfo()) {
                        FeatureLog.i((String)GameListModel.TAG, (String)"requestInVoiceRoomGameList onResponse: %d", (Object[])new Object[]{response != null ? Integer.valueOf(response.length()) : ""});
                    }
                    GameListModel.this.onInVoiceRoomGameListResponse(response, (BaseResponseBean<RoomGameListRsp>)res, fVoiceRoomGameDataList, fFloatGameDataList, callback, cacheFileName, finalVersion);
                }
            });
        });
    }

    private void onInVoiceRoomGameListResponse(String response, BaseResponseBean<RoomGameListRsp> res, List<VoiceRoomGameData> fVoiceRoomGameDataList, List<VoiceRoomGameData> fFloatGameDataList, @Nullable IRoomGameListCallback callback, String cacheFileName, String version) {
        if (res.isSuccess() && res.data != null) {
            if (StringUtils.isNotEmpty((String)version) && version.equals(((RoomGameListRsp)res.data).version)) {
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)TAG, (String)" onInVoiceRoomGameListResponse version \u4e00\u6837\uff0c\u4f7f\u7528\u7f13\u5b58\uff1a%d, %d", (Object[])new Object[]{FP.size(fVoiceRoomGameDataList), FP.size(fFloatGameDataList)});
                }
                if (callback != null) {
                    callback.onSuccess(1);
                }
                return;
            }
            this.onFetchInVoiceRoomListSuccess(response, ((RoomGameListRsp)res.data).list, ((RoomGameListRsp)res.data).popupList, ((RoomGameListRsp)res.data).roomCatGames, ((RoomGameListRsp)res.data).isradio);
            ((IGameInfoService)this.getServiceManager().getService(IGameInfoService.class)).setRoomInGameLoaded();
            YYTaskExecutor.execute(() -> FileStorageUtils.getInstance().saveToFile(true, response, cacheFileName));
            if (callback != null) {
                callback.onSuccess(1);
            }
        } else if (callback != null) {
            callback.onSuccess(0);
        }
    }

    private void onFetchInVoiceRoomListSuccess(String response, @Nullable List<VoiceRoomGameData> list, @Nullable List<VoiceRoomGameData> floatGameList, @Nullable List<VoiceRoomGameCategory> roomCatGames, Boolean isradio) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"onFetchInVoiceRoomListSuccess %d, %d", (Object[])new Object[]{FP.size(list), FP.size(floatGameList)});
        }
        List<Object> gameInfoList = new ArrayList();
        List<Object> floatGameInfoList = new ArrayList();
        if (!FP.empty(list)) {
            List<VoiceRoomGameData> tempList = this.modifyInVoiceRoomGameList(list);
            gameInfoList = this.convertGameInfo(response, tempList, GameInfoSource.IN_VOICE_ROOM);
            for (GameInfo gameInfo : gameInfoList) {
                if (!"radio".equals(gameInfo.gid)) continue;
                gameInfo.setOnlyOwnerShowRadio(isradio != null && isradio != false);
            }
        }
        if (!FP.empty(floatGameList)) {
            floatGameInfoList = this.convertGameInfo(response, floatGameList, GameInfoSource.FLOAT_PLAY);
        }
        this.handleUpdateVoiceRoomGameCateInfo(roomCatGames);
        ((IGameInfoService)this.getServiceManager().getService(IGameInfoService.class)).updateInVoiceRoomGameInfo(gameInfoList, floatGameInfoList);
    }

    private void handleUpdateVoiceRoomGameCateInfo(List<VoiceRoomGameCategory> roomCatGames) {
        if (roomCatGames != null) {
            ArrayList<GameCategory> gameCategories = new ArrayList<GameCategory>();
            for (VoiceRoomGameCategory voiceRoomGameCategory : roomCatGames) {
                gameCategories.add(new GameCategory(voiceRoomGameCategory.getCatName(), voiceRoomGameCategory.getGameIds(), voiceRoomGameCategory.isOutter().booleanValue()));
            }
            ((IGameInfoService)this.getServiceManager().getService(IGameInfoService.class)).updateVoiceRoomGameCateInfo(gameCategories);
        }
    }

    @NotNull
    private List<GameInfo> convertGameInfo(String response, List<VoiceRoomGameData> tempList, GameInfoSource inVoiceRoom) {
        ArrayList<GameInfo> gameInfoList = new ArrayList<GameInfo>();
        if (FP.empty(tempList)) {
            return gameInfoList;
        }
        boolean happenExcep = false;
        GameInfo gameInfo = null;
        for (VoiceRoomGameData voiceRoomGameData : tempList) {
            GameDataBean gameDataBean;
            if (voiceRoomGameData.ktvGameItem != null) {
                gameInfoList.add(GameInfo.newBuilder((GameInfoSource)inVoiceRoom).gid(voiceRoomGameData.ktvGameItem.gid).gname(voiceRoomGameData.ktvGameItem.name).iconUrl(voiceRoomGameData.ktvGameItem.squareIconUrl).imIconUrl(voiceRoomGameData.ktvGameItem.iconUrl).quickJoin(Boolean.valueOf(voiceRoomGameData.ktvGameItem.quickJoin)).minPlayerCount(voiceRoomGameData.ktvGameItem.minPlayerCount).gameRule(voiceRoomGameData.ktvGameItem.gameRule).gameRuleBgUrl(voiceRoomGameData.ktvGameItem.gameRuleBgUrl).gamePrepareBgUrl(voiceRoomGameData.ktvGameItem.gamePrepareBgUrl).hide(voiceRoomGameData.ktvGameItem.hide).moduleGray(voiceRoomGameData.ktvGameItem.moduleGray).chanGameDesc(voiceRoomGameData.ktvGameItem.chanGameDesc).gameMode(8).build());
            }
            if ((gameDataBean = voiceRoomGameData.dataItem) == null) continue;
            int voiceRoomFlag = -1;
            if (voiceRoomGameData.flag != null) {
                voiceRoomFlag = voiceRoomGameData.flag.getFlag();
            }
            try {
                gameInfo = GameDataBean.toGameInfo((GameDataBean)gameDataBean, (GameInfoSource)inVoiceRoom, (int)voiceRoomFlag);
            }
            catch (Throwable e) {
                String error = e != null ? e.toString() : "";
                error = error + " Flag:" + voiceRoomFlag;
                error = error + " source:" + (inVoiceRoom != null ? inVoiceRoom.getSource() : "");
                error = error + " item:" + gameDataBean.getId() + ", " + gameDataBean.getTitle();
                CommonPerfUtils.statCrashProtect((Throwable)e, (String)error);
                MLog.error((Object)TAG, (String)error, (Object[])new Object[0]);
                happenExcep = true;
            }
            gameInfoList.add(gameInfo);
        }
        if (happenExcep) {
            MLog.error((Object)TAG, (String)"convertGameInfo happenExcep:%s", (Object[])new Object[]{response != null ? response : ""});
        }
        return gameInfoList;
    }

    private List<VoiceRoomGameData> modifyInVoiceRoomGameList(List<VoiceRoomGameData> list) {
        ArrayList<VoiceRoomGameData> tempOriginList = new ArrayList<VoiceRoomGameData>(list);
        CopyOnWriteArrayList<GameDataBean> gameList = new CopyOnWriteArrayList<GameDataBean>();
        for (VoiceRoomGameData dataItem : tempOriginList) {
            if (dataItem.ktvGameItem != null && ("ktv".equals(dataItem.ktvGameItem.gid) || "micup".equals(dataItem.ktvGameItem.gid))) {
                GameDataBean dataBean = new GameDataBean();
                dataBean.setId(dataItem.ktvGameItem.gid);
                dataBean.setIconUrl(dataItem.ktvGameItem.squareIconUrl);
                dataBean.setImIconUrl(dataItem.ktvGameItem.iconUrl);
                dataBean.setTitle(dataItem.ktvGameItem.name);
                dataBean.setQuickJoin(dataItem.ktvGameItem.quickJoin);
                dataBean.setGameMode(8);
                dataBean.setMinPlayerCount(dataItem.ktvGameItem.minPlayerCount);
                dataBean.setGameRule(dataItem.ktvGameItem.gameRule);
                dataBean.setGameRuleBgUrl(dataItem.ktvGameItem.gameRuleBgUrl);
                dataBean.setGamePrepareBgUrl(dataItem.ktvGameItem.gamePrepareBgUrl);
                gameList.add(dataBean);
            }
            gameList.add(dataItem.dataItem);
        }
        ModifyJsGameHelper.Companion.modifyJsGame(gameList, tempOriginList);
        return tempOriginList;
    }

    private boolean hadVoiceGameList() {
        if (this.getServiceManager() == null || this.getServiceManager().getService(IGameInfoService.class) == null) {
            return false;
        }
        return !FP.empty((Collection)((IGameInfoService)this.getServiceManager().getService(IGameInfoService.class)).getVoiceRoomGameInfoList());
    }

    private boolean hadInVoiceGameList() {
        if (this.getServiceManager() == null || this.getServiceManager().getService(IGameInfoService.class) == null) {
            return false;
        }
        return !FP.empty((Collection)((IGameInfoService)this.getServiceManager().getService(IGameInfoService.class)).getInVoiceRoomGameInfoList());
    }

    private IServiceManager getServiceManager() {
        return ServiceManagerProxy.getServiceManager();
    }

    private void onFetchListSuccess(String response, @Nullable List<VoiceRoomGameData> list) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"onFetchListSuccess %d", (Object[])new Object[]{FP.size(list)});
        }
        if (!FP.empty(list)) {
            List<VoiceRoomGameData> tempList = this.modifyGameList(list);
            List<GameInfo> gameInfoList = this.convertGameInfo(response, tempList, GameInfoSource.VOICE_ROOM);
            ((IGameInfoService)this.getServiceManager().getService(IGameInfoService.class)).updateVoiceRoomGameInfo(gameInfoList);
        } else {
            ((IGameInfoService)this.getServiceManager().getService(IGameInfoService.class)).updateVoiceRoomGameInfo(Collections.emptyList());
        }
    }

    private List<VoiceRoomGameData> modifyGameList(List<VoiceRoomGameData> list) {
        ArrayList<VoiceRoomGameData> tempOriginList = new ArrayList<VoiceRoomGameData>(list);
        CopyOnWriteArrayList<GameDataBean> gameList = new CopyOnWriteArrayList<GameDataBean>();
        for (VoiceRoomGameData dataItem : tempOriginList) {
            if (dataItem.ktvGameItem != null && ("ktv".equals(dataItem.ktvGameItem.gid) || "micup".equals(dataItem.ktvGameItem.gid))) {
                GameDataBean dataBean = new GameDataBean();
                dataBean.setId(dataItem.ktvGameItem.gid);
                dataBean.setIconUrl(dataItem.ktvGameItem.squareIconUrl);
                dataBean.setImIconUrl(dataItem.ktvGameItem.iconUrl);
                dataBean.setTitle(dataItem.ktvGameItem.name);
                dataBean.setQuickJoin(dataItem.ktvGameItem.quickJoin);
                dataBean.setGameMode(8);
                dataBean.setMinPlayerCount(dataItem.ktvGameItem.minPlayerCount);
                dataBean.setGameRule(dataItem.ktvGameItem.gameRule);
                dataBean.setGameRuleBgUrl(dataItem.ktvGameItem.gameRuleBgUrl);
                dataBean.setGamePrepareBgUrl(dataItem.ktvGameItem.gamePrepareBgUrl);
                gameList.add(dataBean);
            }
            gameList.add(dataItem.dataItem);
        }
        ModifyJsGameHelper.Companion.modifyJsGame(gameList, tempOriginList);
        return tempOriginList;
    }
}

