/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.mvp.base;

import android.content.Context;
import android.os.Build;
import android.view.View;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStore;
import com.yy.base.logger.MLog;
import com.yy.base.sword.SwordHelper;
import com.yy.hiyo.mvp.base.IMvp;
import com.yy.hiyo.mvp.base.IMvpContext;
import com.yy.hiyo.mvp.base.IMvpLifeCycleOwner;
import com.yy.hiyo.mvp.base.PresenterProvider;
import com.yy.hiyo.mvp.base.SimpleLifeCycleOwner;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 D2\u00020\u00012\u00020\u0002:\u0001DB\u0019\b\u0014\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u0017\b\u0014\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fB#\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u000fJ,\u0010-\u001a\u00020.2\"\u0010/\u001a\u001e\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020201\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u0002020100H\u0016J\b\u00103\u001a\u000204H\u0016J%\u00105\u001a\u0002H6\"\b\b\u0000\u00106*\u0002022\f\u00107\u001a\b\u0012\u0004\u0012\u0002H601H\u0016\u00a2\u0006\u0002\u00108J\u0018\u00109\u001a\u00020\u000b2\u000e\u00107\u001a\n\u0012\u0006\b\u0001\u0012\u00020:01H\u0016J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000b0;H\u0016J\b\u0010<\u001a\u00020.H\u0016J\u000e\u0010=\u001a\u00020.2\u0006\u0010>\u001a\u00020?J2\u0010@\u001a\u00020.2(\u0010A\u001a$\u0012 \u0012\u001e\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020201\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020201000BH\u0016J\b\u0010C\u001a\u00020\u0006H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R \u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00140\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0013\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R \u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000b8F@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u000e\u0010\"\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010%\u001a\u00020&X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0014\u0010)\u001a\u00020*X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,\u00a8\u0006E"}, d2={"Lcom/yy/hiyo/mvp/base/PageMvpContext;", "Lcom/yy/hiyo/mvp/base/IMvpContext;", "Landroidx/lifecycle/LifecycleOwner;", "context", "Landroid/content/Context;", "tag", "", "(Landroid/content/Context;Ljava/lang/String;)V", "view", "Landroid/view/View;", "isAutoDestroy", "", "(Landroid/view/View;Z)V", "factory", "Landroidx/lifecycle/ViewModelProvider$Factory;", "(Landroid/content/Context;Ljava/lang/String;Landroidx/lifecycle/ViewModelProvider$Factory;)V", "getContext", "()Landroid/content/Context;", "extra", "Ljava/util/HashMap;", "", "getExtra", "()Ljava/util/HashMap;", "getFactory", "()Landroidx/lifecycle/ViewModelProvider$Factory;", "<set-?>", "isDestroy", "()Z", "isDestroyData", "Landroidx/lifecycle/MutableLiveData;", "lifecycleOwner", "Lcom/yy/hiyo/mvp/base/IMvpLifeCycleOwner;", "getLifecycleOwner", "()Lcom/yy/hiyo/mvp/base/IMvpLifeCycleOwner;", "logTag", "mLifecycleOwner", "Lcom/yy/hiyo/mvp/base/SimpleLifeCycleOwner;", "presenterProvider", "Lcom/yy/hiyo/mvp/base/PresenterProvider;", "getPresenterProvider", "()Lcom/yy/hiyo/mvp/base/PresenterProvider;", "viewModelStore", "Landroidx/lifecycle/ViewModelStore;", "getViewModelStore", "()Landroidx/lifecycle/ViewModelStore;", "addPresenterInterceptorClass", "", "map", "", "Ljava/lang/Class;", "Landroidx/lifecycle/ViewModel;", "getLifecycle", "Landroidx/lifecycle/Lifecycle;", "getPresenter", "T", "clazz", "(Ljava/lang/Class;)Landroidx/lifecycle/ViewModel;", "hasPresenter", "Lcom/yy/hiyo/mvp/base/IMvp$IPresenter;", "Landroidx/lifecycle/LiveData;", "onDestroy", "onEvent", "event", "Landroidx/lifecycle/Lifecycle$Event;", "setPresenterClassInterceptor", "interceptor", "Lkotlin/Function0;", "toString", "Companion", "mvvm_release"})
public class PageMvpContext
implements IMvpContext,
LifecycleOwner {
    private final String logTag;
    private final SimpleLifeCycleOwner mLifecycleOwner;
    @NotNull
    private final PresenterProvider presenterProvider;
    private final MutableLiveData<Boolean> isDestroyData;
    private boolean isDestroy;
    @NotNull
    private final ViewModelStore viewModelStore;
    @NotNull
    private final HashMap<String, Object> extra;
    @NotNull
    private final Context context;
    @Nullable
    private final ViewModelProvider.Factory factory;
    private static final String TAG = "PageMvpContext";
    public static final Companion Companion = new Companion(null);

    @NotNull
    protected final PresenterProvider getPresenterProvider() {
        return this.presenterProvider;
    }

    @Override
    public final boolean isDestroy() {
        return Intrinsics.areEqual((Object)((Boolean)this.isDestroyData.getValue()), (Object)true);
    }

    @Override
    @NotNull
    public ViewModelStore getViewModelStore() {
        return this.viewModelStore;
    }

    @Override
    @NotNull
    public HashMap<String, Object> getExtra() {
        return this.extra;
    }

    @Override
    @NotNull
    public IMvpLifeCycleOwner getLifecycleOwner() {
        return this.mLifecycleOwner;
    }

    @Override
    public void setPresenterClassInterceptor(@NotNull Function0<? extends Map<Class<? extends ViewModel>, ? extends Class<? extends ViewModel>>> interceptor) {
        Intrinsics.checkParameterIsNotNull(interceptor, (String)"interceptor");
        this.presenterProvider.setClassInterceptor(interceptor);
    }

    @Override
    public void addPresenterInterceptorClass(@NotNull Map<Class<? extends ViewModel>, ? extends Class<? extends ViewModel>> map) {
        Intrinsics.checkParameterIsNotNull(map, (String)"map");
        this.presenterProvider.addPresenterInterceptorClass(map);
    }

    @NotNull
    public <T extends ViewModel> T getPresenter(@NotNull Class<T> clazz) {
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        if (this.isDestroy()) {
            String string;
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string2 = "getPresenter context is destroy, class %s";
            Object[] objectArray = new Object[]{clazz};
            String string3 = TAG;
            boolean bl = false;
            String string4 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"java.lang.String.format(format, *args)");
            String string5 = string = string4;
            MLog.error((Object)string3, (Throwable)new IllegalStateException(string5));
        }
        ViewModel viewModel = this.presenterProvider.get(clazz);
        Intrinsics.checkExpressionValueIsNotNull((Object)viewModel, (String)"presenterProvider.get(clazz)");
        return (T)viewModel;
    }

    @Override
    public boolean hasPresenter(@NotNull Class<? extends IMvp.IPresenter> clazz) {
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        for (IMvp.IPresenter item : this.presenterProvider.getAll()) {
            if (!clazz.isInstance(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void onDestroy() {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)this.logTag, (String)"onDestroy %s, state %s", (Object[])new Object[]{this, this.mLifecycleOwner.getLifecycle().getCurrentState()});
        }
        this.mLifecycleOwner.onEvent(Lifecycle.Event.ON_DESTROY);
        this.presenterProvider.onDestroy();
        this.isDestroyData.setValue((Object)true);
        SwordHelper.leakWatch((Object)this, (String)"page context destroy");
    }

    @NotNull
    public Lifecycle getLifecycle() {
        return this.mLifecycleOwner.getLifecycle();
    }

    @Override
    public final void onEvent(@NotNull Lifecycle.Event event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        if (event == Lifecycle.Event.ON_DESTROY) {
            this.onDestroy();
        } else {
            this.mLifecycleOwner.onEvent(event);
        }
    }

    @Override
    @NotNull
    public LiveData<Boolean> isDestroyData() {
        return (LiveData)this.isDestroyData;
    }

    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + '_' + this.logTag + "$@" + Integer.toHexString(this.hashCode());
    }

    @Override
    @NotNull
    public Context getContext() {
        return this.context;
    }

    @Nullable
    public final ViewModelProvider.Factory getFactory() {
        return this.factory;
    }

    public PageMvpContext(@NotNull Context context, @NotNull String tag, @Nullable ViewModelProvider.Factory factory) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        this.context = context;
        this.factory = factory;
        this.logTag = TAG + '_' + tag;
        this.isDestroyData = new MutableLiveData();
        this.extra = new HashMap();
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"new %s", (Object[])new Object[]{this});
        }
        this.mLifecycleOwner = new SimpleLifeCycleOwner(this.toString());
        this.viewModelStore = new ViewModelStore();
        this.presenterProvider = new PresenterProvider(this, this.getViewModelStore(), this.factory);
        this.onEvent(Lifecycle.Event.ON_CREATE);
        this.onEvent(Lifecycle.Event.ON_START);
    }

    public /* synthetic */ PageMvpContext(Context context, String string, ViewModelProvider.Factory factory, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = TAG;
        }
        if ((n & 4) != 0) {
            factory = null;
        }
        this(context, string, factory);
    }

    protected PageMvpContext(@NotNull Context context, @NotNull String tag) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        this(context, tag, null);
    }

    public /* synthetic */ PageMvpContext(Context context, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = TAG;
        }
        this(context, string);
    }

    protected PageMvpContext(final @NotNull View view, boolean isAutoDestroy) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        Context context = view.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"view.context");
        this(context, null, 2, null);
        if (isAutoDestroy) {
            if (Build.VERSION.SDK_INT >= 19 && view.isAttachedToWindow()) {
                this.mLifecycleOwner.onEvent(Lifecycle.Event.ON_RESUME);
            }
            view.addOnAttachStateChangeListener(new View.OnAttachStateChangeListener(){

                public void onViewAttachedToWindow(@NotNull View v) {
                    Intrinsics.checkParameterIsNotNull((Object)v, (String)"v");
                    mLifecycleOwner.onEvent(Lifecycle.Event.ON_RESUME);
                }

                public void onViewDetachedFromWindow(@NotNull View v) {
                    Intrinsics.checkParameterIsNotNull((Object)v, (String)"v");
                    mLifecycleOwner.onEvent(Lifecycle.Event.ON_DESTROY);
                    view.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
                }
            });
        }
    }

    @Override
    public boolean hasViewModel(@NotNull Class<? extends IMvp.IPresenter> clazz) {
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        return IMvpContext.DefaultImpls.hasViewModel(this, clazz);
    }

    @Override
    @NotNull
    public <P extends ViewModel> P getViewModel(@NotNull Class<P> clazz) {
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        return IMvpContext.DefaultImpls.getViewModel(this, clazz);
    }

    @JvmStatic
    @NotNull
    public static final PageMvpContext of(@NotNull View view) {
        return Companion.of(view);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final PageMvpContext of(@NotNull Context activity, @NotNull String tag) {
        return Companion.of(activity, tag);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final PageMvpContext of(@NotNull Context activity) {
        return com.yy.hiyo.mvp.base.PageMvpContext$Companion.of$default(Companion, activity, null, 2, null);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\u0004H\u0007J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/yy/hiyo/mvp/base/PageMvpContext$Companion;", "", "()V", "TAG", "", "of", "Lcom/yy/hiyo/mvp/base/PageMvpContext;", "activity", "Landroid/content/Context;", "tag", "view", "Landroid/view/View;", "mvvm_release"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final PageMvpContext of(@NotNull View view) {
            Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
            return new PageMvpContext(view, true);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final PageMvpContext of(@NotNull Context activity, @NotNull String tag) {
            Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            return new PageMvpContext(activity, tag);
        }

        public static /* synthetic */ PageMvpContext of$default(Companion companion, Context context, String string, int n, Object object) {
            if ((n & 2) != 0) {
                string = PageMvpContext.TAG;
            }
            return companion.of(context, string);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final PageMvpContext of(@NotNull Context activity) {
            return com.yy.hiyo.mvp.base.PageMvpContext$Companion.of$default(this, activity, null, 2, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

