/*
 * Decompiled with CFR 0.152.
 */
package com.yy.architecture;

import android.app.Application;
import android.content.Context;
import androidx.annotation.NonNull;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LifecycleRegistry;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStore;
import androidx.lifecycle.ViewModelStoreOwner;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.framework.core.ui.DefaultWindow;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.hiyo.mvp.base.IMvpContext;

public class LifecycleWindow2
extends DefaultWindow
implements LifecycleOwner,
ViewModelStoreOwner {
    private Application mApplication;
    private final LifecycleRegistry mLifecycleRegistry = new LifecycleRegistry((LifecycleOwner)this);
    private ViewModelStore mViewModelStore;
    private ViewModelProvider mViewModelProvider;

    public LifecycleWindow2(Context context, UICallBacks callBacks, String name) {
        super(context, callBacks, name);
        this.init(context);
    }

    public LifecycleWindow2(IMvpContext context, UICallBacks callBacks, String name) {
        super(context.getContext(), callBacks, name);
        this.init(context.getContext());
    }

    public LifecycleWindow2(IMvpContext context, UICallBacks callBacks, AbstractWindow.WindowLayerType useLayerType, String name) {
        super(context.getContext(), callBacks, useLayerType, name);
        this.init(context.getContext());
    }

    private void init(Context context) {
        this.mApplication = (Application)context.getApplicationContext();
        this.mLifecycleRegistry.markState(Lifecycle.State.INITIALIZED);
    }

    public void onAttach() {
        super.onAttach();
        this.onCreate();
        this.mLifecycleRegistry.markState(Lifecycle.State.CREATED);
    }

    public void beforeShow() {
        super.beforeShow();
        this.onStart();
        this.mLifecycleRegistry.markState(Lifecycle.State.STARTED);
    }

    public void onShown() {
        super.onShown();
        this.onResume();
        this.mLifecycleRegistry.markState(Lifecycle.State.RESUMED);
    }

    public void beforeHide() {
        this.mLifecycleRegistry.markState(Lifecycle.State.STARTED);
        super.beforeHide();
        this.onPause();
    }

    public void onHidden() {
        this.mLifecycleRegistry.markState(Lifecycle.State.CREATED);
        super.onHidden();
        this.onStop();
    }

    public void onDetached() {
        this.mLifecycleRegistry.markState(Lifecycle.State.DESTROYED);
        super.onDetached();
        this.onDestroy();
        if (this.mViewModelStore != null) {
            this.mViewModelStore.clear();
        }
    }

    protected void onCreate() {
    }

    protected void onStart() {
    }

    protected void onResume() {
    }

    protected void onPause() {
    }

    protected void onStop() {
    }

    protected void onDestroy() {
    }

    @NonNull
    public Lifecycle getLifecycle() {
        return this.mLifecycleRegistry;
    }

    @NonNull
    public ViewModelStore getViewModelStore() {
        if (this.mViewModelStore == null) {
            this.mViewModelStore = new ViewModelStore();
        }
        return this.mViewModelStore;
    }

    public <VM extends ViewModel> VM ofViewModel(Class<VM> vmClass) {
        if (this.mViewModelProvider == null) {
            this.mViewModelProvider = new ViewModelProvider((ViewModelStoreOwner)this, (ViewModelProvider.Factory)new ViewModelProvider.AndroidViewModelFactory(this.mApplication));
        }
        return (VM)this.mViewModelProvider.get(vmClass);
    }
}

