/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.mvp.base.callback;

import androidx.annotation.Nullable;
import androidx.lifecycle.Observer;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.hiyo.mvp.base.ExtensionsKt;
import com.yy.hiyo.mvp.base.callback.IDestroyable;
import java.lang.ref.WeakReference;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;

public class WeakRunnable
implements Runnable,
Observer<Boolean> {
    private Runnable delegate;
    private WeakReference<IDestroyable> reference;

    public static Runnable of(IDestroyable destroyable, Runnable delegate) {
        return new WeakRunnable(destroyable, delegate);
    }

    private WeakRunnable(IDestroyable destroyable, Runnable delegate) {
        this.delegate = delegate;
        this.reference = new WeakReference<IDestroyable>(destroyable);
        ExtensionsKt.onUi((Function0<Unit>)((Function0)() -> {
            destroyable.isDestroyData().observeForever((Observer)this);
            return null;
        }));
    }

    @Override
    public void run() {
        if (this.delegate != null && !this.isDestroy()) {
            this.delegate.run();
        }
        this.onDestroy();
    }

    public void onChanged(@Nullable Boolean isDestroy) {
        if (Boolean.TRUE.equals(isDestroy)) {
            this.onDestroy();
        }
    }

    private void onDestroy() {
        YYTaskExecutor.postToMainThread(() -> {
            IDestroyable destroyable = (IDestroyable)this.reference.get();
            if (destroyable != null) {
                destroyable.isDestroyData().removeObserver((Observer)this);
            }
            this.reference.clear();
            this.delegate = null;
        });
    }

    private boolean isDestroy() {
        IDestroyable destroyable = (IDestroyable)this.reference.get();
        return destroyable == null || Boolean.TRUE.equals(destroyable.isDestroyData().getValue());
    }
}

