/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.mvp.base.callback;

import androidx.annotation.Nullable;
import androidx.lifecycle.Observer;
import com.yy.appbase.common.Callback;
import com.yy.base.logger.MLog;
import com.yy.hiyo.mvp.base.ExtensionsKt;
import com.yy.hiyo.mvp.base.callback.IDestroyable;
import java.lang.ref.WeakReference;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;

public class WeakCallback<T>
implements Callback<T>,
Observer<Boolean> {
    private static final String TAG = "WeakCallback";
    private Callback<T> mCallback;
    @Nullable
    private WeakReference<IDestroyable> mWeakReference;

    private WeakCallback(IDestroyable destroyable, Callback<T> callback2) {
        MLog.debug((Object)TAG, (String)"init destroyable %s, callback %s", (Object[])new Object[]{destroyable, callback2});
        this.mCallback = callback2;
        this.mWeakReference = new WeakReference<IDestroyable>(destroyable);
        ExtensionsKt.onUi((Function0<Unit>)((Function0)() -> {
            destroyable.isDestroyData().observeForever((Observer)this);
            return null;
        }));
    }

    public static <T> WeakCallback<T> of(IDestroyable destroyable, Callback<T> callback2) {
        return new WeakCallback<T>(destroyable, callback2);
    }

    public void onResponse(T data) {
        MLog.debug((Object)TAG, (String)"onResponse", (Object[])new Object[0]);
        if (!this.isDestroy()) {
            if (this.mCallback != null) {
                this.mCallback.onResponse(data);
            }
            this.onDestroy();
        } else {
            MLog.warn((Object)TAG, (String)"onResponse context isDestroy, callback %s, IDestroyable %s", (Object[])new Object[]{this.mCallback, this.mWeakReference != null ? this.mWeakReference.get() : null});
            this.onDestroy();
        }
    }

    public void onChanged(@Nullable Boolean isDestroy) {
        if (this.isDestroy()) {
            MLog.debug((Object)TAG, (String)"onChanged isDestroy", (Object[])new Object[0]);
            this.onDestroy();
        }
    }

    private boolean isDestroy() {
        IDestroyable destroyable = this.mWeakReference != null ? (IDestroyable)this.mWeakReference.get() : null;
        return this.mCallback == null || destroyable == null || destroyable.isDestroyData() == null || Boolean.TRUE.equals(destroyable.isDestroyData().getValue());
    }

    private void onDestroy() {
        IDestroyable destroyable;
        IDestroyable iDestroyable = destroyable = this.mWeakReference != null ? (IDestroyable)this.mWeakReference.get() : null;
        if (destroyable != null && destroyable.isDestroyData() != null) {
            destroyable.isDestroyData().removeObserver((Observer)this);
        }
        if (this.mWeakReference != null) {
            MLog.debug((Object)TAG, (String)"onDestroy IDestroyable %s, callback %s", (Object[])new Object[]{destroyable, this.mCallback});
            this.mWeakReference.clear();
            this.mWeakReference = null;
        }
        this.mCallback = null;
    }
}

