/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.mvp.base;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStore;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.mvp.base.BasePresenter;
import com.yy.hiyo.mvp.base.IMvp;
import com.yy.hiyo.mvp.base.IMvpContext;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;

public class PresenterProvider
extends ViewModelProvider {
    private static final String TAG = "PresenterProvider";
    private HashMap<String, IMvp.IPresenter> mPresenterCache = new HashMap();
    private List<IPresenterCreateListener> mCreateListeners = new ArrayList<IPresenterCreateListener>(2);
    @NonNull
    private IMvpContext mMvpContext;
    @NonNull
    private ViewModelStore mModelStore;
    @Nullable
    private Map<Class<? extends ViewModel>, Class<? extends ViewModel>> interceptor;
    private Function1 onInitInterceptor;

    PresenterProvider(@NotNull IMvpContext mvpContext, @NonNull ViewModelStore store) {
        this(mvpContext, store, new InnerFactory());
    }

    public PresenterProvider(@NotNull IMvpContext mvpContext, @NonNull ViewModelStore store, @Nullable ViewModelProvider.Factory factory) {
        super(store, (ViewModelProvider.Factory)(factory == null ? new InnerFactory() : factory));
        this.mMvpContext = mvpContext;
        this.mModelStore = store;
        if (RuntimeContext.isInGray()) {
            MLog.info((Object)TAG, (String)"new %s", (Object[])new Object[]{this});
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NonNull
    public <T extends ViewModel> T get(@NonNull String key, @NonNull Class<T> clazz) {
        void var4_6;
        Class<? extends ViewModel> interceptClass;
        Class<? extends ViewModel> clazz2 = interceptClass = this.interceptor != null ? this.interceptor.get(clazz) : null;
        if (interceptClass != null) {
            if (!clazz.isAssignableFrom(interceptClass)) throw new IllegalArgumentException(String.format("getPresenter, clazz: %s, is not AssignableFrom, interceptClass: %s", clazz, interceptClass));
            Class<? extends ViewModel> clazz3 = interceptClass;
        } else {
            Class<T> clazz4 = clazz;
        }
        if (!var4_6.getCanonicalName().equals(clazz.getCanonicalName())) {
            return (T)super.get((Class)var4_6);
        }
        ViewModel instance = super.get(key, (Class)var4_6);
        if (!this.mPresenterCache.containsValue(instance) && instance instanceof IMvp.IPresenter) {
            if (this.mMvpContext.isDestroy()) {
                MLog.error((Object)TAG, (Throwable)new IllegalStateException(StringUtils.format((String)"get presenter, contex is destroy, context %s,  name: %s, class: %s", (Object[])new Object[]{this.mMvpContext, key, var4_6})));
            }
            this.mPresenterCache.put(key, (IMvp.IPresenter)instance);
            if (RuntimeContext.sIsDebuggable) {
                MLog.debug((Object)TAG, (String)"\u4fdd\u5b58 presenter, key %s, instance %s", (Object[])new Object[]{key, instance});
            }
            if (instance instanceof BasePresenter) {
                this.onPreInitPresenter(instance);
                ((BasePresenter)instance).onInit(this.mMvpContext);
            }
            for (IPresenterCreateListener listener : this.mCreateListeners) {
                listener.onPresenterCreated((IMvp.IPresenter)instance);
            }
        }
        if (!(instance instanceof BasePresenter) || ((BasePresenter)instance).isInited()) return (T)instance;
        throw new IllegalStateException(String.format("PresenterProvider, presenter \u8fd8\u6ca1\u521d\u59cb\u5316, key %s, class %s, instance %s", key, var4_6, instance));
    }

    <T extends ViewModel> void onPreInitPresenter(T t) {
        if (this.onInitInterceptor != null) {
            this.onInitInterceptor.invoke(t);
        }
    }

    public List<IMvp.IPresenter> getAll() {
        return Collections.unmodifiableList(new ArrayList<IMvp.IPresenter>(this.mPresenterCache.values()));
    }

    public void addCreateListener(@Nullable IPresenterCreateListener createListener) {
        this.mCreateListeners.add(createListener);
    }

    public void setClassInterceptor(@NonNull Function0<? extends Map<Class<? extends ViewModel>, Class<? extends ViewModel>>> interceptor) {
        if (this.interceptor != null && RuntimeContext.sIsDebuggable) {
            throw new IllegalArgumentException(String.format("\u4e0d\u53ef\u4ee5\u91cd\u590d\u8bbe\u7f6e IPresenterClassInterceptor: current %s, new: %s", this.interceptor, interceptor));
        }
        this.interceptor = (Map)interceptor.invoke();
    }

    public void addPresenterInterceptorClass(Map<Class<? extends ViewModel>, Class<? extends ViewModel>> map) {
        if (this.interceptor == null) {
            this.interceptor = new HashMap<Class<? extends ViewModel>, Class<? extends ViewModel>>();
        }
        this.interceptor.putAll(map);
    }

    public void onDestroy() {
        if (RuntimeContext.isInGray()) {
            MLog.info((Object)TAG, (String)"onDestroy %s, list %s", (Object[])new Object[]{this, this.mPresenterCache.values()});
        }
        for (IMvp.IPresenter item : this.mPresenterCache.values()) {
            if (!(item instanceof BasePresenter) || ((BasePresenter)item).isDestroyed()) continue;
            ((BasePresenter)item).onDestroy();
        }
    }

    public void onFinalExit() {
        if (this.isEnableClear()) {
            MLog.info((Object)TAG, (String)"onFinalExit %s,presenter size %d", (Object[])new Object[]{this, this.mPresenterCache.size()});
            this.mModelStore.clear();
            this.mPresenterCache.clear();
        }
    }

    private boolean isEnableClear() {
        return SettingFlags.getBoolean((String)"enableclearpresenter", (boolean)true);
    }

    public void onInitInterceptor(Function1 onInitInterceptor) {
        this.onInitInterceptor = onInitInterceptor;
    }

    public static interface IPresenterCreateListener {
        public void onPresenterCreated(IMvp.IPresenter var1);
    }

    private static class InnerFactory
    implements ViewModelProvider.Factory {
        private InnerFactory() {
        }

        @NonNull
        public <T extends ViewModel> T create(@NonNull Class<T> modelClass) {
            try {
                Constructor<T> constructor;
                if (RuntimeContext.sIsDebuggable) {
                    MLog.debug((Object)PresenterProvider.TAG, (String)"create presenter %s", (Object[])new Object[]{modelClass});
                }
                if (!(constructor = modelClass.getDeclaredConstructor(new Class[0])).isAccessible()) {
                    constructor.setAccessible(true);
                }
                return (T)((ViewModel)constructor.newInstance(new Object[0]));
            }
            catch (Exception e) {
                throw new RuntimeException("PresenterProvider \u521b\u5efa presenter\u5f02\u5e38\uff0cclass " + modelClass, e);
            }
        }
    }
}

