/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.mvp.base;

import android.content.Context;
import androidx.fragment.app.FragmentActivity;
import com.yy.appbase.core.DefaultController;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.framework.core.Environment;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.framework.core.ui.DeviceManager;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.hiyo.mvp.base.IMvpContext;
import com.yy.hiyo.mvp.base.PageMvpContext;

public abstract class MvpController
extends DefaultController {
    private static final String TAG = "MvpController";
    private IMvpContext mMvpContext;
    private boolean mMvpContextDestroyed;

    public MvpController(Environment env) {
        super(env);
    }

    public FragmentActivity getContext() {
        return this.getActivity();
    }

    public DeviceManager getDeviceManager() {
        return this.mDeviceMgr;
    }

    public void setEnvironment(Environment baseEnv) {
        super.setEnvironment(baseEnv);
        if (this.autoManageContext()) {
            this.destroyMvpContext();
            this.mMvpContextDestroyed = false;
            this.newMvpContextInstance();
        }
    }

    public DialogLinkManager getDialogLinkManager() {
        return this.mDialogLinkManager;
    }

    public void onWindowDetach(AbstractWindow abstractWindow) {
        super.onWindowDetach(abstractWindow);
        if (this.autoManageContext()) {
            this.destroyMvpContext();
            this.mMvpContextDestroyed = false;
            this.newMvpContextInstance();
        }
    }

    protected void newMvpContextInstance() {
        if (this.getContext() == null || this.getContext().isDestroyed() || this.getContext().isFinishing()) {
            MLog.error((Object)TAG, (String)"newMvpContextInstance activity is destroy", (Object[])new Object[0]);
            return;
        }
        MLog.info((Object)TAG, (String)"newMvpContextInstance %s", (Object[])new Object[]{this.mMvpContext});
        if (RuntimeContext.sIsDebuggable && this.mMvpContext != null && !this.mMvpContext.isDestroy()) {
            MLog.error((Object)TAG, (Throwable)new IllegalStateException("newMvpContextInstance \u4e0a\u4e00\u4e2aIMvpContext\u6ca1\u6709\u6b63\u786e\u9500\u6bc1"));
            throw new IllegalStateException("newMvpContextInstance \u4e0a\u4e00\u4e2aIMvpContext\u6ca1\u6709\u6b63\u786e\u9500\u6bc1");
        }
        this.mMvpContext = PageMvpContext.Companion.of((Context)this.getContext());
    }

    protected IMvpContext getMvpContext() {
        if (this.mMvpContext == null && !this.mMvpContextDestroyed) {
            this.newMvpContextInstance();
        }
        return this.mMvpContext;
    }

    protected boolean autoManageContext() {
        return true;
    }

    protected void destroyMvpContext() {
        MLog.info((Object)TAG, (String)"destroyMvpContext %s", (Object[])new Object[]{this.mMvpContext});
        this.mMvpContext = null;
        this.mMvpContextDestroyed = true;
    }
}

