/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.mvp.base;

import android.os.SystemClock;
import androidx.annotation.NonNull;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.hiyo.mvp.base.INotifyDispatchService;
import com.yy.hiyo.proto.callback.IProtoNotify;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class AbsNotifyDispatchService<T>
implements INotifyDispatchService<T>,
IProtoNotify<T> {
    private List<INotifyDispatchService.INotifyHandler> mNotifyHandlers;
    private final Object mLockhandlers = new Object();
    private ArrayList<T> mCachedNotifys = new ArrayList();
    private volatile long mLastNotifyTime = -1L;
    private Runnable mHandleCachedNotifyRunnable = null;
    private volatile long mLastDelayTime = 0L;

    public AbsNotifyDispatchService() {
        this.mNotifyHandlers = new CopyOnWriteArrayList<INotifyDispatchService.INotifyHandler>();
    }

    private void dispatch(ArrayList<T> notifys) {
        if (notifys == null || notifys.isEmpty()) {
            return;
        }
        for (T notify : notifys) {
            this.dispatch(notify);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatch(T notify) {
        Object object = this.mLockhandlers;
        synchronized (object) {
            for (INotifyDispatchService.INotifyHandler item : this.mNotifyHandlers) {
                item.onHandleNotify(notify);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addHandler(INotifyDispatchService.INotifyHandler<T> handler) {
        Object object = this.mLockhandlers;
        synchronized (object) {
            if (handler != null && !this.mNotifyHandlers.contains(handler)) {
                this.mNotifyHandlers.add(handler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeHandler(INotifyDispatchService.INotifyHandler<T> handler) {
        Object object = this.mLockhandlers;
        synchronized (object) {
            if (handler != null) {
                this.mNotifyHandlers.remove(handler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.mLockhandlers;
        synchronized (object) {
            if (this.mNotifyHandlers != null) {
                this.mNotifyHandlers.clear();
            }
        }
    }

    public abstract String serviceName();

    public void onNotify(@NonNull T notify) {
        if (!this.isValid(notify)) {
            return;
        }
        long refreshTimeMaxGap = 20L;
        long curTime = SystemClock.uptimeMillis();
        long timeGap = curTime - this.mLastNotifyTime;
        long delayTime = 0L;
        if (curTime > 0L && this.mLastNotifyTime > 0L && timeGap >= 0L && timeGap < refreshTimeMaxGap) {
            if (timeGap > 0L) {
                delayTime = refreshTimeMaxGap - timeGap;
            } else if (timeGap == 0L) {
                delayTime = this.mLastDelayTime > 0L ? this.mLastDelayTime : refreshTimeMaxGap;
            }
            if (delayTime > refreshTimeMaxGap) {
                delayTime = refreshTimeMaxGap;
            }
            this.mLastDelayTime = delayTime;
        } else {
            this.mLastDelayTime = delayTime;
        }
        if (this.mHandleCachedNotifyRunnable != null) {
            YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mHandleCachedNotifyRunnable);
        } else {
            this.mHandleCachedNotifyRunnable = new Runnable(){

                @Override
                public void run() {
                    AbsNotifyDispatchService.this.mLastNotifyTime = SystemClock.uptimeMillis();
                    ArrayList msgToHangle = new ArrayList(AbsNotifyDispatchService.this.mCachedNotifys.size());
                    msgToHangle.addAll(AbsNotifyDispatchService.this.mCachedNotifys);
                    AbsNotifyDispatchService.this.dispatch((Object)msgToHangle);
                    AbsNotifyDispatchService.this.mCachedNotifys.clear();
                }
            };
        }
        if (delayTime > 0L) {
            this.mCachedNotifys.add(notify);
            YYTaskExecutor.postToMainThread((Runnable)this.mHandleCachedNotifyRunnable, (long)delayTime);
        } else if (this.mCachedNotifys.size() > 0) {
            this.mCachedNotifys.add(notify);
            this.mHandleCachedNotifyRunnable.run();
        } else {
            this.mLastNotifyTime = SystemClock.uptimeMillis();
            this.dispatch(notify);
        }
    }

    protected abstract boolean isValid(T var1);
}

