/*
 * Decompiled with CFR 0.152.
 */
package com.yy.architecture;

import android.annotation.SuppressLint;
import androidx.annotation.NonNull;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleOwner;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.framework.core.ui.DefaultWindow;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.hiyo.mvp.base.IMvpContext;

@SuppressLint(value={"ViewConstructor"})
public class LifecycleWindow
extends DefaultWindow
implements LifecycleOwner {
    private IMvpContext mMvpContext;
    private boolean destroyWhenDetach = true;

    public LifecycleWindow(IMvpContext mvpContext, UICallBacks callBacks, String name) {
        super(mvpContext.getContext(), callBacks, name);
        this.init(mvpContext);
    }

    public LifecycleWindow(IMvpContext mvpContext, UICallBacks callBacks, AbstractWindow.WindowLayerType useLayerType, String name) {
        super(mvpContext.getContext(), callBacks, useLayerType, name);
        this.init(mvpContext);
    }

    private void init(IMvpContext mvpContext) {
        this.mMvpContext = mvpContext;
        this.mMvpContext.getLifecycleOwner().onEvent(Lifecycle.Event.ON_CREATE);
    }

    public void onAttach() {
        super.onAttach();
        this.mMvpContext.getLifecycleOwner().onEvent(Lifecycle.Event.ON_START);
    }

    public void onShown() {
        super.onShown();
        this.mMvpContext.getLifecycleOwner().onEvent(Lifecycle.Event.ON_RESUME);
    }

    public void beforeHide() {
        super.beforeHide();
        this.mMvpContext.getLifecycleOwner().onEvent(Lifecycle.Event.ON_PAUSE);
    }

    public void onHidden() {
        super.onHidden();
        this.mMvpContext.getLifecycleOwner().onEvent(Lifecycle.Event.ON_STOP);
    }

    public void onDetached() {
        super.onDetached();
        if (this.destroyWhenDetach) {
            this.mMvpContext.getLifecycleOwner().onEvent(Lifecycle.Event.ON_DESTROY);
        }
    }

    public void setDestroyWhenDetach(boolean destroyWhenDetach) {
        this.destroyWhenDetach = destroyWhenDetach;
    }

    @NonNull
    public Lifecycle getLifecycle() {
        return this.mMvpContext.getLifecycle();
    }

    public IMvpContext getMvpContext() {
        return this.mMvpContext;
    }
}

