/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.moduleloader;

import android.content.Intent;
import androidx.fragment.app.FragmentActivity;
import com.duowan.hago.party.moduleproxy.PartySdkModuleLoader;
import com.yy.appbase.core.AbsFirstOrderModuleLoader;
import com.yy.appbase.core.AbsModuleLoader;
import com.yy.appbase.core.AbsSecondOrderModuleLoader;
import com.yy.appbase.core.AbsThreeOrderModuleLoader;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.LanguageUtils;
import com.yy.framework.core.Environment;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.hiyo.main.base.IModuleLoader;
import com.yy.hiyo.main.base.IModuleLoaderManager;
import com.yy.hiyo.main.base.InitModuleCallback;
import com.yy.hiyo.moduleloader.HagoModuleLoader;
import com.yy.hiyo.moduleloader.IModuleNotFoundCallback;
import com.yy.hiyo.moduleloader.ModuleNotFoundHandle;
import com.yy.hiyo.moduleloader.wrapper.SocialPlatformWrapper;
import java.util.HashMap;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ModuleLoadersManager
implements IModuleLoaderManager,
InitModuleCallback {
    private static final String TAG = "ModuleLoadersManager";
    private HashMap<String, AbsModuleLoader> mModulers;
    private boolean mAfterEnvInit = false;
    private boolean mAfterStartup = false;
    private boolean mAfterStartupOneSecond = false;
    private boolean mAfterStartupThreeSecond = false;
    private boolean mAfterStartupFiveSecond = false;
    private boolean mHasLoadAll = false;
    private Environment mEnvironment;
    private ModuleNotFoundHandle mModuleNotFoundHandle;
    private final IModuleLoader mModuleLoader;

    public ModuleLoadersManager(Environment env) {
        this.mEnvironment = env;
        this.mModuleLoader = new PartySdkModuleLoader((IModuleLoader)new HagoModuleLoader(this), (InitModuleCallback)this);
    }

    public void onMsgHanderNotFind(int msgId) {
        this.getModuleNotFoundHandle().onMsgHanderNotFind(msgId);
    }

    public void onServiceNotFind(Class serviceClass) {
        this.getModuleNotFoundHandle().onServiceNotFind(serviceClass);
    }

    public synchronized void ensureKvoModuleRegister() {
        this.notifyModuleEvent(AbsFirstOrderModuleLoader.ENSURE_KVO_MODULE);
    }

    public synchronized void afterEnvInit() {
        if (this.mAfterEnvInit) {
            return;
        }
        this.mModuleLoader.afterEnvInit();
        this.notifyModuleEvent(AbsFirstOrderModuleLoader.AFTER_ENV_INIT);
        this.mAfterEnvInit = true;
        RuntimeContext.sIsModuleAfterEnvInit = true;
        NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationDef.MODULE_AFTER_ENV_INIT));
    }

    public synchronized void initModuleDeforeStartup() {
        this.mModuleLoader.initModuleDeforeStartup();
    }

    public synchronized void initModuleAfterStartup() {
        if (this.mAfterStartup) {
            return;
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"initModuleAfterStartup!", (Object[])new Object[0]);
        }
        this.mModuleLoader.initModuleAfterStartup();
        this.notifyModuleEvent(AbsSecondOrderModuleLoader.AFTER_STARTUP);
        this.mAfterStartup = true;
        if (LanguageUtils.isRussian() || RuntimeContext.sIsDebuggable) {
            YYTaskExecutor.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    SocialPlatformWrapper.preInitSdk();
                }
            });
        }
    }

    public synchronized void initModuleAfterStartupOneSecond() {
        if (this.mAfterStartupOneSecond) {
            return;
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"initModuleAfterStartupOneSecond!", (Object[])new Object[0]);
        }
        this.mModuleLoader.initModuleAfterStartupOneSecond();
        this.notifyModuleEvent(AbsThreeOrderModuleLoader.AFTER_STARTUP_ONE_SECOND);
        this.mAfterStartupOneSecond = true;
    }

    public synchronized void initModuleAfterStartupThreeSecond() {
        if (this.mAfterStartupThreeSecond) {
            return;
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"initModuleAfterStartupThreeSecond!", (Object[])new Object[0]);
        }
        this.mModuleLoader.initModuleAfterStartupThreeSecond();
        this.notifyModuleEvent(AbsFirstOrderModuleLoader.AFTER_STARTUP_THREE_SECOND);
        this.mAfterStartupThreeSecond = true;
    }

    public synchronized void initModuleAfterStartupFiveSecond() {
        if (this.mAfterStartupFiveSecond) {
            return;
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"initModuleAfterStartupFiveSecond!", (Object[])new Object[0]);
        }
        this.mModuleLoader.initModuleAfterStartupFiveSecond();
        this.notifyModuleEvent(AbsFirstOrderModuleLoader.AFTER_STARTUP_FIVE_SECOND);
        this.mAfterStartupFiveSecond = true;
    }

    public synchronized void initModuleAfterStartupTenSecond() {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"initModuleAfterStartupTenSecond!", (Object[])new Object[0]);
        }
        this.mModuleLoader.initModuleAfterStartupTenSecond();
        this.notifyModuleEvent(AbsFirstOrderModuleLoader.AFTER_STARTUP_TEN_SECOND);
        this.mHasLoadAll = true;
    }

    private synchronized void notifyModuleEvent(int event) {
        Set<String> keys = this.mModulers.keySet();
        for (String key : keys) {
            this.mModulers.get(key).handleTimeEvent(event);
        }
    }

    public synchronized void initModuleLoader(String className, AbsModuleLoader moduleLoader) {
        if (this.mModulers == null) {
            this.mModulers = new HashMap();
        }
        if (moduleLoader == null) {
            return;
        }
        if (this.mModulers.get(className) != null) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"hasLoaded:%s", (Object[])new Object[]{className});
            }
            return;
        }
        this.mModulers.put(className, moduleLoader);
    }

    public void onMainActivityCreate(FragmentActivity activity) {
        SocialPlatformWrapper.onMainActivityCreate(activity);
    }

    public void onMainActivityCreated() {
        SocialPlatformWrapper.onMainActivityCreated();
    }

    public void onMainActivityDestroy() {
        SocialPlatformWrapper.onMainActivityDestroy();
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        SocialPlatformWrapper.onActivityResult(requestCode, resultCode, data);
    }

    private ModuleNotFoundHandle getModuleNotFoundHandle() {
        if (this.mModuleNotFoundHandle == null) {
            this.mModuleNotFoundHandle = new ModuleNotFoundHandle(this, new IModuleNotFoundCallback(){

                @Override
                public boolean isLoadAllFinish() {
                    return ModuleLoadersManager.this.mHasLoadAll;
                }

                @Override
                public boolean isAfterEnvInit() {
                    return ModuleLoadersManager.this.mAfterEnvInit;
                }
            });
        }
        return this.mModuleNotFoundHandle;
    }

    @NotNull
    public Environment getEnv() {
        return this.mEnvironment;
    }
}

