/*
 * Decompiled with CFR 0.152.
 */
package com.chinanetcenter.wcs.android.utils;

import com.chinanetcenter.wcs.android.utils.EncodeUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;

public class WetagUtil {
    private static final int BLOCK_BITS = 22;
    private static final int BLOCK_SIZE = 0x400000;
    private static final byte BYTE_LOW_4 = 22;
    private static final byte BYTE_OVER_4 = -106;

    private static long blockCount(long fileLength) {
        return fileLength + 0x3FFFFFL >> 22;
    }

    private static MessageDigest calSha1(BufferedInputStream fis) {
        MessageDigest sha1 = null;
        try {
            byte[] buffer = new byte[1024];
            int numRead = 0;
            int total = 0;
            sha1 = MessageDigest.getInstance("SHA-1");
            while ((numRead = fis.read(buffer)) > 0) {
                sha1.update(buffer, 0, numRead);
                if ((total += numRead) < 0x400000) continue;
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sha1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getEtagHash(File file) {
        String etagHash;
        block20: {
            etagHash = null;
            BufferedInputStream fis = null;
            try {
                if (!file.exists()) break block20;
                byte[] ret = new byte[21];
                long blockCount = WetagUtil.blockCount(file.length());
                fis = new BufferedInputStream(new FileInputStream(file));
                if (blockCount <= 1L) {
                    MessageDigest sha1 = WetagUtil.calSha1(fis);
                    if (null != sha1) {
                        byte[] input = sha1.digest();
                        ret[0] = 22;
                        for (int i = 0; i < 20; ++i) {
                            ret[i + 1] = input[i];
                        }
                    }
                } else {
                    byte[] tmp;
                    MessageDigest sha1;
                    byte[] rec = new byte[(int)blockCount * 20];
                    ret[0] = -106;
                    int cnt = 0;
                    int i = 0;
                    while ((long)i < blockCount) {
                        sha1 = WetagUtil.calSha1(fis);
                        if (null != sha1) {
                            tmp = sha1.digest();
                            for (int j = 0; j < 20; ++j) {
                                rec[cnt++] = tmp[j];
                            }
                        }
                        ++i;
                    }
                    sha1 = MessageDigest.getInstance("SHA-1");
                    sha1.update(rec, 0, (int)blockCount * 20);
                    tmp = sha1.digest();
                    for (i = 0; i < 20; ++i) {
                        ret[i + 1] = tmp[i];
                    }
                }
                etagHash = EncodeUtils.urlsafeEncodeString(ret);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (fis != null) {
                        fis.close();
                        fis = null;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return etagHash;
    }

    public static String getEtagHash(String filePath, String fileName) {
        return WetagUtil.getEtagHash(new File(filePath, fileName));
    }

    public static String getEtagHash(String filePath) {
        return WetagUtil.getEtagHash(new File(filePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getEtagHash(InputStream fileInputStream, long fileLength) {
        String etagHash = null;
        BufferedInputStream fis = null;
        try {
            byte[] ret = new byte[21];
            long blockCount = WetagUtil.blockCount(fileLength);
            fis = new BufferedInputStream(fileInputStream);
            if (blockCount <= 1L) {
                MessageDigest sha1 = WetagUtil.calSha1(fis);
                if (null != sha1) {
                    byte[] input = sha1.digest();
                    ret[0] = 22;
                    for (int i = 0; i < 20; ++i) {
                        ret[i + 1] = input[i];
                    }
                }
            } else {
                byte[] tmp;
                MessageDigest sha1;
                byte[] rec = new byte[(int)blockCount * 20];
                ret[0] = -106;
                int cnt = 0;
                int i = 0;
                while ((long)i < blockCount) {
                    sha1 = WetagUtil.calSha1(fis);
                    if (null != sha1) {
                        tmp = sha1.digest();
                        for (int j = 0; j < 20; ++j) {
                            rec[cnt++] = tmp[j];
                        }
                    }
                    ++i;
                }
                sha1 = MessageDigest.getInstance("SHA-1");
                sha1.update(rec, 0, (int)blockCount * 20);
                tmp = sha1.digest();
                for (i = 0; i < 20; ++i) {
                    ret[i + 1] = tmp[i];
                }
            }
            etagHash = EncodeUtils.urlsafeEncodeString(ret);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                    fis = null;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return etagHash;
    }

    private static MessageDigest calSha1(byte[] data) {
        MessageDigest sha1 = null;
        try {
            sha1 = MessageDigest.getInstance("SHA-1");
            sha1.update(data);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sha1;
    }

    public static String getEtagHash(byte[] data) {
        String etagHash = null;
        try {
            byte[] ret = new byte[21];
            MessageDigest sha1 = WetagUtil.calSha1(data);
            if (null != sha1) {
                byte[] input = sha1.digest();
                ret[0] = 22;
                for (int i = 0; i < 20; ++i) {
                    ret[i + 1] = input[i];
                }
            }
            etagHash = EncodeUtils.urlsafeEncodeString(ret);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return etagHash;
    }
}

