/*
 * Decompiled with CFR 0.152.
 */
package com.chinanetcenter.wcs.android.slice;

import android.util.Log;
import com.chinanetcenter.wcs.android.slice.ByteArray;
import com.chinanetcenter.wcs.android.slice.Slice;
import com.chinanetcenter.wcs.android.utils.WCSLogUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public class Block {
    private static final int PER_SLICE_SIZE = 65536;
    private static final int MAX_BLOCK_SIZE = 0x6400000;
    private static final int DEFAULT_BLOCK_SIZE = 0x400000;
    private static final int DEFAULT_SLICE_SIZE = 262144;
    private static int sDefaultSliceSize = 262144;
    private static long sDefaultBlockSize = 0x400000L;
    private RandomAccessFile mRandomAccessFile;
    private long mStart;
    private long mSize;
    private int mSliceSize;
    private int mSliceIndex;
    private long mOriginalFileSize;
    private String mFileName;
    private ByteArray mByteArray;

    public ByteArray getByteArray() {
        return this.mByteArray;
    }

    public void setByteArray(ByteArray byteArray) {
        this.mByteArray = byteArray;
    }

    Block(RandomAccessFile randomAccessFile, String fileName, long start, long blockSize, int sliceSize) throws IOException {
        this.mRandomAccessFile = randomAccessFile;
        this.mOriginalFileSize = randomAccessFile.length();
        this.mFileName = fileName;
        this.mStart = start;
        this.mSize = blockSize;
        this.mSliceSize = sliceSize;
    }

    public static Block[] blocks(File file) {
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(file, "r");
        }
        catch (FileNotFoundException e) {
            Log.e((String)"CNCLog", (String)("file not found : " + file));
            return null;
        }
        long fileSize = 0L;
        try {
            fileSize = randomAccessFile.length();
        }
        catch (IOException e) {
            WCSLogUtil.e(e.getMessage());
        }
        if (fileSize == 0L) {
            try {
                randomAccessFile.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            return null;
        }
        int blockCount = (int)((fileSize + sDefaultBlockSize - 1L) / sDefaultBlockSize);
        WCSLogUtil.d(String.format(Locale.CHINA, "file size : %s, block count : %s", fileSize, blockCount));
        Block[] blocks = new Block[blockCount];
        long blockSize = sDefaultBlockSize;
        for (int i = 0; i < blockCount; ++i) {
            if (i + 1 == blockCount) {
                long remain = fileSize % sDefaultBlockSize;
                blockSize = remain == 0L ? sDefaultBlockSize : remain;
            }
            try {
                blocks[i] = new Block(randomAccessFile, file.getName(), (long)i * sDefaultBlockSize, blockSize, sDefaultSliceSize);
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return blocks;
    }

    public void clear() {
        try {
            this.mRandomAccessFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void releaseBuffer() {
        if (this.mByteArray != null) {
            this.mByteArray.clear();
        }
    }

    public Slice moveToNext() {
        return this.getSlice(this.mSliceIndex++);
    }

    public void setIndex(int index) {
        this.mSliceIndex = index;
    }

    public int getIndex() {
        return this.mSliceIndex;
    }

    public Slice moveToIndex(int index) {
        this.mSliceIndex = index;
        return this.moveToNext();
    }

    public Slice lastSlice() {
        return this.getSlice(this.mSliceIndex - 1);
    }

    private Slice getSlice(int index) {
        if (this.mByteArray == null) {
            this.mByteArray = new ByteArray(this.getSliceSize());
        }
        long offset = this.mStart + (long)(index * this.getSliceSize());
        if ((long)(index * this.getSliceSize()) >= this.mSize) {
            return null;
        }
        int sliceSize = this.getSliceSize();
        if (offset + (long)this.getSliceSize() > this.mStart + this.mSize) {
            sliceSize = (int)(this.mSize % (long)this.getSliceSize());
        }
        byte[] sliceData = this.mByteArray.toBuffer();
        Arrays.fill(sliceData, (byte)0);
        if (sliceSize < this.getSliceSize()) {
            sliceData = new byte[sliceSize];
        }
        try {
            this.mRandomAccessFile.seek(offset);
            this.mRandomAccessFile.read(sliceData, 0, sliceSize);
            WCSLogUtil.d("offset : " + offset + "; slice size : " + sliceSize);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (sliceSize < this.getSliceSize()) {
            return new Slice((long)(index * this.getSliceSize()), sliceData);
        }
        return new Slice((long)(index * this.getSliceSize()), this.mByteArray);
    }

    public long size() {
        return this.mSize;
    }

    public int getSliceSize() {
        return this.mSliceSize;
    }

    public String toString() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("start", this.mStart);
            jsonObject.put("size", this.mSize);
            jsonObject.put("slice index", this.mSliceIndex);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        try {
            return jsonObject.toString(4);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return "Block<>";
        }
    }

    public long getOriginalFileSize() {
        return this.mOriginalFileSize;
    }

    public String getOriginalFileName() {
        return this.mFileName;
    }

    public static void setBlockSize(int size) {
        if ((size = size * 1024 * 1024) <= 0 || (long)size % sDefaultBlockSize != 0L || size > 0x6400000) {
            sDefaultBlockSize = 0x400000L;
            return;
        }
        sDefaultBlockSize = size;
        WCSLogUtil.d("block size: " + sDefaultBlockSize);
    }

    public static void setSliceSize(int size) {
        if ((size *= 1024) <= 0 || size % 65536 != 0 || (long)size > sDefaultBlockSize) {
            sDefaultSliceSize = 262144;
            return;
        }
        sDefaultSliceSize = size;
        WCSLogUtil.d("slice size: " + sDefaultSliceSize);
    }
}

