/*
 * Decompiled with CFR 0.152.
 */
package com.chinanetcenter.wcs.android.internal;

import com.chinanetcenter.wcs.android.exception.ClientException;
import com.chinanetcenter.wcs.android.exception.ServiceException;
import com.chinanetcenter.wcs.android.utils.WCSLogUtil;
import java.io.InterruptedIOException;
import java.net.SocketTimeoutException;
import javax.net.ssl.SSLException;

public class WcsRetryHandler {
    private int maxRetryCount = 2;

    public int getMaxRetryCount() {
        return this.maxRetryCount;
    }

    public void setMaxRetryCount(int maxRetryCount) {
        this.maxRetryCount = maxRetryCount;
    }

    public WcsRetryHandler() {
    }

    public WcsRetryHandler(int maxRetryCount) {
        this.maxRetryCount = maxRetryCount;
    }

    public boolean shouldRetry(Exception e, int currentRetryCount) {
        if (currentRetryCount >= this.maxRetryCount) {
            return false;
        }
        if (e instanceof ClientException) {
            if (((ClientException)e).isCanceledException().booleanValue()) {
                return false;
            }
            Exception localException = (Exception)e.getCause();
            if (localException instanceof InterruptedIOException && !(localException instanceof SocketTimeoutException)) {
                WCSLogUtil.e("[shouldRetry] - is interrupted!");
                return false;
            }
            if (localException instanceof IllegalArgumentException) {
                return false;
            }
            if (localException instanceof SSLException) {
                return false;
            }
            WCSLogUtil.d("shouldRetry - " + e.toString());
            e.getCause().printStackTrace();
            return true;
        }
        if (e instanceof ServiceException) {
            ServiceException serviceException = (ServiceException)e;
            return serviceException.getStatusCode() == 408 || serviceException.getStatusCode() >= 500 && serviceException.getStatusCode() != 579;
        }
        return false;
    }
}

