/*
 * Decompiled with CFR 0.152.
 */
package com.chinanetcenter.wcs.android.api;

import com.chinanetcenter.wcs.android.listener.SliceUploaderListener;
import com.chinanetcenter.wcs.android.utils.WCSLogUtil;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicLong;

public class ProgressNotifier {
    private SliceUploaderListener mUploaderListener;
    private long mTotal;
    private AtomicLong mWritten;

    public ProgressNotifier(long total, SliceUploaderListener uploaderListener) {
        this.mUploaderListener = uploaderListener;
        this.mTotal = total;
        this.mWritten = new AtomicLong();
    }

    public void decreaseProgress(long decrease) {
        this.mWritten.addAndGet(-decrease);
    }

    public void increaseProgressAndNotify(long written) {
        this.mWritten.addAndGet(written);
        if (this.mWritten.get() <= this.mTotal) {
            this.mUploaderListener.onProgress(this.mWritten.get(), this.mTotal);
        } else {
            WCSLogUtil.w(String.format(Locale.CHINA, "written (%d) greater than total (%d)", this.mWritten.get(), this.mTotal));
            this.mUploaderListener.onProgress(this.mTotal, this.mTotal);
        }
    }
}

