/*
 * Decompiled with CFR 0.152.
 */
package com.chinanetcenter.wcs.android.api;

import android.content.Context;
import android.text.TextUtils;
import com.chinanetcenter.wcs.android.ClientConfig;
import com.chinanetcenter.wcs.android.LogRecorder;
import com.chinanetcenter.wcs.android.internal.InternalRequest;
import com.chinanetcenter.wcs.android.network.WcsResult;
import com.chinanetcenter.wcs.android.utils.EncodeUtils;
import com.chinanetcenter.wcs.android.utils.WCSLogUtil;
import org.json.JSONException;
import org.json.JSONObject;

public class BaseApi {
    static final String FORM_TOKEN = "token";
    private static volatile InternalRequest mInternalRequest;
    private static final Object mObject;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized InternalRequest getInternalRequest(Context context, ClientConfig config) {
        Object object = mObject;
        synchronized (object) {
            if (null == mInternalRequest) {
                mInternalRequest = new InternalRequest(config == null ? ClientConfig.getDefaultConf() : config);
            }
            if (context != null) {
                LogRecorder.getInstance().setup(context.getApplicationContext());
            }
        }
        return mInternalRequest;
    }

    static boolean isNetworkReachable() {
        return true;
    }

    public static JSONObject parseWCSUploadResponse(WcsResult result) throws JSONException {
        WCSLogUtil.d("parsing upload response : " + result.getResponse());
        JSONObject responseJsonObject = null;
        try {
            responseJsonObject = new JSONObject(result.getResponse());
        }
        catch (JSONException e) {
            WCSLogUtil.d("Try serializing as json failured, response may encoded.");
        }
        if (null == responseJsonObject) {
            responseJsonObject = new JSONObject();
            if (!TextUtils.isEmpty((CharSequence)result.getResponse())) {
                try {
                    String[] params;
                    String response = EncodeUtils.urlsafeDecodeString(result.getResponse());
                    WCSLogUtil.d("response string : " + response);
                    for (String param : params = response.split("&")) {
                        int index = param.indexOf("=");
                        if (index <= 0) continue;
                        responseJsonObject.put(param.substring(0, index), (Object)param.substring(index + 1));
                    }
                }
                catch (IllegalArgumentException e) {
                    WCSLogUtil.d("bad base-64");
                    responseJsonObject.put("headers", (Object)result.getHeaders());
                }
            }
        }
        return responseJsonObject;
    }

    static {
        mObject = new Object();
    }
}

