/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.mixmodule.whatsappsticker.utils;

import com.yy.base.logger.MLog;
import com.yy.base.utils.FP;
import com.yy.base.utils.filestorage.FileStorageUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.hiyo.mixmodule.base.whatsappsticker.bean.Sticker;
import com.yy.hiyo.mixmodule.base.whatsappsticker.bean.StickerPack;
import java.io.File;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class StickerUtils {
    public static final String ROOT_DIR = "sticker";
    private static final String TAG = "StickerUtils";
    private static final String DATA_FILE = "content.txt";
    private static final String IMG_DIR = "img";

    public static String getImageFileDirPath(String identifier) {
        String rootPath = FileStorageUtils.getInstance().getDirAndCreate(false, ROOT_DIR).getAbsolutePath();
        String filePath = rootPath + File.separator + IMG_DIR + File.separator + identifier;
        return filePath;
    }

    public static String getStickerRootDirPath() {
        String rootPath = FileStorageUtils.getInstance().getDirAndCreate(false, ROOT_DIR).getAbsolutePath();
        return rootPath;
    }

    public static String getStickerLocalDataFilePath() {
        String rootPath = FileStorageUtils.getInstance().getDirAndCreate(false, ROOT_DIR).getAbsolutePath();
        String filePath = rootPath + File.separator + DATA_FILE;
        return filePath;
    }

    public static StickerPack parseStickerContent(String content) {
        if (FP.empty((CharSequence)content)) {
            return null;
        }
        StickerPack stickerPack = null;
        try {
            JSONObject pack = JsonParser.obtainJSONObject((String)content);
            stickerPack = new StickerPack();
            stickerPack.androidPlayStoreLink = pack.optString("android_play_store_link");
            stickerPack.identifier = pack.optString("identifier");
            stickerPack.name = pack.optString("name");
            stickerPack.publisher = pack.optString("publisher");
            stickerPack.trayImageFile = pack.optString("tray_image_file");
            stickerPack.trayImageUrl = pack.optString("tray_image_url");
            stickerPack.publisherEmail = pack.optString("publisher_email");
            stickerPack.publisherWebsite = pack.optString("publisher_website");
            stickerPack.privacyPolicyWebsite = pack.optString("privacy_policy_website");
            stickerPack.licenseAgreementWebsite = pack.optString("license_agreement_website");
            stickerPack.stickers = new ArrayList();
            JSONArray stickers = pack.optJSONArray("stickers");
            if (stickers != null) {
                for (int j = 0; j < stickers.length(); ++j) {
                    JSONObject json = stickers.getJSONObject(j);
                    Sticker sticker = new Sticker();
                    sticker.imageFile = json.optString("image_file");
                    sticker.downloadUrl = json.optString("download_url");
                    if (FP.empty((CharSequence)sticker.imageFile) || FP.empty((CharSequence)sticker.downloadUrl)) {
                        MLog.info((Object)TAG, (String)"parseStickerContent Sticker error imageFileName: %s  downloadUrl: %s", (Object[])new Object[]{sticker.imageFile, sticker.downloadUrl});
                        continue;
                    }
                    stickerPack.stickers.add(sticker);
                }
            }
            if (!MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)TAG, (String)("parseStickerContent stickerPack: " + stickerPack), (Object[])new Object[0]);
            }
        }
        catch (JSONException e) {
            MLog.info((Object)TAG, (String)"parseStickerContent ex: %s", (Object[])new Object[]{e});
        }
        return stickerPack;
    }
}

