/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.mixmodule.whatsappsticker.download;

import androidx.annotation.NonNull;
import com.yy.appbase.http.HttpUtil;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.grace.Call;
import com.yy.grace.Callback;
import com.yy.grace.Response;
import com.yy.hiyo.mixmodule.base.whatsappsticker.bean.Sticker;
import com.yy.hiyo.mixmodule.base.whatsappsticker.bean.StickerPack;
import com.yy.hiyo.mixmodule.whatsappsticker.download.IDownLoadListener;
import com.yy.hiyo.mixmodule.whatsappsticker.download.StickerDownloadInfo;
import com.yy.hiyo.mixmodule.whatsappsticker.utils.StickerUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class StickerDownloadManager {
    private static final String TAG = "StickerDownloadManager";
    private IDownLoadListener mDownLoadListener = null;
    private int totalDownload = 0;
    private int curSucDownload = 0;
    private int curErrDownload = 0;
    private StickerPack mStickerPack;
    private static StickerDownloadManager mOurInstance;

    private StickerDownloadManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static StickerDownloadManager getOurInstance() {
        if (mOurInstance != null) return mOurInstance;
        Class<StickerDownloadManager> clazz = StickerDownloadManager.class;
        synchronized (StickerDownloadManager.class) {
            if (mOurInstance != null) return mOurInstance;
            mOurInstance = new StickerDownloadManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mOurInstance;
        }
    }

    public void checkAndDownLoadSticker(@NonNull StickerPack stickerPack, @NonNull IDownLoadListener downLoadListener) {
        if (this.mStickerPack != null || this.mDownLoadListener != null || this.totalDownload != 0) {
            MLog.info((Object)TAG, (String)"checkAndDownLoadSticker running!!!!", (Object[])new Object[0]);
            YYTaskExecutor.postToMainThread(() -> downLoadListener.onFailed(stickerPack));
            return;
        }
        List<StickerDownloadInfo> downloadInfoList = this.getNeedDownLoadFile(stickerPack);
        if (FP.empty(downloadInfoList)) {
            YYTaskExecutor.postToMainThread(() -> downLoadListener.completed(stickerPack));
            return;
        }
        this.mStickerPack = stickerPack;
        this.mDownLoadListener = downLoadListener;
        this.curErrDownload = 0;
        this.curSucDownload = 0;
        this.totalDownload = downloadInfoList.size();
        String filePath = StickerUtils.getImageFileDirPath(stickerPack.identifier);
        File file = new File(filePath);
        if (!file.exists()) {
            file.mkdirs();
        }
        for (int i = 0; i < downloadInfoList.size(); ++i) {
            this.downloadFile(downloadInfoList.get(i), stickerPack.identifier);
        }
    }

    private List<StickerDownloadInfo> getNeedDownLoadFile(StickerPack stickerPack) {
        ArrayList<StickerDownloadInfo> downloadInfoList = new ArrayList<StickerDownloadInfo>(stickerPack.stickers.size());
        if (!this.hasTargetFile(stickerPack.trayImageFile, stickerPack.identifier)) {
            StickerDownloadInfo info = new StickerDownloadInfo(stickerPack.trayImageFile, stickerPack.trayImageUrl, true);
            downloadInfoList.add(info);
        }
        for (int j = 0; j < stickerPack.stickers.size(); ++j) {
            Sticker sticker = (Sticker)stickerPack.stickers.get(j);
            if (this.hasTargetFile(sticker.imageFile, stickerPack.identifier)) continue;
            StickerDownloadInfo info = new StickerDownloadInfo(sticker.imageFile, sticker.downloadUrl, false);
            downloadInfoList.add(info);
        }
        MLog.info((Object)TAG, (String)"getNeedDownLoadFile downloadInfoList size: %s", (Object[])new Object[]{FP.size(downloadInfoList)});
        return downloadInfoList;
    }

    private boolean hasTargetFile(String fileName, String identifier) {
        String imgDirPath = StickerUtils.getImageFileDirPath(identifier);
        String filePath = imgDirPath + File.separator + fileName;
        File file = new File(filePath);
        return file.exists();
    }

    private void downloadFile(final StickerDownloadInfo stickerDownloadInfo, String identifier) {
        String path = StickerUtils.getImageFileDirPath(identifier) + File.separator + stickerDownloadInfo.name;
        HttpUtil.downloadFile((String)stickerDownloadInfo.url, (String)path, (Callback)new Callback<File>(){

            public void onResponse(Call<File> call, Response<File> response) {
                MLog.info((Object)StickerDownloadManager.TAG, (String)"downloadFile success info: %s", (Object[])new Object[]{stickerDownloadInfo});
                FeatureLog.i((String)"FTQuicFileDownload", (String)"downloadFile success info: %s", (Object[])new Object[]{stickerDownloadInfo});
                if (YYTaskExecutor.isMainThread()) {
                    StickerDownloadManager.this.addDownLoadResult(true);
                } else {
                    YYTaskExecutor.postToMainThread(() -> StickerDownloadManager.this.addDownLoadResult(true));
                }
            }

            public void onFailure(Call<File> call, Throwable e) {
                MLog.error((Object)StickerDownloadManager.TAG, (String)"downloadFile failed info: %s  ex: %s", (Object[])new Object[]{stickerDownloadInfo, e});
                FeatureLog.e((String)"FTQuicFileDownload", (String)"downloadFile failed info: %s  ex: %s", (Object[])new Object[]{stickerDownloadInfo, e});
                if (YYTaskExecutor.isMainThread()) {
                    StickerDownloadManager.this.addDownLoadResult(false);
                } else {
                    YYTaskExecutor.postToMainThread(() -> StickerDownloadManager.this.addDownLoadResult(false));
                }
            }
        });
    }

    private void addDownLoadResult(boolean success) {
        if (success) {
            ++this.curSucDownload;
        } else {
            ++this.curErrDownload;
        }
        MLog.info((Object)TAG, (String)"addDownLoadResult curSucDownload: %s  curErrDownload: %s  totalDownload: %s", (Object[])new Object[]{this.curSucDownload, this.curErrDownload, this.totalDownload});
        int downloadNum = this.curErrDownload + this.curSucDownload;
        if (this.mDownLoadListener != null) {
            this.mDownLoadListener.downLoadRatio(this.totalDownload, this.curSucDownload, this.curErrDownload);
            if (downloadNum == this.totalDownload) {
                if (this.curSucDownload <= 0) {
                    this.mDownLoadListener.onFailed(this.mStickerPack);
                } else {
                    this.mDownLoadListener.completed(this.mStickerPack);
                }
                this.resetData();
            }
        }
    }

    private void resetData() {
        MLog.info((Object)TAG, (String)"resetData", (Object[])new Object[0]);
        this.mDownLoadListener = null;
        this.totalDownload = 0;
        this.curSucDownload = 0;
        this.curErrDownload = 0;
        this.mStickerPack = null;
    }
}

