/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.mixmodule.toast;

import android.content.Context;
import android.widget.Toast;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.notify.NotificationIdDef;
import com.yy.appbase.ui.toast.GlobalTopToast;
import com.yy.appbase.ui.toast.ToastMessage;
import com.yy.base.env.RuntimeContext;
import com.yy.framework.core.Environment;
import com.yy.framework.core.Notification;

public class GlobalTopToastController
extends DefaultController {
    private static final String TAG = "GlobalTopToastController";
    private GlobalTopToast mToast;

    public GlobalTopToastController(Environment env) {
        super(env);
    }

    public void notify(Notification notification) {
        super.notify(notification);
        int id2 = notification.id;
        Object obj = notification.extObj;
        if (id2 == NotificationIdDef.GLOBAL_TOP_TOAST) {
            if (obj instanceof ToastMessage) {
                ToastMessage msg = (ToastMessage)obj;
                if (!this.mWindowMgr.isWindowValid()) {
                    this.showSystemToast(msg);
                } else {
                    this.createToast(msg.isShowSignleLine);
                    this.mToast.showToast(msg);
                }
            }
        } else if (id2 == NotificationIdDef.GLOBAL_TOP_TOAST_REMOVE && obj instanceof ToastMessage && this.mToast != null) {
            this.mToast.removeToast((ToastMessage)obj);
        }
    }

    private void createToast(boolean isShowSingleLine) {
        if (this.mToast == null) {
            this.mToast = new GlobalTopToast(this.mContext);
            this.mToast.setToastMsgSingleLine(isShowSingleLine);
            this.mWindowMgr.addExtLayerContent(this.mToast.getToastView());
        } else {
            this.mToast.setToastMsgSingleLine(isShowSingleLine);
        }
    }

    private void showSystemToast(ToastMessage msg) {
        Toast.makeText((Context)RuntimeContext.sApplicationContext, (CharSequence)msg.msg, (int)0).show();
    }
}

