/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.mixmodule.toast;

import android.content.Context;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.Toast;
import com.yy.appbase.R;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.notify.NotificationIdDef;
import com.yy.appbase.ui.toast.ToastMessage;
import com.yy.base.env.RuntimeContext;
import com.yy.base.utils.ResourceUtils;
import com.yy.framework.core.Environment;
import com.yy.framework.core.Notification;
import com.yy.hiyo.mixmodule.toast.GlobalBottomToast;

public class GlobalToastController
extends DefaultController {
    private static final String TAG = "GlobalToastController";
    private GlobalBottomToast mToast;

    public GlobalToastController(Environment env) {
        super(env);
    }

    public void notify(Notification notification) {
        super.notify(notification);
        int id2 = notification.id;
        Object obj = notification.extObj;
        if (id2 == NotificationIdDef.GLOBAL_TOAST && obj instanceof ToastMessage) {
            ToastMessage msg = (ToastMessage)obj;
            if (!this.mWindowMgr.isWindowValid()) {
                this.showSystemToast(msg);
            } else {
                this.createToast(msg.isShowSignleLine, msg.marginTop);
                this.mToast.showToast(msg);
            }
        }
    }

    private void createToast(boolean isShowSingleLine, float marginTop) {
        if (this.mToast == null) {
            this.mToast = new GlobalBottomToast(this.mContext);
            this.mToast.setToastMsgSingleLine(isShowSingleLine);
            int leftMargin = ResourceUtils.getDimen((int)R.dimen.global_bottom_toast_left_margin);
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, -2);
            layoutParams.gravity = 1;
            layoutParams.leftMargin = leftMargin;
            layoutParams.rightMargin = leftMargin;
            layoutParams.topMargin = (int)marginTop;
            this.mToast.getToastView().setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            this.mWindowMgr.addExtLayerContent(this.mToast.getToastView());
        } else {
            this.mToast.setToastMsgSingleLine(isShowSingleLine);
        }
    }

    private void showSystemToast(ToastMessage msg) {
        Toast.makeText((Context)RuntimeContext.sApplicationContext, (CharSequence)msg.msg, (int)0).show();
    }
}

