/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.mixmodule.shortcut;

import android.app.PendingIntent;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.content.pm.ResolveInfo;
import android.content.pm.ShortcutInfo;
import android.content.pm.ShortcutManager;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Message;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.core.content.pm.ShortcutInfoCompat;
import androidx.core.content.pm.ShortcutManagerCompat;
import androidx.core.graphics.drawable.IconCompat;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.app.IAppService;
import com.yy.base.logger.MLog;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.framework.core.AbstractController;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.Environment;
import com.yy.hiyo.mixmodule.shortcut.ShortcutReceiver;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.List;

public class ShortCutController
extends AbstractController {
    public static final String TAG = "Shortcut";
    public static final String INSTALL_SHORTCUT = "com.android.launcher.action.INSTALL_SHORTCUT";
    public static final String UNINSTALL_SHORTCUT = "com.android.launcher.action.UNINSTALL_SHORTCUT";
    public static final String LAUNCHER_FAVORITES_TITLE = "title";
    public static final String LAUNCHER_FAVORITES_INTENT = "intent";
    public static final String LAUNCHER_FAVORITES_ICONPACKAGE = "iconPackage";

    public ShortCutController(Environment baseEnv) {
        super(baseEnv);
    }

    public Object handleMessageSync(Message msg) {
        Object gid;
        if (msg == null) {
            return null;
        }
        if (msg.what == BaseMsgDef.MSG_SEND_SHORTCUT_TO_DESKTOP) {
            Bundle data = msg.getData();
            if (data != null) {
                Drawable iconDrawable;
                Bitmap iconBitmap = null;
                int iconResId = data.getInt("iconRes", -1);
                if (iconResId > 0 && (iconDrawable = ResourceUtils.getDrawable((int)iconResId)) instanceof BitmapDrawable) {
                    iconBitmap = ((BitmapDrawable)iconDrawable).getBitmap();
                }
                String url = data.getString("url");
                String title = data.getString(LAUNCHER_FAVORITES_TITLE);
                String id2 = data.getString("shortcut_id");
                if (TextUtils.isEmpty((CharSequence)id2)) {
                    id2 = title;
                }
                if (iconBitmap == null) {
                    iconBitmap = (Bitmap)data.getParcelable("iconBmp");
                }
                if (StringUtils.isNotEmpty((String)title) && StringUtils.isNotEmpty((String)url)) {
                    return this.sendShortcutToDesktop(title, url, iconBitmap, id2);
                }
            }
            return false;
        }
        if (msg.what == BaseMsgDef.MSG_REMOVE_SHORTCUT_FROM_DESKTOP) {
            Bundle data = msg.getData();
            if (data != null) {
                String url = data.getString("url");
                String title = data.getString(LAUNCHER_FAVORITES_TITLE);
                if (StringUtils.isNotEmpty((String)title) && StringUtils.isNotEmpty((String)url)) {
                    return this.removeShortCut(title, url);
                }
            }
        } else if (msg.what == BaseMsgDef.MSG_CHECK_SHORTCUT_EXIST && (gid = msg.obj) instanceof String) {
            if (this.mContext == null) {
                return false;
            }
            return ShortCutController.hadShortCutExist(this.mContext, (String)gid);
        }
        return super.handleMessageSync(msg);
    }

    private static boolean createActionShortcut(Context context, String title, Intent actionIntent, int iconResId) {
        Intent intent = new Intent(INSTALL_SHORTCUT);
        intent.putExtra("duplicate", true);
        String appName = title;
        intent.putExtra("android.intent.extra.shortcut.NAME", appName);
        intent.putExtra("android.intent.extra.shortcut.INTENT", (Parcelable)actionIntent);
        Intent.ShortcutIconResource p = Intent.ShortcutIconResource.fromContext((Context)context, (int)iconResId);
        intent.putExtra("android.intent.extra.shortcut.ICON_RESOURCE", (Parcelable)p);
        try {
            context.sendBroadcast(intent);
            return true;
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
            return false;
        }
    }

    private static boolean createActionShortcut(Context context, String title, Intent actionIntent, Bitmap iconBitmap) {
        Intent intent = new Intent(INSTALL_SHORTCUT);
        intent.putExtra("duplicate", true);
        String appName = title;
        intent.putExtra("android.intent.extra.shortcut.NAME", appName);
        intent.putExtra("android.intent.extra.shortcut.INTENT", (Parcelable)actionIntent);
        intent.putExtra("android.intent.extra.shortcut.ICON", (Parcelable)iconBitmap);
        try {
            context.sendBroadcast(intent);
            return true;
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
            return false;
        }
    }

    public static boolean addShortCutCompact(Context context, String title, Intent actionIntent, Bitmap iconBitmap, String id2) {
        try {
            if (ShortcutManagerCompat.isRequestPinShortcutSupported((Context)context)) {
                actionIntent.setAction("android.intent.action.VIEW");
                actionIntent.putExtra("duplicate", false);
                ShortcutInfoCompat info = new ShortcutInfoCompat.Builder(context, id2).setIcon(IconCompat.createWithBitmap((Bitmap)iconBitmap)).setShortLabel((CharSequence)title).setIntent(actionIntent).build();
                PendingIntent shortcutCallbackIntent = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)new Intent(context, ShortcutReceiver.class), (int)0x8000000);
                ShortcutManagerCompat.requestPinShortcut((Context)context, (ShortcutInfoCompat)info, (IntentSender)shortcutCallbackIntent.getIntentSender());
                return true;
            }
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
        return false;
    }

    private static Intent genUCAppShortcutIntent(Context context) {
        Intent intent = context.getPackageManager().getLaunchIntentForPackage(context.getPackageName());
        intent.setAction("android.intent.action.MAIN");
        intent.addCategory("android.intent.category.LAUNCHER");
        intent.addFlags(0x10200000);
        return intent;
    }

    private static Intent genUrlShortcutIntent(Context context, String title, String url) {
        Intent intent = ((IAppService)ServiceManagerProxy.getService(IAppService.class)).getHagoSchemeIntent(context, url);
        intent.setAction("shortcut_action");
        intent.putExtra("shortcut_title", title);
        intent.putExtra("shortcut_url", URLEncoder.encode(url));
        intent.putExtra("android.intent.extra.shortcut.INTENT", title);
        return intent;
    }

    private boolean sendShortcutToDesktop(String title, String url, Bitmap icon, String id2) {
        if (this.mContext == null) {
            return false;
        }
        if (ShortCutController.hadShortCutExist(this.mContext, id2)) {
            MLog.info((Object)TAG, (String)"sendShortcutToDesktop shortcut had exit, id: %s", (Object[])new Object[]{id2});
            return true;
        }
        return ShortCutController.addShortCutCompact(this.mContext, title, ShortCutController.genUrlShortcutIntent(this.mContext, title, url), icon, id2);
    }

    private boolean sendShortcutToDesktop(String title, String url, int resId) {
        if (this.mContext == null) {
            return false;
        }
        return ShortCutController.createActionShortcut(this.mContext, title, ShortCutController.genUrlShortcutIntent(this.mContext, title, url), resId);
    }

    private boolean removeShortCut(String title, String url) {
        if (this.mContext == null) {
            return false;
        }
        Intent shortcut = new Intent(UNINSTALL_SHORTCUT);
        shortcut.putExtra("android.intent.extra.shortcut.NAME", title);
        Intent intent = ShortCutController.genUrlShortcutIntent(this.mContext, title, url);
        shortcut.putExtra("android.intent.extra.shortcut.INTENT", (Parcelable)intent);
        try {
            this.mContext.sendBroadcast(shortcut);
            return true;
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
            return false;
        }
    }

    public static boolean hadShortCutExist(Context context, String title) {
        if (Build.VERSION.SDK_INT >= 25) {
            List shortcutInfos;
            ShortcutManager shortcutManager = (ShortcutManager)context.getSystemService(ShortcutManager.class);
            if (shortcutManager != null && !FP.empty((Collection)(shortcutInfos = shortcutManager.getPinnedShortcuts()))) {
                for (ShortcutInfo info : shortcutInfos) {
                    if (!StringUtils.equal((String)info.getId(), (String)title)) continue;
                    return true;
                }
            }
        } else {
            return ShortCutController.isShortCutExist(context, title);
        }
        return false;
    }

    public static boolean isShortCutExist(Context context, String title) {
        boolean isInstallShortcut = false;
        if (null == context || TextUtils.isEmpty((CharSequence)title)) {
            return isInstallShortcut;
        }
        String authority = "";
        if (TextUtils.isEmpty((CharSequence)authority)) {
            authority = ShortCutController.getAuthorityFromPermission(context);
        }
        ContentResolver cr = context.getContentResolver();
        if (!TextUtils.isEmpty((CharSequence)authority)) {
            try {
                Uri contentUri = Uri.parse((String)authority);
                Cursor c = cr.query(contentUri, new String[]{LAUNCHER_FAVORITES_TITLE, "iconResource"}, "title=?", new String[]{title}, null);
                if (c != null && c.getCount() > 0) {
                    isInstallShortcut = true;
                } else {
                    ShortcutManager shortcutManager = null;
                    if (Build.VERSION.SDK_INT >= 25) {
                        shortcutManager = (ShortcutManager)context.getSystemService(ShortcutManager.class);
                        List list = shortcutManager.getPinnedShortcuts();
                    }
                }
                if (null != c && !c.isClosed()) {
                    c.close();
                }
            }
            catch (Exception e) {
                MLog.error((Object)TAG, (String)"isShortCutExist", (Throwable)e, (Object[])new Object[0]);
            }
        }
        return isInstallShortcut;
    }

    public static String getCurrentLauncherPackageName(Context context) {
        Intent intent = new Intent("android.intent.action.MAIN");
        intent.addCategory("android.intent.category.HOME");
        ResolveInfo res = context.getPackageManager().resolveActivity(intent, 0);
        if (res == null || res.activityInfo == null) {
            return "";
        }
        if (res.activityInfo.packageName.equals("android")) {
            return "";
        }
        return res.activityInfo.packageName;
    }

    public static String getAuthorityFromPermissionDefault(Context context) {
        return ShortCutController.getThirdAuthorityFromPermission(context, "com.android.launcher.permission.READ_SETTINGS");
    }

    public static String getThirdAuthorityFromPermission(Context context, String permission) {
        return "";
    }

    public static String getAuthorityFromPermission(Context context) {
        String authority = ShortCutController.getAuthorityFromPermissionDefault(context);
        if (authority == null || authority.trim().equals("")) {
            String packageName = ShortCutController.getCurrentLauncherPackageName(context);
            packageName = packageName + ".permission.READ_SETTINGS";
            authority = ShortCutController.getThirdAuthorityFromPermission(context, packageName);
        }
        if (TextUtils.isEmpty((CharSequence)authority)) {
            int sdkInt = Build.VERSION.SDK_INT;
            authority = sdkInt < 8 ? "com.android.launcher.settings" : (sdkInt < 19 ? "com.android.launcher2.settings" : "com.android.launcher3.settings");
        }
        authority = "content://" + authority + "/favorites?notify=true";
        return authority;
    }
}

