/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.mixmodule.oss.ibigboss;

import androidx.annotation.Nullable;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.OssConfig;
import com.yy.base.logger.MLog;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.filestorage.FileStorageUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.hiyo.mixmodule.oss.ibigboss.OssSupportFormatBean;

public class OssSupportFormat {
    private static final String TAG = "OssSupportFormat";
    private static final String OSS_SUPPORT_FORMAT_JSON_NAME = "hago_oss_support_format_json_config";
    private OssSupportFormatBean mOssSupportFormat;

    public static OssSupportFormat getInstance() {
        return SingleHolder.INSTANCE;
    }

    @Nullable
    public OssSupportFormatBean getOssSupportFormatConfig() {
        OssConfig ossConfig = (OssConfig)UnifyConfig.INSTANCE.getConfigData(BssCode.OSS_MATCH);
        String lastJson = this.getOssSupportJsonFromLocal();
        MLog.debug((Object)TAG, (String)"getOssSupportJsonFromLocal json: %s", (Object[])new Object[]{lastJson});
        String newJson = lastJson;
        if (ossConfig != null && !StringUtils.equal((String)ossConfig.getConfigJson(), (String)lastJson)) {
            newJson = ossConfig.getConfigJson();
            this.saveOssSupportJsonToLocal(newJson);
            this.mOssSupportFormat = null;
        }
        if (this.mOssSupportFormat == null) {
            MLog.debug((Object)TAG, (String)"getOssSupportFormatConfig create", (Object[])new Object[0]);
            this.mOssSupportFormat = this.parseOssSupportJson(newJson);
        }
        return this.mOssSupportFormat;
    }

    private OssSupportFormatBean parseOssSupportJson(String json) {
        if (StringUtils.isEmpty((String)json)) {
            return null;
        }
        try {
            return (OssSupportFormatBean)JsonParser.parseJsonObject((String)json, OssSupportFormatBean.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String getOssSupportJsonFromLocal() {
        return FileStorageUtils.getInstance().getStrFromFile(true, OSS_SUPPORT_FORMAT_JSON_NAME);
    }

    private void saveOssSupportJsonToLocal(String json) {
        if (StringUtils.isNotEmpty((String)json)) {
            FileStorageUtils.getInstance().saveToFile(true, json, OSS_SUPPORT_FORMAT_JSON_NAME);
        }
    }

    private static class SingleHolder {
        private static final OssSupportFormat INSTANCE = new OssSupportFormat();

        private SingleHolder() {
        }
    }
}

