/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.mixmodule.oss.ali;

import android.os.SystemClock;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.account.AccountUtil;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SystemUtils;
import com.yy.hiyo.mixmodule.oss.STsTokenCallback;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import net.ihago.oss.api.upload.AliTokenInfo;
import net.ihago.oss.api.upload.Provider;
import net.ihago.oss.api.upload.UploadTokenReq;
import net.ihago.oss.api.upload.UploadTokenRsp;

class AliSTsToken {
    private static final String TAG = "STsToken";
    private StsTokenBundle mTokenBundle;

    AliSTsToken() {
    }

    void send(final STsTokenCallback<StsTokenBundle> sTsTokenCallback) {
        if (sTsTokenCallback == null) {
            return;
        }
        if (this.isAvailableToken()) {
            MLog.debug((Object)TAG, (String)"send has available token, onSuccess immediately", (Object[])new Object[0]);
            this.onSuccess(sTsTokenCallback);
            return;
        }
        UploadTokenReq req = new UploadTokenReq.Builder().local_file_path("").provider(Integer.valueOf(Provider.PROVIDER_ALI.getValue())).reg_country_code(AliSTsToken.countryCode()).method("POST").build();
        ProtoManager.getInstance().sendHttp((AndroidMessage)req, (IProtoCallback)new IProtoCallback<UploadTokenRsp>(){

            public boolean retryWhenTimeout(boolean canRetry) {
                return AliSTsToken.this.error(sTsTokenCallback);
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                return AliSTsToken.this.error(sTsTokenCallback);
            }

            public void onResponse(@NonNull UploadTokenRsp message, long code, String msg) {
                if (RuntimeContext.sIsDebuggable) {
                    MLog.debug((Object)AliSTsToken.TAG, (String)"getStsToken info: %s, backup_info: %s", (Object[])new Object[]{message.token_info, message.backup_token_info});
                }
                super.onResponse((AndroidMessage)message, code, msg);
                if (ProtoManager.isSuccessCode((long)code)) {
                    StsTokenBundle bundle = new StsTokenBundle();
                    bundle.mainToken = message.token_info.ali_token_info;
                    if (message.backup_token_info != null) {
                        bundle.backupToken = message.backup_token_info.ali_token_info;
                    }
                    bundle.mainExpireTime = AliSTsToken.this.getStsExpireTime(bundle.mainToken);
                    bundle.backupExpireTime = AliSTsToken.this.getStsExpireTime(bundle.backupToken);
                    AliSTsToken.this.mTokenBundle = bundle;
                    AliSTsToken.this.onSuccess(sTsTokenCallback);
                } else {
                    AliSTsToken.this.onError(sTsTokenCallback, (int)code, msg);
                }
            }
        });
    }

    private long getStsExpireTime(AliTokenInfo tokenInfo) {
        if (tokenInfo != null && tokenInfo.ttl > 0L) {
            return SystemClock.uptimeMillis() + (tokenInfo.ttl - 60L) * 1000L;
        }
        return 0L;
    }

    private boolean isAvailableToken() {
        long curTime = SystemClock.uptimeMillis();
        return this.mTokenBundle != null && curTime < this.mTokenBundle.mainExpireTime && curTime < this.mTokenBundle.backupExpireTime;
    }

    private boolean error(STsTokenCallback<StsTokenBundle> sTsTokenCallback) {
        this.onError(sTsTokenCallback, 99, "timeout");
        return false;
    }

    private void onSuccess(STsTokenCallback<StsTokenBundle> sTsTokenCallback) {
        YYTaskExecutor.postToMainThread(() -> sTsTokenCallback.onSuccess(this.mTokenBundle));
    }

    private void onError(STsTokenCallback<StsTokenBundle> sTsTokenCallback, int code, String errMsg) {
        YYTaskExecutor.postToMainThread(() -> sTsTokenCallback.onFail(code, errMsg));
    }

    private static String countryCode() {
        String code = AccountUtil.realCountry();
        if (TextUtils.isEmpty((CharSequence)code)) {
            code = SystemUtils.getHagoCountry();
        }
        if (code == null) {
            return "";
        }
        return code.toUpperCase();
    }

    public static class StsTokenBundle {
        public AliTokenInfo mainToken;
        @Nullable
        public AliTokenInfo backupToken;
        public long mainExpireTime;
        public long backupExpireTime;
    }
}

