/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.mixmodule.oss;

import android.net.Uri;
import android.webkit.MimeTypeMap;
import com.yy.appbase.service.IOOSService;
import com.yy.appbase.service.oos.IUploadObjectCallBack;
import com.yy.appbase.service.oos.UploadObjectRequest;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.mixmodule.oss.Upload;
import com.yy.hiyo.mixmodule.oss.ali.AliUploadService;
import com.yy.hiyo.mixmodule.oss.google.GoogleUploadService;
import com.yy.hiyo.mixmodule.oss.ibigboss.OssSupportFormat;
import com.yy.hiyo.mixmodule.oss.ibigboss.OssSupportFormatBean;
import java.io.File;

public class UploadService
implements IOOSService {
    private static final String TAG = "UploadService";

    public void uploadFile(String key2, String uploadFilePath, IUploadObjectCallBack callBack) {
        YYTaskExecutor.execute(() -> this.uploadObject(new UploadObjectRequest(key2, uploadFilePath), callBack));
    }

    public void uploadData(String key2, byte[] uploadData, IUploadObjectCallBack callBack) {
        YYTaskExecutor.execute(() -> this.uploadObject(new UploadObjectRequest(key2, uploadData), callBack));
    }

    public void cancel(String key2, String uploadFilePath) {
        YYTaskExecutor.execute(() -> {
            if (!RuntimeContext.isHagoPartySdk()) {
                GoogleUploadService.getInstance().delete(key2);
            }
            AliUploadService.getInstance().delete(key2);
        });
    }

    private void uploadObject(UploadObjectRequest request, IUploadObjectCallBack callBack) {
        Upload upload = this.handleOssFromRemoteConfig(request);
        upload.uploadObject(request, callBack);
    }

    private Upload handleOssFromRemoteConfig(UploadObjectRequest request) {
        String filePath = request.getUploadFilePath();
        OssSupportFormatBean ossSupportFormatBean = OssSupportFormat.getInstance().getOssSupportFormatConfig();
        if (StringUtils.isEmpty((String)filePath) || ossSupportFormatBean == null) {
            return AliUploadService.getInstance();
        }
        Uri uri = Uri.fromFile((File)new File(filePath));
        String fileExt = MimeTypeMap.getFileExtensionFromUrl((String)uri.toString());
        MLog.debug((Object)TAG, (String)("fileExt " + fileExt), (Object[])new Object[0]);
        for (String ext : ossSupportFormatBean.mAliOssSupportFormat) {
            if (!StringUtils.equalsIgnoreCase((String)fileExt, (String)ext)) continue;
            return AliUploadService.getInstance();
        }
        if (!RuntimeContext.isHagoPartySdk()) {
            for (String ext : ossSupportFormatBean.mGoogleOssSupportFormat) {
                if (!StringUtils.equalsIgnoreCase((String)fileExt, (String)ext)) continue;
                return GoogleUploadService.getInstance();
            }
        }
        return AliUploadService.getInstance();
    }
}

