/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.mixmodule.feedback.request.uploadUtil;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.util.Base64;
import com.google.gson.Gson;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.AppMetaDataUtil;
import com.yy.base.utils.VersionUtil;
import com.yy.hiyo.mixmodule.feedback.request.uploadUtil.BugUploadInfo;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

public class BugJson {
    private static final String TAG = "BugJson";
    private static volatile String sEnvironmentInfo;
    private static volatile String sVersionInfo;
    private BugUploadInfo mBugJsonBugInfo;
    private Map<Object, Object> mProjectMap = new HashMap<Object, Object>();
    private final String mReporter = "fbyy";
    private final String mAuthKey = "zaq1XSW@";
    private final String mProjectId = "14737";
    private final String mPriority = "3";
    private Map<String, String> projectIdMap = new HashMap<String, String>();
    private Map<String, String> issueIdMap = new HashMap<String, String>();
    private Map<String, String> priorityIdMap = new HashMap<String, String>();
    private Map<String, String> reporterMap = new HashMap<String, String>();
    private Map<String, String> assigneeMap = new HashMap<String, String>();
    private Map<String, String>[] moduleMap = new Map[1];
    private Map<String, String> discoverVersion = new HashMap<String, String>();
    private Map<String, String> resolveVersion = new HashMap<String, String>();
    private Map<String, String> bugType = new HashMap<String, String>();
    private Map<String, String> reappearMap = new HashMap<String, String>();
    private Map<String, String> bugSource = new HashMap<String, String>();

    public BugJson(BugUploadInfo bugUploadInfo) {
        this.mBugJsonBugInfo = bugUploadInfo;
    }

    public String getDefaultJsonMap() {
        this.initDefaultData();
        return this.getJsonMap();
    }

    public String getActualJsonMap() {
        this.initActualData();
        return this.getJsonMap();
    }

    public String getAuthString() {
        try {
            return "Basic " + this.encode("fbyy:zaq1XSW@".getBytes());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return "";
        }
    }

    private void initDefaultData() {
        this.projectIdMap.put("id", "14737");
        this.issueIdMap.put("id", "1");
        this.priorityIdMap.put("id", "3");
        this.reporterMap.put("name", "fbyy");
        this.assigneeMap.put("name", "lulong");
        this.moduleMap[0] = new HashMap<String, String>();
        this.moduleMap[0].put("name", "\u4ea7\u54c1\u4f53\u9a8c");
        this.discoverVersion.put("name", "0.0.0");
        this.resolveVersion.put("name", "0.0.0");
        this.bugType.put("value", "\u529f\u80fd\u7f3a\u9677");
        this.reappearMap.put("value", "\u5f85\u9a8c\u8bc1");
        this.bugSource.put("value", "\u5185\u6d4b");
        this.mProjectMap.put("summary", this.mBugJsonBugInfo.mSummary);
    }

    private void initActualData() {
        this.projectIdMap.put("id", "14737");
        this.issueIdMap.put("id", "1");
        this.priorityIdMap.put("id", "3");
        this.reporterMap.put("name", "fbyy");
        this.assigneeMap.put("name", "lulong");
        this.moduleMap[0] = new HashMap<String, String>();
        this.moduleMap[0].put("name", "\u4ea7\u54c1\u4f53\u9a8c");
        this.discoverVersion.put("name", this.getVersion());
        this.resolveVersion.put("name", this.getVersion());
        this.bugType.put("value", "\u529f\u80fd\u7f3a\u9677");
        this.reappearMap.put("value", "\u5f85\u9a8c\u8bc1");
        this.bugSource.put("value", "\u5185\u6d4b");
        this.mProjectMap.put("summary", this.mBugJsonBugInfo.mSubSummary);
    }

    private static String getVersionByPackageName(String packageName) {
        PackageInfo packageInfo;
        if (sVersionInfo != null) {
            return sVersionInfo;
        }
        PackageManager packageManager = RuntimeContext.sApplicationContext.getPackageManager();
        try {
            packageInfo = packageManager.getPackageInfo(packageName, 16384);
        }
        catch (PackageManager.NameNotFoundException e) {
            return "find no application:" + packageName;
        }
        sVersionInfo = packageInfo.applicationInfo.loadLabel(packageManager).toString() + " Version:" + packageInfo.versionName + " ,buildno:" + packageInfo.versionCode;
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)("sVersionInfo:" + sVersionInfo), (Object[])new Object[0]);
        }
        return sVersionInfo;
    }

    private static String getEnvironment(String packageName) {
        if (sEnvironmentInfo != null) {
            return sEnvironmentInfo;
        }
        sEnvironmentInfo = Build.MODEL + "(" + Build.SERIAL + "/) " + Build.VERSION.RELEASE + " " + BugJson.getVersionByPackageName(packageName) + "\n";
        return sEnvironmentInfo;
    }

    private String getJsonMap() {
        this.mProjectMap.put("project", this.projectIdMap);
        this.mProjectMap.put("issuetype", this.issueIdMap);
        this.mProjectMap.put("priority", this.priorityIdMap);
        this.mProjectMap.put("description", BugJson.getEnvironment(RuntimeContext.sApplicationContext.getPackageName()) + "\n\u95ee\u9898\u8be6\u60c5\uff1a\n" + this.mBugJsonBugInfo.mDescription.replace("\"", " ").replace("'", " "));
        this.mProjectMap.put("reporter", this.reporterMap);
        this.mProjectMap.put("assignee", this.assigneeMap);
        this.mProjectMap.put("components", this.moduleMap);
        this.mProjectMap.put("customfield_10100", this.getInnerVersion());
        this.mProjectMap.put("customfield_11101", this.discoverVersion);
        this.mProjectMap.put("customfield_10103", this.resolveVersion);
        this.mProjectMap.put("customfield_10104", Build.MANUFACTURER + " " + Build.MODEL);
        this.mProjectMap.put("customfield_10107", "Android " + Build.VERSION.RELEASE);
        HashMap<String, Map<Object, Object>> objMap = new HashMap<String, Map<Object, Object>>();
        objMap.put("fields", this.mProjectMap);
        MLog.info((Object)TAG, (String)"[getJsonMap] objMap = %s", (Object[])new Object[]{new Gson().toJson(objMap)});
        return new Gson().toJson(objMap);
    }

    private String getVersion() {
        return VersionUtil.getLocalVer((Context)RuntimeContext.sApplicationContext).getVersionNameWithoutSnapshot();
    }

    private String getInnerVersion() {
        String version = VersionUtil.getVersionCode((Context)RuntimeContext.sApplicationContext) + "-r" + AppMetaDataUtil.getSvnBuildVersion((Context)RuntimeContext.sApplicationContext);
        if (version != null && version.length() != 0) {
            return version;
        }
        return "000";
    }

    private String encode(byte[] bstr) throws UnsupportedEncodingException {
        String ret = new String(Base64.encode((byte[])bstr, (int)0), "UTF-8").replace('\n', ' ').trim();
        return ret;
    }
}

