/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.mixmodule.feedback.autoreport;

import android.content.Context;
import android.text.TextUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.squareup.wire.AndroidMessage;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.DateUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.base.utils.xml.CommonUtils;
import com.yy.hiyo.mixmodule.feedback.request.uploadUtil.AutoUploadRequestInfo;
import com.yy.hiyo.mixmodule.feedback.request.uploadUtil.FeedbackUploader;
import com.yy.hiyo.proto.ProtoManager;
import common.Header;
import ikxd.informAgainst.FeedbackDoneReq;
import ikxd.informAgainst.InformAgainst;
import ikxd.informAgainst.Uri;
import java.text.SimpleDateFormat;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AutoReport {
    private static final String TAG = "AutoReport";
    private static final Pattern paramPattern = Pattern.compile("\\$\\$(\\{[\\w\\W]*?\\})\\$\\$");

    public static void autoReport(String title, long logBegin, long logEnd) {
        if (RuntimeContext.sIsDebuggable) {
            ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)"feedback notify start upload log!", (int)1);
        }
        YYTaskExecutor.execute(() -> {
            MLog.info((Object)TAG, (String)("start insertIfNewUserNotExist log file title = " + title), (Object[])new Object[0]);
            SimpleDateFormat dateFormat = CommonUtils.getSimpleDateFormat((String)"yyyy-MM-dd HH:mm:ss");
            String time = DateUtils.getTimeFromMillisecond((Long)System.currentTimeMillis(), (SimpleDateFormat)dateFormat);
            float uploadSizeMB = FeedbackUploader.getInstance().getUploadFileSizeMaxLimit();
            int uploadRequestType = 0;
            int retryTimes = 2;
            if (!TextUtils.isEmpty((CharSequence)title)) {
                try {
                    String matcherStr;
                    JsonObject jo;
                    Matcher matcher = paramPattern.matcher(title);
                    if (matcher.find() && (jo = (JsonObject)JsonParser.parseJsonObject((String)(matcherStr = matcher.group(1)), JsonObject.class)) != null) {
                        Set entrySet = jo.entrySet();
                        for (Map.Entry entry : entrySet) {
                            switch ((String)entry.getKey()) {
                                case "size": {
                                    uploadSizeMB = ((JsonElement)entry.getValue()).getAsFloat();
                                    break;
                                }
                                case "retry_times": {
                                    retryTimes = ((JsonElement)entry.getValue()).getAsInt();
                                    break;
                                }
                                case "upload_method": {
                                    uploadRequestType = ((JsonElement)entry.getValue()).getAsInt();
                                    break;
                                }
                            }
                        }
                    }
                }
                catch (Exception e) {
                    MLog.warn((Object)TAG, (String)"something is wrong", (Object[])new Object[]{e});
                }
            }
            AutoUploadRequestInfo info = new AutoUploadRequestInfo(time, title, null, null, logBegin, logEnd, uploadSizeMB, uploadRequestType, retryTimes);
            AutoReport.upload(info);
        });
    }

    private static void upload(final AutoUploadRequestInfo info) {
        MLog.info((Object)TAG, (String)info.toString(), (Object[])new Object[0]);
        FeedbackUploader.getInstance().reportFeedback(info, new FeedbackUploader.IUploadCallBack(){

            @Override
            public void success() {
                MLog.info((Object)AutoReport.TAG, (String)"start insertIfNewUserNotExist log file sucess", (Object[])new Object[0]);
                if (RuntimeContext.sIsDebuggable) {
                    ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)"feedback notify upload log sucess!", (int)1);
                }
                AutoReport.notifServiceSucess();
            }

            @Override
            public void onError(int errorCode, String des) {
                MLog.info((Object)AutoReport.TAG, (String)("insertIfNewUserNotExist log file error errorCode = " + errorCode + " des = " + des), (Object[])new Object[0]);
                if (RuntimeContext.sIsDebuggable) {
                    ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)"feedback notify upload log error!", (int)1);
                }
                if (info.mAutoUploadRetryTimes > 0) {
                    int uploadType;
                    switch (info.mUploadRequestType) {
                        case 1: {
                            uploadType = 2;
                            break;
                        }
                        case 2: {
                            uploadType = 1;
                            break;
                        }
                        default: {
                            uploadType = 1;
                        }
                    }
                    AutoUploadRequestInfo retryInfo = new AutoUploadRequestInfo(info.mUploadStartTime, info.mFeedbackMsg, info.mContactInfo, info.mImagePath, info.mLogStartTime, info.mLogEndTime, info.mUploadSizeMB, uploadType, info.mAutoUploadRetryTimes - 1);
                    MLog.info((Object)AutoReport.TAG, (String)"retry upload again", (Object[])new Object[0]);
                    AutoReport.upload(retryInfo);
                }
            }
        });
    }

    private static void notifServiceSucess() {
        FeedbackDoneReq feedbackDoneReq = new FeedbackDoneReq.Builder().build();
        Header header = ProtoManager.getInstance().getHeader("ikxd_inform_against_d");
        InformAgainst datas = new InformAgainst.Builder().header(header).feedback_done_req(feedbackDoneReq).uri(Uri.kUriFeedbackDoneReq).build();
        ProtoManager.getInstance().send((AndroidMessage)datas, null);
    }
}

