/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.mixmodule.feedback;

import android.content.Context;
import android.text.TextUtils;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.core.DefaultWindowController;
import com.yy.appbase.envsetting.uriprovider.UriProvider;
import com.yy.appbase.http.BaseResponseBean;
import com.yy.appbase.http.HttpUtil;
import com.yy.appbase.http.INetOriginRespStringCallback;
import com.yy.appbase.http.INetRespCallback;
import com.yy.appbase.service.IOOSService;
import com.yy.appbase.service.oos.IUploadObjectCallBack;
import com.yy.appbase.service.oos.UploadObjectRequest;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.DontProguardClass;
import com.yy.base.utils.FP;
import com.yy.base.utils.FileUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.framework.core.Environment;
import com.yy.framework.core.ReportAppealBean;
import com.yy.hiyo.mixmodule.R;
import com.yy.hiyo.mixmodule.feedback.request.uploadUtil.FeedbackUploader;
import java.util.HashMap;
import okhttp3.Call;

public class ReportRepealController
extends DefaultWindowController {
    private static final String TAG = "ReportRepealController";

    public ReportRepealController(Environment env) {
        super(env);
    }

    public void uploadRepeal(String imgPath, final String msg, final String phoneNum, final FeedbackUploader.IUploadCallBack callBack) {
        if (FP.empty((CharSequence)imgPath)) {
            MLog.info((Object)TAG, (String)"uploadReportImg imgPath null", (Object[])new Object[0]);
            this.sendUploadReq("", msg, phoneNum, callBack);
            return;
        }
        String name = FileUtils.getFileName((String)imgPath);
        String objectKey = StringUtils.formatWitUSLocal((String)"report_feedback_img/%d/%d/%s", (Object[])new Object[]{AccountUtil.getUid(), System.currentTimeMillis(), name});
        ((IOOSService)this.getServiceManager().getService(IOOSService.class)).uploadFile(objectKey, imgPath, new IUploadObjectCallBack(){

            public void onSuccess(UploadObjectRequest request) {
                String imageUrl = request.mUrl;
                MLog.info((Object)ReportRepealController.TAG, (String)"uploadReportImg onSelected %s", (Object[])new Object[]{imageUrl});
                ReportRepealController.this.sendUploadReq(imageUrl, msg, phoneNum, callBack);
            }

            public void onFailure(UploadObjectRequest request, int errorCode, Exception exception) {
                MLog.info((Object)ReportRepealController.TAG, (String)"uploadReportImg onSelected upload img error!", (Object[])new Object[0]);
                ReportRepealController.this.sendUploadReq("", msg, phoneNum, callBack);
            }
        });
    }

    public void sendUploadReq(String imgUrl, String msg, String phoneNum, final FeedbackUploader.IUploadCallBack callBack) {
        ReportAppealBean bean = new ReportAppealBean(phoneNum, msg, imgUrl, 0, "");
        YYTaskExecutor.execute(() -> {
            String json = JsonParser.toJson((Object)bean);
            String url = UriProvider.getIkxdSvrHost() + "/inform_against/appeal";
            HttpUtil.httpReqPostString((String)url, (String)json, null, (INetRespCallback)new INetOriginRespStringCallback(){

                public void onError(Call call, Exception e, int id2) {
                    if (call != null) {
                        callBack.onError(-1, e.getMessage());
                    }
                }

                public void onResponse(String response, BaseResponseBean<String> res, int id2) {
                    if (callBack != null) {
                        callBack.success();
                    }
                }
            });
        });
    }

    public void sendUploadReq(ReportAppealBean appealBean) {
        YYTaskExecutor.execute(() -> {
            String json = JsonParser.toJson((Object)appealBean);
            String url = UriProvider.getIkxdSvrHost() + "/inform_against/appeal";
            String token = appealBean.getToken();
            HashMap<String, String> map = new HashMap<String, String>();
            if (!TextUtils.isEmpty((CharSequence)token)) {
                map.put("Appeal-Token", token);
            }
            MLog.info((Object)TAG, (String)"sendUploadReq start", (Object[])new Object[0]);
            HttpUtil.httpReqPostString((String)url, (String)json, map, (INetRespCallback)new INetRespCallback<ReportResult>(){

                public void onError(Call call, Exception e, int id2) {
                    MLog.error((Object)ReportRepealController.TAG, (String)"sendUploadReq error:%s", (Throwable)e, (Object[])new Object[0]);
                }

                public void onResponse(String response, BaseResponseBean<ReportResult> res, int id2) {
                    if (res == null) {
                        return;
                    }
                    MLog.info((Object)ReportRepealController.TAG, (String)"sendUploadReq onResponse:%s", (Object[])new Object[]{res.code});
                    if (res.isSuccess()) {
                        ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.tips_appeal_success);
                    } else if (res.code == 400) {
                        ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.report_to_many_error);
                    } else if (res.code == 401) {
                        ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.report_invalid_error);
                    } else if (res.code == 402) {
                        ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.report_repeat_error);
                    } else if (res.code == 404) {
                        ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.tips_hiido_baned);
                    } else if (res.code == 407) {
                        ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.tips_room_name_containt_sensitive_word);
                    }
                }

                public boolean needToken() {
                    return false;
                }
            });
        });
    }

    @DontProguardClass
    private static class ReportResult {
        int code;

        private ReportResult() {
        }
    }
}

