/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.mixmodule.feedback;

import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.os.Message;
import android.text.TextUtils;
import com.yy.appbase.R;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.core.DefaultWindowController;
import com.yy.appbase.data.UserInfoExt;
import com.yy.appbase.envsetting.uriprovider.UriProvider;
import com.yy.appbase.http.CommonHttpHeader;
import com.yy.appbase.http.dns.HTTPDnsUtils;
import com.yy.appbase.service.IOOSService;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.app.IAppService;
import com.yy.appbase.service.callback.IQueryOnlineCallBack;
import com.yy.appbase.service.callback.OnCameraCallbak;
import com.yy.appbase.service.oos.IUploadObjectCallBack;
import com.yy.appbase.service.oos.UploadObjectRequest;
import com.yy.appbase.ui.country.CountryData;
import com.yy.appbase.ui.country.CountryHelper;
import com.yy.appbase.ui.country.CountrySelectWindow;
import com.yy.appbase.ui.country.ICountrySelectCallBack;
import com.yy.appbase.ui.dialog.ProgressDialog;
import com.yy.appbase.user.IGetUserInfoExtCallBack;
import com.yy.appbase.user.UserInfoExtHelper;
import com.yy.base.env.RuntimeContext;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.guid.GuidFactory;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.DateUtils;
import com.yy.base.utils.FP;
import com.yy.base.utils.MD5Utils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SingleToastUtil;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.VersionUtil;
import com.yy.base.utils.YYFileUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.base.utils.xml.CommonUtils;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.Environment;
import com.yy.framework.core.ReportAppealBean;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.hago.xlog.KLogUtils;
import com.yy.hiidostatis.api.StatisContent;
import com.yy.hiyo.camera.base.ICameraService;
import com.yy.hiyo.camera.base.ablum_select.AlbumConfig;
import com.yy.hiyo.im.ImDataFactory;
import com.yy.hiyo.im.ImService;
import com.yy.hiyo.im.base.FeedbackBean;
import com.yy.hiyo.im.base.ImMsgReqParam;
import com.yy.hiyo.login.base.IBindThirdPartyAccountCallBack;
import com.yy.hiyo.login.base.IThirdPartyAuthorizationCallBack;
import com.yy.hiyo.login.base.LoginBaseMsgDef;
import com.yy.hiyo.mixmodule.R;
import com.yy.hiyo.mixmodule.base.MixBaseMsgDef;
import com.yy.hiyo.mixmodule.feedback.FeedbackWindow;
import com.yy.hiyo.mixmodule.feedback.IFeedbackViewCallBack;
import com.yy.hiyo.mixmodule.feedback.ReportRepealController;
import com.yy.hiyo.mixmodule.feedback.autoreport.AutoReport;
import com.yy.hiyo.mixmodule.feedback.request.uploadUtil.FeedbackUploader;
import com.yy.hiyo.mixmodule.feedback.request.uploadUtil.UploadRequestInfo;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.wallet.base.feedback.FeedbackCallBack;
import com.yy.socialplatformbase.AbsPlatformAdapter;
import com.yy.socialplatformbase.ThirdPartyPlatformHelper;
import com.yy.socialplatformbase.callback.IGetFirendListCallBack;
import com.yy.socialplatformbase.data.LoginSuccessResult;
import com.yy.socialplatformbase.data.UserBaseInfo;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import ikxd.informAgainst.FeedbackNotify;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;

public class FeedbackController
extends DefaultWindowController
implements IFeedbackViewCallBack {
    public static final String TAG = "FeedbackController";
    private FeedbackWindow mWindow;
    private long mWindowOpenTime;
    private CountrySelectWindow mCountrySelectWindow;
    private CountryData mCountry = CountryData.getDefault();
    private OnCameraCallbak mOnCameraCallbak = new OnCameraCallbak(){

        public void onFinish(String path) {
            if (FeedbackController.this.isVideoPath(path)) {
                FeedbackController.this.showVideo(path);
            } else if (FeedbackController.this.mWindow != null && StringUtils.isNotEmpty((String)path)) {
                FeedbackController.this.mWindow.showPhoto(path);
            }
        }
    };
    private boolean comeFormBanned = false;
    private boolean isReportBug = false;
    private ReportRepealController repealController = null;
    private int mFromType;
    private String feedBackContent;
    private Runnable timeoutTask = new Runnable(){

        @Override
        public void run() {
            if (FeedbackController.this.mDialogLinkManager != null && FeedbackController.this.mDialogLinkManager.isDialogShowing()) {
                FeedbackController.this.mDialogLinkManager.dismissDialog();
                SingleToastUtil.showToast((Context)FeedbackController.this.mContext, (String)ResourceUtils.getString((int)R.string.feedback_error));
            }
        }
    };
    private static boolean sPingFacebook = false;
    private static boolean sPingGoogle = false;
    private static boolean sPingBaidu = false;
    private static volatile boolean sPinging = false;
    private static volatile boolean sGetIps = false;
    private IThirdPartyAuthorizationCallBack mThirdPartyAuthorizationCallBack = new IThirdPartyAuthorizationCallBack(){

        public void onSuccess(LoginSuccessResult result) {
            FeedbackController.this.handleFacebookFriendList();
        }

        public void onCancel() {
        }

        public void onError(int errorCode, Exception e) {
        }
    };
    private IBindThirdPartyAccountCallBack mBindThirdPartyAccountCallBack = new IBindThirdPartyAccountCallBack(){

        public void onSuccess() {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    FeedbackController.this.handleFacebookFriendList();
                }
            });
        }

        public void onCancel() {
        }

        public void onError(int errorCode, Exception e) {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                }
            });
        }
    };

    private void showVideo(final String path) {
        if (this.mWindow != null) {
            this.mWindow.showProgress();
        }
        ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.tips_feedback_video_report_upload, (int)0);
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                String fileName = FeedbackController.this.getFileName("feedback/video/", path, ".mp4");
                if (!FP.empty((CharSequence)fileName)) {
                    ((IOOSService)ServiceManagerProxy.getInstance().getService(IOOSService.class)).uploadFile(fileName, path, new IUploadObjectCallBack(){

                        public void onSuccess(UploadObjectRequest request) {
                            if (FeedbackController.this.mWindow != null) {
                                FeedbackController.this.mWindow.hideProgress();
                            }
                            MLog.info((Object)FeedbackController.TAG, (String)"\u4e0a\u4f20\u89c6\u9891:%s", (Object[])new Object[]{request.mUrl});
                            if (FeedbackController.this.mWindow != null && StringUtils.isNotEmpty((String)path)) {
                                FeedbackController.this.mWindow.showVideo(path, request.mUrl);
                            }
                        }

                        public void onFailure(UploadObjectRequest request, int errorCode, Exception exception) {
                            if (FeedbackController.this.mWindow != null) {
                                FeedbackController.this.mWindow.hideProgress();
                            }
                            ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.tips_feedback_video_report_fail, (int)0);
                            MLog.info((Object)FeedbackController.TAG, (String)"\u4e0a\u4f20\u89c6\u9891\u5931\u8d25\uff0c\u9519\u8bef\u7801:%s, \u9519\u8bef:%s", (Object[])new Object[]{errorCode, exception});
                        }
                    });
                } else if (FeedbackController.this.mWindow != null) {
                    FeedbackController.this.mWindow.hideProgress();
                }
            }
        });
    }

    private boolean isVideoPath(String path) {
        if (FP.empty((CharSequence)path)) {
            return false;
        }
        String lowerCasePath = path.toLowerCase();
        return lowerCasePath.endsWith(".3gp") || lowerCasePath.endsWith(".mp4") || lowerCasePath.endsWith(".mkv");
    }

    private String getFileName(String domain, String path, String defaultSuffix) {
        String md5 = "";
        try {
            File file = new File(path);
            if (file != null && file.length() > 0x3C00000L) {
                ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.tips_feedback_video_report_too_large, (int)0);
                return md5;
            }
            md5 = YYFileUtils.getFileMD5String((File)file, (long)1000L);
            if (TextUtils.isEmpty((CharSequence)md5)) {
                md5 = AccountUtil.getUid() + "_" + MD5Utils.getMD5String((String)path) + "_" + System.currentTimeMillis();
            }
            int index = path.lastIndexOf(".");
            String suffix = defaultSuffix;
            if (index >= 0) {
                suffix = path.substring(index);
            }
            return domain + md5 + suffix;
        }
        catch (Exception e) {
            MLog.info((Object)TAG, (String)"getFileName error:%s", (Object[])new Object[]{e.toString()});
            return md5;
        }
    }

    public FeedbackController(Environment env) {
        super(env);
    }

    public void handleMessage(Message msg) {
        if (msg.what == MixBaseMsgDef.SHOW_WINDOW_FEEDBACK) {
            Bundle data = msg.getData();
            int mode = 0;
            this.feedBackContent = "";
            if (data != null) {
                if (data.containsKey("fromBanned")) {
                    mode = data.getInt("fromBanned", 0);
                    this.comeFormBanned = true;
                }
                if (data.containsKey("reportBug")) {
                    this.isReportBug = true;
                    mode = 3;
                } else {
                    this.isReportBug = false;
                }
                if (data.containsKey("feedback_content")) {
                    this.feedBackContent = data.getString("feedback_content");
                }
            } else {
                this.comeFormBanned = false;
                this.isReportBug = false;
            }
            this.mWindowOpenTime = System.currentTimeMillis();
            if (this.mWindow == null) {
                this.mWindow = new FeedbackWindow(this.mContext, mode, this, this.isReportBug);
                if (this.mCountry.countryCode != null && this.mCountry.countryName != null) {
                    this.mWindow.updateCountry(this.mCountry.countryName + " +" + this.mCountry.countryCode);
                }
                this.addRunInfoToLogFile();
            }
            if (msg.arg1 > 0) {
                this.mWindow.updateSelectType(msg.arg1, StringUtils.isEmpty((String)this.feedBackContent));
            }
            this.mWindow.updateFeedbackContent(this.feedBackContent);
            this.mFromType = msg.arg2;
            this.mWindowMgr.pushWindow((AbstractWindow)this.mWindow, true);
            YYTaskExecutor.postToMainThread((Runnable)new YYTaskExecutor.RunnableEx(){

                public void run() {
                    FeedbackController.this.sendMessageSync(MixBaseMsgDef.PRINT_APP_WINDOW_SWITCH_PROCESS);
                }
            }, (long)1000L);
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20030237").put("function_id", "feedback_pg_show"));
        } else if (msg.what == MixBaseMsgDef.CLOSE_WINDOW_FEEDBACK) {
            if (this.mWindow != null) {
                this.mWindowMgr.popWindow(true, (AbstractWindow)this.mWindow);
            }
        } else if (BaseMsgDef.MSG_FEED_BACK_AUTO_REPORT_LOG == msg.what) {
            if (msg.obj instanceof FeedbackNotify) {
                FeedbackNotify notify2 = (FeedbackNotify)msg.obj;
                AutoReport.autoReport(notify2.title, notify2.begin, notify2.end);
            }
        } else if (BaseMsgDef.MSG_FEED_BACK == msg.what) {
            Bundle bundle = msg.getData();
            if (bundle != null) {
                String content = bundle.getString("feedback_content");
                FeedbackCallBack feedbackCallBack = null;
                if (msg.obj instanceof FeedbackCallBack) {
                    feedbackCallBack = (FeedbackCallBack)msg.obj;
                }
                int type = msg.arg1;
                this.mDialogLinkManager.showDialog((BaseDialog)new ProgressDialog());
                this.reallyFeedBack(type, null, "", content, null, feedbackCallBack);
            }
        } else if (BaseMsgDef.APPEAL_EVENT == msg.what) {
            ReportAppealBean appealBean = (ReportAppealBean)msg.obj;
            if (this.repealController == null) {
                this.repealController = new ReportRepealController(this.getEnvironment());
            }
            this.repealController.sendUploadReq(appealBean);
        } else if (BaseMsgDef.REPORT_FEEDBACK == msg.what) {
            Bundle bundle = msg.getData();
            if (bundle != null) {
                String content = bundle.getString("feedback_content");
                String imgPath = bundle.getString("feedback_image_path");
                String contact = bundle.getString("feedback_contact");
                String videoPath = bundle.getString("feedback_video_path");
                boolean silent = bundle.getBoolean("feedback_silent", false);
                int fromType = bundle.getInt("feedback_from_type");
                int feedbackType = bundle.getInt("feedback_type");
                if (fromType == 10) {
                    content = content + "(kf)";
                }
                if (feedbackType == 2) {
                    content = content + "(game)";
                }
                if (feedbackType == 11) {
                    content = content + "(sdkcrash)";
                }
                FeedbackCallBack feedbackCallBack = null;
                if (msg.obj instanceof FeedbackCallBack) {
                    feedbackCallBack = (FeedbackCallBack)msg.obj;
                }
                int type = msg.arg1;
                if (!silent) {
                    this.mDialogLinkManager.showDialog((BaseDialog)new ProgressDialog());
                }
                this.reallyFeedBack(type, imgPath, videoPath, content, contact, silent, feedbackCallBack);
            }
        } else if (msg.what == MixBaseMsgDef.ON_HELP_CENTER_SHOW && this.mWindow == null) {
            this.addRunInfoToLogFile();
        }
    }

    public void onWindowDetach(AbstractWindow abstractWindow) {
        super.onWindowDetach(abstractWindow);
        if (this.mWindow == abstractWindow) {
            this.mWindow = null;
        }
    }

    private void test() {
        this.handleFacebookRecommend();
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.add(111111111L);
        ((IUserInfoService)this.getServiceManager().getService(IUserInfoService.class)).getOnlineStatus(ids, new IQueryOnlineCallBack(){

            public void onSuccess(HashMap<Long, Boolean> statu) {
                MLog.info((Object)FeedbackController.TAG, (String)statu.toString(), (Object[])new Object[0]);
            }

            public void onError(String errorCode, Exception e) {
            }
        });
    }

    private void addRunInfoToLogFile() {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                int netOk = NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext) ? 1 : 0;
                int netType = NetworkUtils.getNetworkType((Context)RuntimeContext.sApplicationContext);
                String simOperator = NetworkUtils.getOperator((Context)RuntimeContext.sApplicationContext);
                String netOperatorName = NetworkUtils.getNetOperatorName((Context)RuntimeContext.sApplicationContext);
                String langAndCountry = SystemUtils.getLangAndCountry();
                String deviceModel = Build.MODEL;
                String deviceCarrier = Build.MANUFACTURER;
                String guid = GuidFactory.getInstance().getGuid();
                final String registerHost = UriProvider.getRegisterHost();
                int wsConnect = ProtoManager.getInstance().isWSConnected() ? 1 : 0;
                boolean useDns = HTTPDnsUtils.INSTANCE.isSmartResolveEnable();
                long uid = AccountUtil.getUid();
                final boolean needPingFacebook = uid <= 0L || AccountUtil.isLoginByGuest();
                final boolean needPingGoogle = netOk == 1 && !StringUtils.equalsIgnoreCase((String)SystemUtils.getHagoCountry(), (String)"CN");
                final boolean needPingBaidu = netOk == 1 && !needPingFacebook;
                boolean installFacebook = false;
                IAppService appService = (IAppService)ServiceManagerProxy.getService(IAppService.class);
                MLog.error((Object)FeedbackController.TAG, (String)"appver:%d,osVer:%srun info guid:%s,netok:%d,netType:%d,simOp:%s,netOp:%s,\nlangC:%s,dModel:%s,Carrier:%s,branch:%s,timeZone:%s", (Object[])new Object[]{VersionUtil.getAppVersion(), CommonHttpHeader.getOsVer(), guid, netOk, netType, simOperator, netOperatorName, langAndCountry, deviceModel, deviceCarrier, appService != null ? appService.getBranchName() : "", TimeZone.getDefault().getDisplayName()});
                if (uid <= 0L) {
                    MLog.error((Object)FeedbackController.TAG, (String)"run info registerHost:%s useDns:%d uid:%s wsConnect:%d installF:%d", (Object[])new Object[]{registerHost, useDns ? 1 : 0, String.valueOf(uid), wsConnect, installFacebook ? 1 : 0});
                } else {
                    MLog.error((Object)FeedbackController.TAG, (String)"run info registerHost:%s useDns:%d uid:%s wsConnect:%d", (Object[])new Object[]{registerHost, useDns ? 1 : 0, String.valueOf(uid), wsConnect});
                }
                if (!sPinging && (needPingFacebook || needPingBaidu || needPingGoogle)) {
                    sPinging = true;
                    YYTaskExecutor.execute((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            String pingResult = "ping";
                            if (needPingFacebook) {
                                sPingFacebook = NetworkUtils.pingHost((String)"m.facebook.com");
                                pingResult = pingResult + " facebook:" + (sPingFacebook ? 1 : 0);
                            }
                            if (needPingBaidu) {
                                sPingBaidu = NetworkUtils.pingHost((String)"www.baidu.com");
                                pingResult = pingResult + " baidu:" + (sPingBaidu ? 1 : 0);
                            }
                            if (needPingGoogle) {
                                sPingGoogle = NetworkUtils.pingHost((String)"www.google.com");
                                pingResult = pingResult + " google:" + (sPingGoogle ? 1 : 0);
                            }
                            MLog.error((Object)FeedbackController.TAG, (String)pingResult, (Object[])new Object[0]);
                            sPinging = false;
                        }
                    });
                }
                if (useDns && StringUtils.isNotEmpty((String)registerHost) && !sGetIps) {
                    sGetIps = true;
                    YYTaskExecutor.execute((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            try {
                                StringBuilder dnsIps = new StringBuilder("dns ips:");
                                List ipList = HTTPDnsUtils.INSTANCE.lookupAsString(registerHost);
                                for (String ip : ipList) {
                                    dnsIps.append(" ");
                                    dnsIps.append(ip);
                                }
                                MLog.error((Object)FeedbackController.TAG, (String)dnsIps.toString(), (Object[])new Object[0]);
                            }
                            catch (Exception e) {
                                MLog.error((Object)FeedbackController.TAG, (Throwable)e);
                            }
                            sGetIps = false;
                        }
                    });
                }
                YYTaskExecutor.execute((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        KLogUtils.flush();
                    }
                }, (long)10000L);
            }
        });
    }

    private void handleFacebookRecommend() {
        Object object = this.sendMessageSync(BaseMsgDef.MSG_GET_FACEBOOK_BIND_STATU);
        if (object instanceof Boolean) {
            boolean result = (Boolean)object;
            if (result) {
                this.handleFacebookFriendList();
            } else {
                this.showConnectFacebookView();
            }
        } else {
            this.showConnectFacebookView();
        }
    }

    private void handleFacebookFriendList() {
        AbsPlatformAdapter absPlatformAdapter = ThirdPartyPlatformHelper.getInstance().getPlatform(5);
        if (absPlatformAdapter != null) {
            absPlatformAdapter.getFriendList(new IGetFirendListCallBack(){

                public void onSuccess(final ArrayList<UserBaseInfo> list) {
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            UserInfoExtHelper.getUserExtListByFacebookUsers((IUserInfoService)((IUserInfoService)FeedbackController.this.getServiceManager().getService(IUserInfoService.class)), (ArrayList)list, (IGetUserInfoExtCallBack)new IGetUserInfoExtCallBack(){

                                public void onSuccess(ArrayList<UserInfoExt> userInfos) {
                                    if (userInfos != null) {
                                        MLog.info((Object)"Llll", (String)userInfos.toString(), (Object[])new Object[0]);
                                    }
                                }

                                public void onError(String errorCode, Exception e) {
                                }
                            });
                        }
                    });
                }

                public void onError(int errorCode, Exception e) {
                    MLog.error((Object)FeedbackController.TAG, (Throwable)e);
                    if (errorCode == 101) {
                        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                FeedbackController.this.showFacebookAuthorizationView();
                            }
                        });
                    }
                }
            });
        }
    }

    private void showConnectFacebookView() {
        this.onConnectFacebookViewClicked();
    }

    private void showFacebookAuthorizationView() {
        this.onFacebookAuthorizationViewClicked();
    }

    private void onFacebookAuthorizationViewClicked() {
        this.sendMessage(BaseMsgDef.MSG_FACEBOOK_AUTHORIZATION, -1, -1, this.mThirdPartyAuthorizationCallBack);
    }

    private void onConnectFacebookViewClicked() {
        this.sendMessage(BaseMsgDef.MSG_FACEBOOK_BIND_ACCOUNT, -1, -1, this.mBindThirdPartyAccountCallBack);
    }

    @Override
    public void onReportBtnClicked(final int feedbackType, String imgPath, String msg, final String contactInfo, String videoPath) {
        MLog.info((Object)TAG, (String)"onReportBtnClicked!", (Object[])new Object[0]);
        if (this.mDialogLinkManager.isDialogShowing()) {
            return;
        }
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20030237").put("function_id", "feedback_pg_sub_but_click"));
        this.mDialogLinkManager.showDialog((BaseDialog)new ProgressDialog());
        YYTaskExecutor.postToMainThread((Runnable)this.timeoutTask, (long)30000L);
        String feedbackEnterType = "";
        if (this.mFromType == 10) {
            msg = msg + "(kf)";
            feedbackEnterType = "2";
        } else if (this.mFromType == 3) {
            feedbackEnterType = "1";
        }
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023807").put("function_id", "feedback_submit_click").put("feedback_enter_type", feedbackEnterType));
        if (this.isReportBug) {
            SimpleDateFormat dateFormat = CommonUtils.getSimpleDateFormat((String)"yyyy-MM-dd HH:mm:ss");
            String time = DateUtils.getTimeFromMillisecond((Long)this.mWindowOpenTime, (SimpleDateFormat)dateFormat);
            int uploadFileSize = FeedbackUploader.getInstance().getUploadFileSizeMaxLimit();
            UploadRequestInfo info = new UploadRequestInfo(time, msg, contactInfo, imgPath, 0L, 0L, uploadFileSize, 0, videoPath);
            FeedbackUploader.getInstance().reportBug(info, new FeedbackUploader.IUploadCallBack(){

                @Override
                public void success() {
                    YYTaskExecutor.removeTask((Runnable)FeedbackController.this.timeoutTask);
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            MLog.info((Object)FeedbackController.TAG, (String)"onReportBug success!", (Object[])new Object[0]);
                            SingleToastUtil.showToast((Context)FeedbackController.this.mContext, (String)"\u63d0bug\u6210\u529f\uff0c\u8c22\u8c22");
                            FeedbackController.this.mDialogLinkManager.dismissDialog();
                            FeedbackController.this.sendMessage(MixBaseMsgDef.CLOSE_WINDOW_FEEDBACK);
                        }
                    });
                }

                @Override
                public void onError(final int errorCode, String des) {
                    YYTaskExecutor.removeTask((Runnable)FeedbackController.this.timeoutTask);
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            MLog.info((Object)FeedbackController.TAG, (String)"onfeedback onError!", (Object[])new Object[0]);
                            FeedbackController.this.mDialogLinkManager.dismissDialog();
                            if (errorCode == 2 && RuntimeContext.sIsDebuggable) {
                                SingleToastUtil.showToast((Context)FeedbackController.this.mContext, (String)ResourceUtils.getString((int)R.string.feedback_compress_log_fail));
                            } else {
                                SingleToastUtil.showToast((Context)FeedbackController.this.mContext, (String)ResourceUtils.getString((int)R.string.feedback_error));
                            }
                        }
                    });
                }
            });
            return;
        }
        if (feedbackType == 6) {
            if (this.repealController == null) {
                this.repealController = new ReportRepealController(this.getEnvironment());
            }
            final String finalMsg = msg;
            this.repealController.uploadRepeal(imgPath, msg, contactInfo, new FeedbackUploader.IUploadCallBack(){

                @Override
                public void success() {
                    MLog.info((Object)FeedbackController.TAG, (String)"uploadRepeal success", (Object[])new Object[0]);
                    YYTaskExecutor.removeTask((Runnable)FeedbackController.this.timeoutTask);
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            SingleToastUtil.showToast((Context)FeedbackController.this.mContext, (String)ResourceUtils.getString((int)R.string.short_tips_feedback_success));
                            FeedbackController.this.mDialogLinkManager.dismissDialog();
                            FeedbackController.this.sendMessage(MixBaseMsgDef.CLOSE_WINDOW_FEEDBACK);
                            if (FeedbackController.this.comeFormBanned) {
                                FeedbackController.this.sendMessage(LoginBaseMsgDef.MSG_LOGIN_OUT, 3, -1, null);
                                FeedbackController.this.comeFormBanned = false;
                            }
                        }
                    });
                    FeedbackController.this.sendImToOfficial(feedbackType, finalMsg, contactInfo, "", "", ((FeedbackController)FeedbackController.this).mCountry.countryName);
                    FeedbackController.this.reportFeedBackFrom(FeedbackController.this.mFromType);
                }

                @Override
                public void onError(int errorCode, String des) {
                    YYTaskExecutor.removeTask((Runnable)FeedbackController.this.timeoutTask);
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            SingleToastUtil.showToast((Context)FeedbackController.this.mContext, (String)ResourceUtils.getString((int)R.string.feedback_success));
                            FeedbackController.this.mDialogLinkManager.dismissDialog();
                            FeedbackController.this.sendMessage(MixBaseMsgDef.CLOSE_WINDOW_FEEDBACK);
                            if (FeedbackController.this.comeFormBanned) {
                                FeedbackController.this.sendMessage(LoginBaseMsgDef.MSG_LOGIN_OUT, 3, -1, null);
                                FeedbackController.this.comeFormBanned = false;
                            }
                        }
                    });
                    FeedbackController.this.sendImToOfficial(feedbackType, finalMsg, contactInfo, "", "", ((FeedbackController)FeedbackController.this).mCountry.countryName);
                    FeedbackController.this.reportFeedBackFrom(FeedbackController.this.mFromType);
                }
            });
            return;
        }
        this.reallyFeedBack(feedbackType, imgPath, videoPath, msg, contactInfo, null);
    }

    private void reallyFeedBack(int feedbackType, String imgPath, String videoPath, String msg, String contactInfo, FeedbackCallBack callBack) {
        this.reallyFeedBack(feedbackType, imgPath, videoPath, msg, contactInfo, false, callBack);
    }

    private void reallyFeedBack(final int feedbackType, String imgPath, String videoPath, final String msg, final String contactInfo, final boolean silent, final FeedbackCallBack callBack) {
        SimpleDateFormat dateFormat = CommonUtils.getSimpleDateFormat((String)"yyyy-MM-dd HH:mm:ss");
        String time = DateUtils.getTimeFromMillisecond((Long)this.mWindowOpenTime, (SimpleDateFormat)dateFormat);
        int uploadFileSize = FeedbackUploader.getInstance().getUploadFileSizeMaxLimit();
        UploadRequestInfo info = new UploadRequestInfo(time, msg, contactInfo, imgPath, 0L, 0L, uploadFileSize, 0, videoPath);
        FeedbackUploader.getInstance().reportFeedback(info, new FeedbackUploader.IUploadCallBack(){

            @Override
            public void success() {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        MLog.info((Object)FeedbackController.TAG, (String)"onfeedback success! silent: %b", (Object[])new Object[]{silent});
                        if (silent) {
                            if (callBack != null) {
                                callBack.onSuccess();
                            }
                        } else {
                            if (callBack != null) {
                                callBack.onSuccess();
                            } else {
                                SingleToastUtil.showToast((Context)FeedbackController.this.mContext, (String)ResourceUtils.getString((int)R.string.short_tips_feedback_success));
                            }
                            FeedbackController.this.mDialogLinkManager.dismissDialog();
                            FeedbackController.this.sendMessage(MixBaseMsgDef.CLOSE_WINDOW_FEEDBACK);
                            FeedbackController.this.sendImToOfficial(feedbackType, msg, contactInfo, "", "", ((FeedbackController)FeedbackController.this).mCountry.countryName);
                        }
                    }
                });
                FeedbackController.this.reportFeedBackFrom(FeedbackController.this.mFromType);
            }

            @Override
            public void onError(final int errorCode, final String des) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        MLog.info((Object)FeedbackController.TAG, (String)"onfeedback onError errorCode:%d errorDes:%s!", (Object[])new Object[]{errorCode, des});
                        if (silent) {
                            if (callBack != null) {
                                callBack.onError(errorCode, des);
                            }
                        } else {
                            FeedbackController.this.mDialogLinkManager.dismissDialog();
                            if (errorCode == 2 && RuntimeContext.sIsDebuggable) {
                                SingleToastUtil.showToast((Context)FeedbackController.this.mContext, (String)ResourceUtils.getString((int)R.string.feedback_compress_log_fail));
                            } else {
                                SingleToastUtil.showToast((Context)FeedbackController.this.mContext, (String)ResourceUtils.getString((int)R.string.feedback_error));
                            }
                            if (callBack != null) {
                                callBack.onError(errorCode, des);
                            }
                        }
                    }
                });
            }
        });
    }

    @Override
    public void onImgChooseBtnClicked() {
        AlbumConfig config = new AlbumConfig();
        config.maxCount = 1;
        config.type = 1;
        config.styleType = 4;
        config.mMediaMode = 4;
        FeatureLog.i((String)"FTCustomerServiceBase", (String)"Js openCameraOrAlbum and type: %d", (Object[])new Object[]{4});
        ((ICameraService)ServiceManagerProxy.getServiceManager().getService(ICameraService.class)).chooseFromGallery("FTCustomerServiceBase", 6, config, this.mOnCameraCallbak);
    }

    @Override
    public void onBackIconClicked() {
        if (this.mWindow != null) {
            this.mWindowMgr.popWindow(true, (AbstractWindow)this.mWindow);
            if (this.comeFormBanned) {
                MLog.info((Object)TAG, (String)"comeFormBanned logout!", (Object[])new Object[0]);
                this.sendMessage(LoginBaseMsgDef.MSG_LOGIN_OUT, 3, -1, null);
                this.comeFormBanned = false;
            }
        }
    }

    protected boolean onWindowBackKeyEvent() {
        if (this.mWindowMgr.getCurrentWindow() == this.mWindow) {
            this.onBackIconClicked();
            return true;
        }
        return super.onWindowBackKeyEvent();
    }

    @Override
    public void onCountrySelectClicked() {
        if (this.mCountrySelectWindow == null) {
            this.mCountrySelectWindow = new CountrySelectWindow(this.mContext, (ICountrySelectCallBack)this);
        }
        this.mWindowMgr.pushWindow((AbstractWindow)this.mCountrySelectWindow, true);
    }

    public void onBackIconClicked(AbstractWindow window) {
        if (window == this.mCountrySelectWindow) {
            this.mWindowMgr.popWindow(true, (AbstractWindow)this.mCountrySelectWindow);
            this.mCountrySelectWindow = null;
        }
    }

    public void onCountrySelected(CountryHelper.CountryInfo info) {
        if (this.mCountrySelectWindow != null) {
            this.mWindowMgr.popWindow(true, (AbstractWindow)this.mCountrySelectWindow);
            this.mCountrySelectWindow = null;
        }
        this.mCountry.countryCode = info.numberCode;
        this.mCountry.countryName = info.code;
        if (this.mWindow != null && this.mCountry.countryCode != null && this.mCountry.countryName != null) {
            this.mWindow.updateCountry(this.mCountry.countryName + " +" + this.mCountry.countryCode);
        }
    }

    private void sendImToOfficial(int feedbackType, String content, String contact, String logUrl, String picUrl, String country) {
        FeedbackBean feedbackBean = new FeedbackBean();
        feedbackBean.setType(feedbackType);
        feedbackBean.setUid(AccountUtil.getUid());
        feedbackBean.setPlatform("Android");
        feedbackBean.setVersion(VersionUtil.getLocalVer((Context)RuntimeContext.sApplicationContext).feedbackVersionName(RuntimeContext.sApplicationContext));
        feedbackBean.setPhoneType(Build.MODEL);
        feedbackBean.setSystem(Build.VERSION.RELEASE);
        feedbackBean.setContent(content);
        feedbackBean.setContact(contact);
        feedbackBean.setLogUrl(logUrl);
        feedbackBean.setPicUrl(picUrl);
        feedbackBean.setCountry(country);
        YYTaskExecutor.execute(() -> {
            ImMsgReqParam msg = ImDataFactory.INSTANCE.sendFeedbackMsg(10L, feedbackBean);
            ((ImService)this.getServiceManager().getService(ImService.class)).getSendService().sendOldIMHttpMsg(msg, null);
        });
    }

    private void reportFeedBackFrom(int from) {
        StatisContent statContent = new StatisContent();
        statContent.put("act", "hagoperf");
        statContent.put("ifield", from);
        statContent.put("perftype", "feedbackf");
        HiidoStatis.reportContent((StatisContent)statContent);
    }
}

