/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.mixmodule.feedback;

import android.os.Build;
import android.view.View;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.ResourceUtils;
import com.yy.hiyo.mixmodule.R;
import com.yy.hiyo.mixmodule.feedback.FeedBackTypeItemInfo;
import com.yy.hiyo.mixmodule.feedback.request.uploadUtil.FeedBackItemClickListener;

public class FeedBackTypeViewHolder
extends RecyclerView.ViewHolder {
    private static final String TAG = "FeedBackTypeViewHolder";
    private YYTextView feedbackType;
    public View rootView;
    private FeedBackTypeItemInfo itemInfo;
    private FeedBackItemClickListener listener;
    private int position;
    private String result;

    public FeedBackTypeViewHolder(View itemView) {
        super(itemView);
        this.rootView = itemView;
        this.feedbackType = (YYTextView)itemView.findViewById(R.id.fk_types);
        this.feedbackType.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                FeedBackTypeViewHolder.this.listener.itemClick(FeedBackTypeViewHolder.this.itemInfo, FeedBackTypeViewHolder.this.position);
            }
        });
    }

    public void bindViewHolder(int position, FeedBackTypeItemInfo itemInfo) {
        if (itemInfo == null) {
            return;
        }
        this.position = position;
        this.itemInfo = itemInfo;
        this.feedbackType.setText((CharSequence)this.getTypeContent(itemInfo.getType()));
        if (itemInfo.isState()) {
            this.checkRTLDrawable(R.drawable.feedback_radio_pre);
        } else {
            this.checkRTLDrawable(R.drawable.feedback_radio_nor);
        }
    }

    public void setItemClickListener(FeedBackItemClickListener feedBackItemClickListener) {
        this.listener = feedBackItemClickListener;
    }

    private void checkRTLDrawable(int mRadioDrawable) {
        if (Build.VERSION.SDK_INT >= 17) {
            this.feedbackType.setCompoundDrawablesRelativeWithIntrinsicBounds(mRadioDrawable, 0, 0, 0);
        } else {
            this.feedbackType.setCompoundDrawablesWithIntrinsicBounds(mRadioDrawable, 0, 0, 0);
        }
    }

    private String getTypeContent(int type) {
        if (type == 1) {
            this.result = ResourceUtils.getString((int)R.string.login_problem_report);
        } else if (type == 2) {
            this.result = ResourceUtils.getString((int)R.string.short_summary_game_related);
        } else if (type == 3) {
            this.result = ResourceUtils.getString((int)R.string.short_summary_personal_profile);
        } else if (type == 4) {
            this.result = ResourceUtils.getString((int)R.string.short_summary_chat_box);
        } else if (type == 5) {
            this.result = ResourceUtils.getString((int)R.string.short_summary_other_problems);
        } else if (type == 6) {
            this.result = ResourceUtils.getString((int)R.string.appeal_to_report);
        } else if (type == 7) {
            this.result = ResourceUtils.getString((int)R.string.short_summary_recharge_problem);
        } else if (type == 8) {
            this.result = "\u4ea7\u54c1\u4f53\u9a8c";
        } else if (type == 9) {
            this.result = "UI\u89c6\u68c0";
        } else if (type == 10) {
            this.result = "\u529f\u80fdBUG";
        }
        return this.result;
    }
}

